/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_User;
import org.compiere.model.X_AD_UserBPAccess;
import org.compiere.model.X_C_BPartner;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MUser
extends X_AD_User {
    private static CCache<Integer, MUser> s_cache = new CCache("AD_User", 30, 60);
    private static CLogger s_log = CLogger.getCLogger(MUser.class);
    private MRole[] m_roles = null;
    private int m_rolesAD_Org_ID = -1;
    private Boolean m_isAdministrator = null;
    private X_AD_UserBPAccess[] m_bpAccess = null;

    public static MUser[] getOfBPartner(Properties ctx, int C_BPartner_ID) {
        ArrayList<MUser> list = new ArrayList<MUser>();
        String sql = "SELECT * FROM AD_User WHERE C_BPartner_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUser(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MUser[] retValue = new MUser[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MUser[] getWithRole(MRole role) {
        ArrayList<MUser> list = new ArrayList<MUser>();
        String sql = "SELECT * FROM AD_User u WHERE u.IsActive='Y' AND EXISTS (SELECT * FROM AD_User_Roles ur WHERE ur.AD_User_ID=u.AD_User_ID AND ur.AD_Role_ID=? AND ur.IsActive='Y')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, role.getAD_Role_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUser(role.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MUser[] retValue = new MUser[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MUser get(Properties ctx, int AD_User_ID) {
        Integer key = new Integer(AD_User_ID);
        MUser retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MUser(ctx, AD_User_ID, null);
            if (AD_User_ID == 0) {
                String trxName = null;
                retValue.load(trxName);
            }
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MUser get(Properties ctx) {
        return MUser.get(ctx, Env.getAD_User_ID(ctx));
    }

    public static MUser get(Properties ctx, String name, String password) {
        if (name == null || name.length() == 0 || password == null || password.length() == 0) {
            s_log.warning("Invalid Name/Password = " + name + "/" + password);
            return null;
        }
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MUser retValue = null;
        String sql = "SELECT * FROM AD_User WHERE Name=? AND Password=? AND IsActive='Y' AND AD_Client_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, name);
            pstmt.setString(2, password);
            pstmt.setInt(3, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MUser(ctx, rs, null);
                if (rs.next()) {
                    s_log.warning("More then one user with Name/Password = " + name);
                }
            } else {
                s_log.fine("No record");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static String getNameOfUser(int AD_User_ID) {
        String name = "?";
        String sql = "SELECT Name FROM AD_User WHERE AD_User_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        return name;
    }

    public static boolean isSalesRep(int AD_User_ID) {
        if (AD_User_ID == 0) {
            return false;
        }
        String sql = "SELECT MAX(AD_User_ID) FROM AD_User u INNER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) WHERE bp.IsSalesRep='Y' AND AD_User_ID=?";
        int no = DB.getSQLValue(null, sql, AD_User_ID);
        return no == AD_User_ID;
    }

    public MUser(Properties ctx, int AD_User_ID, String trxName) {
        super(ctx, AD_User_ID, trxName);
        if (AD_User_ID == 0) {
            this.setIsFullBPAccess(true);
            this.setNotificationType("E");
        }
    }

    public MUser(X_C_BPartner partner) {
        this(partner.getCtx(), 0, partner.get_TrxName());
        this.setClientOrg(partner);
        this.setC_BPartner_ID(partner.getC_BPartner_ID());
        this.setName(partner.getName());
    }

    public MUser(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getValue() {
        String s = super.getValue();
        if (s != null) {
            return s;
        }
        this.setValue(null);
        return super.getValue();
    }

    public void setValue(String Value) {
        String result;
        if (Value == null || Value.trim().length() == 0) {
            Value = this.getLDAPUser();
        }
        if (Value == null || Value.length() == 0) {
            Value = this.getName();
        }
        if (Value == null || Value.length() == 0) {
            Value = "noname";
        }
        if ((result = this.cleanValue(Value)).length() > 8) {
            String first = this.getName(Value, true);
            String last = this.getName(Value, false);
            if (last.length() > 0) {
                String temp = last;
                if (first.length() > 0) {
                    temp = first.substring(0, 1) + last;
                }
                result = this.cleanValue(temp);
            } else {
                result = this.cleanValue(first);
            }
        }
        if (result.length() > 8) {
            result = result.substring(0, 8);
        }
        super.setValue(result);
    }

    private String cleanValue(String value) {
        char[] chars = value.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char ch = chars[i2];
            if (((ch = Character.toLowerCase(ch)) < '0' || ch > '9') && (ch < 'a' || ch > 'z')) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public String getFirstName() {
        return this.getName(this.getName(), true);
    }

    public String getLastName() {
        return this.getName(this.getName(), false);
    }

    private String getName(String name, boolean getFirst) {
        if (name == null || name.length() == 0) {
            return "";
        }
        String first = null;
        String last = null;
        boolean lastFirst = name.indexOf(44) != -1;
        StringTokenizer st = null;
        st = lastFirst ? new StringTokenizer(name, ",") : new StringTokenizer(name, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (lastFirst) {
                if (last == null) {
                    last = s;
                    continue;
                }
                if (first != null) continue;
                first = s;
                continue;
            }
            if (first == null) {
                first = s;
                continue;
            }
            last = s;
        }
        if (getFirst) {
            if (first == null) {
                return "";
            }
            return first.trim();
        }
        if (last == null) {
            return "";
        }
        return last.trim();
    }

    public void addDescription(String description) {
        if (description == null || description.length() == 0) {
            return;
        }
        String descr = this.getDescription();
        if (descr == null || descr.length() == 0) {
            this.setDescription(description);
        } else {
            this.setDescription(descr + " - " + description);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MUser[").append(this.get_ID()).append(",Name=").append(this.getName()).append(",EMailUserID=").append(this.getEMailUser()).append("]");
        return sb.toString();
    }

    public boolean isOnline() {
        return this.getEMail() != null && this.getPassword() != null;
    }

    public void setEMail(String EMail2) {
        super.setEMail(EMail2);
        this.setEMailVerifyDate(null);
    }

    public InternetAddress getInternetAddress() {
        String email = this.getEMail();
        if (email == null || email.length() == 0) {
            return null;
        }
        try {
            InternetAddress ia = new InternetAddress(email, true);
            if (ia != null) {
                ia.validate();
            }
            return ia;
        }
        catch (AddressException ex) {
            this.log.warning(email + " - " + ex.getLocalizedMessage());
            return null;
        }
    }

    private String validateEmail(InternetAddress ia) {
        if (ia == null) {
            return "NoEmail";
        }
        return null;
    }

    public boolean isEMailValid() {
        return this.validateEmail(this.getInternetAddress()) == null;
    }

    public boolean isCanSendEMail() {
        String s = this.getEMailUser();
        if (s == null || s.length() == 0) {
            return false;
        }
        s = this.getEMailUserPW();
        return s != null && s.length() > 0;
    }

    public String getEMailVerifyCode() {
        long code = this.getAD_User_ID() + this.getName().hashCode();
        return "C" + String.valueOf(Math.abs(code)) + "C";
    }

    public boolean setEMailVerifyCode(String code, String info) {
        boolean ok;
        boolean bl = ok = code != null && code.equals(this.getEMailVerifyCode());
        if (ok) {
            this.setEMailVerifyDate(new Timestamp(System.currentTimeMillis()));
        } else {
            this.setEMailVerifyDate(null);
        }
        this.setEMailVerify(info);
        return ok;
    }

    public boolean isEMailVerified() {
        return this.getEMailVerifyDate() != null && this.getEMailVerify() != null && this.getEMailVerify().length() > 0;
    }

    public boolean isNotificationEMail() {
        String s = this.getNotificationType();
        return s == null || "E".equals(s);
    }

    public boolean isNotificationNote() {
        String s = this.getNotificationType();
        return s != null && "N".equals(s);
    }

    public MRole[] getRoles(int AD_Org_ID) {
        if (this.m_roles != null && this.m_rolesAD_Org_ID == AD_Org_ID) {
            return this.m_roles;
        }
        ArrayList<MRole> list = new ArrayList<MRole>();
        String sql = "SELECT * FROM AD_Role r WHERE r.IsActive='Y' AND EXISTS (SELECT * FROM AD_Role_OrgAccess ro WHERE r.AD_Role_ID=ro.AD_Role_ID AND ro.IsActive='Y' AND ro.AD_Org_ID=?) AND EXISTS (SELECT * FROM AD_User_Roles ur WHERE r.AD_Role_ID=ur.AD_Role_ID AND ur.IsActive='Y' AND ur.AD_User_ID=?) ORDER BY AD_Role_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, AD_Org_ID);
            pstmt.setInt(2, this.getAD_User_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRole(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_rolesAD_Org_ID = AD_Org_ID;
        this.m_roles = new MRole[list.size()];
        list.toArray(this.m_roles);
        return this.m_roles;
    }

    public boolean isAdministrator() {
        if (this.m_isAdministrator == null) {
            this.m_isAdministrator = Boolean.FALSE;
            MRole[] roles = this.getRoles(0);
            for (int i2 = 0; i2 < roles.length; ++i2) {
                if (roles[i2].getAD_Role_ID() != 0) continue;
                this.m_isAdministrator = Boolean.TRUE;
                break;
            }
        }
        return this.m_isAdministrator;
    }

    public boolean hasBPAccess(String BPAccessType, Object[] params) {
        if (this.isFullBPAccess()) {
            return true;
        }
        this.getBPAccess(false);
        for (int i2 = 0; i2 < this.m_bpAccess.length; ++i2) {
            if (!this.m_bpAccess[i2].getBPAccessType().equals(BPAccessType)) continue;
            return true;
        }
        return false;
    }

    public X_AD_UserBPAccess[] getBPAccess(boolean requery) {
        if (this.m_bpAccess != null && !requery) {
            return this.m_bpAccess;
        }
        String sql = "SELECT * FROM AD_UserBPAccess WHERE AD_User_ID=? AND IsActive='Y'";
        ArrayList<X_AD_UserBPAccess> list = new ArrayList<X_AD_UserBPAccess>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_User_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_AD_UserBPAccess(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_bpAccess = new X_AD_UserBPAccess[list.size()];
        list.toArray(this.m_bpAccess);
        return this.m_bpAccess;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("EMail")) {
            this.setEMailVerifyDate(null);
        }
        if (newRecord || super.getValue() == null || this.is_ValueChanged("Value")) {
            this.setValue(super.getValue());
        }
        return true;
    }
}

