/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTree_Base;
import org.compiere.model.X_AD_TreeNodeCMC;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MTree_NodeCMC
extends X_AD_TreeNodeCMC {
    private static CLogger s_log = CLogger.getCLogger(MTree_NodeCMC.class);

    public static MTree_NodeCMC[] getTree(Properties ctx, int AD_Tree_ID, String trxName) {
        ArrayList<MTree_NodeCMC> list = new ArrayList<MTree_NodeCMC>();
        String sql = "SELECT * FROM AD_TreeNodeCMC WHERE AD_Tree_ID=? ORDER BY Node_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Tree_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTree_NodeCMC(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MTree_NodeCMC[] retValue = new MTree_NodeCMC[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MTree_NodeCMC get(MTree_Base tree, int Node_ID) {
        MTree_NodeCMC retValue = null;
        String sql = "SELECT * FROM AD_TreeNodeCMC WHERE AD_Tree_ID=? AND Node_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, tree.get_TrxName());
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, Node_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MTree_NodeCMC(tree.getCtx(), rs, tree.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "get", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MTree_NodeCMC(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTree_NodeCMC(MTree_Base tree, int Node_ID) {
        super(tree.getCtx(), 0, tree.get_TrxName());
        this.setClientOrg(tree);
        this.setAD_Tree_ID(tree.getAD_Tree_ID());
        this.setNode_ID(Node_ID);
        this.setParent_ID(0);
        this.setSeqNo(0);
    }

    public void setParent_ID(int Parent_ID) {
        this.set_Value("Parent_ID", (Object)new Integer(Parent_ID));
    }
}

