/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.db.LDAP;
import org.compiere.model.X_AD_System;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CMemoryUsage;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class MSystem
extends X_AD_System {
    private static CLogger s_log = CLogger.getCLogger(MSystem.class);
    private static MSystem s_system = null;

    public static MSystem get(Properties ctx) {
        if (s_system != null) {
            return s_system;
        }
        String sql = "SELECT * FROM AD_System ORDER BY AD_System_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                s_system = new MSystem(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, "get", ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
        if (s_system == null) {
            return null;
        }
        if (!Ini.isClient() && s_system.setInfo()) {
            s_system.save();
        }
        return s_system;
    }

    public MSystem(Properties ctx, int ignored, String mtrxName) {
        super(ctx, 0, mtrxName);
        String trxName = null;
        this.load(trxName);
        if (s_system == null) {
            s_system = this;
        }
    }

    public MSystem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        if (s_system == null) {
            s_system = this;
        }
    }

    public MSystem() {
        this(new Properties(), 0, null);
    }

    public boolean isLDAP() {
        String host = this.getLDAPHost();
        if (host == null || host.length() == 0) {
            return false;
        }
        String domain = this.getLDAPDomain();
        return domain != null && domain.length() > 0;
    }

    public boolean isLDAP(String userName, String password) {
        return LDAP.validate(this.getLDAPHost(), this.getLDAPDomain(), userName, password);
    }

    public String getDBAddress() {
        String s = super.getDBAddress();
        if (s == null || s.length() == 0) {
            s = CConnection.get().getConnectionURL();
        }
        return s;
    }

    public String getStatisticsInfo(boolean recalc) {
        String s = super.getStatisticsInfo();
        if (DB.isDB2() || DB.isDerby()) {
            s = "NO Compiere statistics for DB2 or Derby.";
            recalc = false;
        }
        if (s == null || recalc) {
            String sql = "SELECT 'C'||(SELECT COUNT(*) FROM AD_Client)||'U'||(SELECT COUNT(*) FROM AD_User)||'B'||(SELECT COUNT(*) FROM C_BPartner)||'P'||(SELECT COUNT(*) FROM M_Product)||'I'||(SELECT COUNT(*) FROM C_Invoice)||'M'||(SELECT COUNT(*) FROM M_Transaction) FROM AD_System";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    s = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        return s;
    }

    public String getProfileInfo(boolean recalc) {
        String s = super.getProfileInfo();
        if (s == null || recalc) {
            String sql = "SELECT Value FROM AD_Client WHERE IsActive='Y' ORDER BY AD_Client_ID DESC";
            CPreparedStatement pstmt = null;
            StringBuffer sb = new StringBuffer();
            try {
                pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    sb.append(rs.getString(1)).append('|');
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            s = sb.toString();
        }
        return s;
    }

    protected boolean beforeSave(boolean newRecord) {
        boolean userChange;
        if (this.get_Value("IsAutoErrorReport") == null) {
            this.setIsAutoErrorReport(true);
        }
        boolean bl = userChange = Ini.isClient() && (this.is_ValueChanged("Name") || this.is_ValueChanged("UserName") || this.is_ValueChanged("Password") || this.is_ValueChanged("LDAPHost") || this.is_ValueChanged("LDAPDomain") || this.is_ValueChanged("CustomPrefix"));
        if (userChange) {
            String name = this.getName();
            if (name.equals("?") || name.length() < 2) {
                this.log.saveError("Error", "Define a unique System name (e.g. Company name) not " + name);
                return false;
            }
            if (this.getUserName().equals("?") || this.getUserName().length() < 2) {
                this.log.saveError("Error", "Use the same EMail address as in the Adempiere Web Store");
                return false;
            }
            if (this.getPassword().equals("?") || this.getPassword().length() < 2) {
                this.log.saveError("Error", "Use the same Password as in the Adempiere Web Store");
                return false;
            }
        }
        this.setInfo();
        return true;
    }

    public boolean save() {
        if (!this.beforeSave(false)) {
            return false;
        }
        return this.saveUpdate();
    }

    public String toString() {
        return "MSystem[" + this.getName() + ",User=" + this.getUserName() + ",ReleaseNo=" + this.getReleaseNo() + "]";
    }

    public boolean isValid() {
        if (this.getName() == null || this.getName().length() < 2) {
            this.log.log(Level.WARNING, "Name not valid: " + this.getName());
            return false;
        }
        if (this.getPassword() == null || this.getPassword().length() < 2) {
            this.log.log(Level.WARNING, "Password not valid: " + this.getPassword());
            return false;
        }
        if (this.getInfo() == null || this.getInfo().length() < 2) {
            this.log.log(Level.WARNING, "Need to run Migration once");
            return false;
        }
        return true;
    }

    public boolean isPDFLicense() {
        String key = this.getSummary();
        return key != null && key.length() > 25;
    }

    public boolean setInfo() {
        if (!TimeUtil.getDay(this.getUpdated()).before(TimeUtil.getDay(null))) {
            return false;
        }
        try {
            this.setDBInfo();
            this.setInternalUsers();
            if (this.isAllowStatistics()) {
                this.setStatisticsInfo(this.getStatisticsInfo(true));
                this.setProfileInfo(this.getProfileInfo(true));
            }
        }
        catch (Exception e) {
            this.setSupportUnits(9999);
            this.setInfo(e.getLocalizedMessage());
            this.log.log(Level.SEVERE, "", e);
        }
        return true;
    }

    private void setInternalUsers() {
        String sql = "SELECT COUNT(DISTINCT (u.AD_User_ID)) AS iu FROM AD_User u INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID) WHERE u.AD_Client_ID<>11 AND u.AD_User_ID NOT IN (0,100)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int internalUsers = rs.getInt(1);
                this.setSupportUnits(internalUsers);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private void setDBInfo() {
        if (!DB.isRemoteObjects()) {
            String dbAddress = CConnection.get().getConnectionURL();
            this.setDBAddress(dbAddress.toLowerCase());
        }
        if (!Ini.isClient()) {
            int noProcessors = Runtime.getRuntime().availableProcessors();
            this.setNoProcessors(noProcessors);
        }
        String dbName = null;
        CPreparedStatement pstmt = null;
        String sql = null;
        try {
            String dbType = CConnection.get().getDatabase().getName();
            sql = MSystem.getDBInfoSQL(dbType);
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                dbName = rs.getString(2);
                this.setDBInstance(dbName.toLowerCase());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    public static String getDBInfoSQL(String dbType) {
        if (Database.DB_ORACLE.equals(dbType)) {
            return "SELECT SYS_CONTEXT('USERENV','HOST') || '/' || SYS_CONTEXT('USERENV','IP_ADDRESS') AS DBAddress,\tSYS_CONTEXT('USERENV','CURRENT_USER') || '.' || SYS_CONTEXT('USERENV','DB_NAME') || '.' || SYS_CONTEXT('USERENV','DB_DOMAIN') AS DBName FROM DUAL";
        }
        return "SELECT NULL,NULL FROM AD_System WHERE AD_System_ID=-1";
    }

    public void info() {
        if (!CLogMgt.isLevelFine()) {
            return;
        }
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        this.log.fine(rt.getName() + " (" + rt.getVmVersion() + ") Up=" + TimeUtil.formatElapsed(rt.getUptime()));
        if (CLogMgt.isLevelFiner()) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : list) {
                this.log.finer(pool.getName() + " " + (Object)((Object)pool.getType()) + ": " + new CMemoryUsage(pool.getUsage()));
            }
        } else {
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            this.log.fine("VM: " + new CMemoryUsage(memory.getNonHeapMemoryUsage()));
            this.log.fine("Heap: " + new CMemoryUsage(memory.getHeapMemoryUsage()));
        }
        ThreadMXBean th2 = ManagementFactory.getThreadMXBean();
        this.log.fine("Threads=" + th2.getThreadCount() + ", Peak=" + th2.getPeakThreadCount() + ", Demons=" + th2.getDaemonThreadCount() + ", Total=" + th2.getTotalStartedThreadCount());
    }

    public static void main(String[] args) {
        new MSystem();
    }
}

