/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MProcess;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MSchedulerRecipient;
import org.compiere.model.MUserRoles;
import org.compiere.model.X_AD_Scheduler;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MScheduler
extends X_AD_Scheduler
implements AdempiereProcessor {
    private static CLogger s_log = CLogger.getCLogger(MScheduler.class);
    private MSchedulerPara[] m_parameter = null;
    private MSchedulerRecipient[] m_recipients = null;

    public static MScheduler[] getActive(Properties ctx) {
        ArrayList<MScheduler> list = new ArrayList<MScheduler>();
        String sql = "SELECT * FROM AD_Scheduler WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MScheduler(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MScheduler[] retValue = new MScheduler[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MScheduler(Properties ctx, int AD_Scheduler_ID, String trxName) {
        super(ctx, AD_Scheduler_ID, trxName);
        if (AD_Scheduler_ID == 0) {
            this.setScheduleType("F");
            this.setFrequencyType("D");
            this.setKeepLogDays(7);
        }
    }

    public MScheduler(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getServerID() {
        return "Scheduler" + this.get_ID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MSchedulerLog> list = new ArrayList<MSchedulerLog>();
        String sql = "SELECT * FROM AD_SchedulerLog WHERE AD_Scheduler_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Scheduler_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSchedulerLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MSchedulerLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE AD_SchedulerLog WHERE AD_Scheduler_ID=" + this.getAD_Scheduler_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    public MProcess getProcess() {
        return MProcess.get(this.getCtx(), this.getAD_Process_ID());
    }

    public MSchedulerPara[] getParameters(boolean reload) {
        if (!reload && this.m_parameter != null) {
            return this.m_parameter;
        }
        ArrayList<MSchedulerPara> list = new ArrayList<MSchedulerPara>();
        String sql = "SELECT * FROM AD_Scheduler_Para WHERE AD_Scheduler_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Scheduler_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSchedulerPara(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_parameter = new MSchedulerPara[list.size()];
        list.toArray(this.m_parameter);
        return this.m_parameter;
    }

    public MSchedulerRecipient[] getRecipients(boolean reload) {
        if (!reload && this.m_recipients != null) {
            return this.m_recipients;
        }
        ArrayList<MSchedulerRecipient> list = new ArrayList<MSchedulerRecipient>();
        String sql = "SELECT * FROM AD_SchedulerRecipient WHERE AD_Scheduler_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Scheduler_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSchedulerRecipient(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_recipients = new MSchedulerRecipient[list.size()];
        list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public Integer[] getRecipientAD_User_IDs() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        MSchedulerRecipient[] recipients = this.getRecipients(false);
        for (int i2 = 0; i2 < recipients.length; ++i2) {
            Integer ii;
            MSchedulerRecipient recipient = recipients[i2];
            if (!recipient.isActive()) continue;
            if (recipient.getAD_User_ID() != 0 && !list.contains(ii = new Integer(recipient.getAD_User_ID()))) {
                list.add(ii);
            }
            if (recipient.getAD_Role_ID() == 0) continue;
            MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), recipient.getAD_Role_ID());
            for (int j = 0; j < urs.length; ++j) {
                Integer ii2;
                MUserRoles ur = urs[j];
                if (!ur.isActive() || list.contains(ii2 = new Integer(ur.getAD_User_ID()))) continue;
                list.add(ii2);
            }
        }
        if (list.size() == 0) {
            Integer ii = new Integer(this.getUpdatedBy());
            list.add(ii);
        }
        Integer[] recipientIDs = new Integer[list.size()];
        list.toArray(recipientIDs);
        return recipientIDs;
    }

    protected boolean beforeSave(boolean newRecord) {
        if ("F".equals(this.getScheduleType())) {
            if (this.getFrequencyType() == null) {
                this.setFrequencyType("D");
            }
            if (this.getFrequency() < 1) {
                this.setFrequency(1);
            }
        } else if ("M".equals(this.getScheduleType())) {
            if (this.getMonthDay() < 1 || this.getMonthDay() > 31) {
                this.setMonthDay(1);
            }
        } else {
            if (this.getScheduleType() == null) {
                this.setScheduleType("W");
            }
            if (this.getWeekDay() == null) {
                this.setWeekDay("1");
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MScheduler[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

