/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.MClient;
import org.compiere.model.MColumnAccess;
import org.compiere.model.MOrg;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MTableAccess;
import org.compiere.model.MTree_Base;
import org.compiere.model.MUserOrgAccess;
import org.compiere.model.MUserRoles;
import org.compiere.model.X_AD_Role;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MRole
extends X_AD_Role {
    private static MRole s_defaultRole = null;
    private static CCache<String, MRole> s_roles = new CCache("AD_Role", 5);
    private static CLogger s_log = CLogger.getCLogger(MRole.class);
    public static final boolean SQL_RW = true;
    public static final boolean SQL_RO = false;
    public static final boolean SQL_FULLYQUALIFIED = true;
    public static final boolean SQL_NOTQUALIFIED = false;
    public static final int SUPERUSER_USER_ID = 100;
    public static final int SYSTEM_USER_ID = 0;
    private int m_AD_User_ID = -1;
    private OrgAccess[] m_orgAccess = null;
    private MTableAccess[] m_tableAccess = null;
    private MColumnAccess[] m_columnAccess = null;
    private MRecordAccess[] m_recordAccess = null;
    private MRecordAccess[] m_recordDependentAccess = null;
    private HashMap<Integer, String> m_tableAccessLevel = null;
    private HashMap<String, Integer> m_tableName = null;
    private HashMap<Integer, Boolean> m_windowAccess = null;
    private HashMap<Integer, Boolean> m_processAccess = null;
    private HashMap<Integer, Boolean> m_taskAccess = null;
    private HashMap<Integer, Boolean> m_workflowAccess = null;
    private HashMap<Integer, Boolean> m_formAccess = null;

    public static MRole getDefault() {
        if (s_defaultRole == null && Ini.isClient()) {
            return MRole.getDefault(Env.getCtx(), false);
        }
        return s_defaultRole;
    }

    public static MRole getDefault(Properties ctx, boolean reload) {
        int AD_Role_ID = Env.getContextAsInt(ctx, "#AD_Role_ID");
        int AD_User_ID = Env.getContextAsInt(ctx, "#AD_User_ID");
        if (!Ini.isClient()) {
            AD_User_ID = 0;
        }
        if (reload || s_defaultRole == null) {
            s_defaultRole = MRole.get(ctx, AD_Role_ID, AD_User_ID, reload);
        } else if (s_defaultRole.getAD_Role_ID() != AD_Role_ID || s_defaultRole.getAD_User_ID() != AD_User_ID) {
            s_defaultRole = MRole.get(ctx, AD_Role_ID, AD_User_ID, reload);
        }
        return s_defaultRole;
    }

    public static MRole get(Properties ctx, int AD_Role_ID, int AD_User_ID, boolean reload) {
        s_log.info("AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + ", reload=" + reload);
        String key = AD_Role_ID + "_" + AD_User_ID;
        MRole role = s_roles.get(key);
        if (role == null || reload) {
            role = new MRole(ctx, AD_Role_ID, null);
            s_roles.put(key, role);
            if (AD_Role_ID == 0) {
                String trxName = null;
                role.load(trxName);
            }
            role.setAD_User_ID(AD_User_ID);
            role.loadAccess(reload);
            s_log.info(role.toString());
        }
        return role;
    }

    public static MRole get(Properties ctx, int AD_Role_ID) {
        String key = String.valueOf(AD_Role_ID);
        MRole role = s_roles.get(key);
        String trxName = null;
        if (role == null) {
            role = new MRole(ctx, AD_Role_ID, trxName);
            s_roles.put(key, role);
            if (AD_Role_ID == 0) {
                role.load(trxName);
            }
        }
        return role;
    }

    public static MRole[] getOfClient(Properties ctx) {
        String sql = "SELECT * FROM AD_Role WHERE AD_Client_ID=?";
        ArrayList<MRole> list = new ArrayList<MRole>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRole(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MRole[] retValue = new MRole[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MRole[] getOf(Properties ctx, String whereClause) {
        String sql = "SELECT * FROM AD_Role";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause;
        }
        ArrayList<MRole> list = new ArrayList<MRole>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRole(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MRole[] retValue = new MRole[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRole(Properties ctx, int AD_Role_ID, String trxName) {
        super(ctx, AD_Role_ID, trxName);
        if (AD_Role_ID == 0) {
            this.setIsCanExport(true);
            this.setIsCanReport(true);
            this.setIsManual(false);
            this.setIsPersonalAccess(false);
            this.setIsPersonalLock(false);
            this.setIsShowAcct(false);
            this.setIsAccessAllOrgs(false);
            this.setUserLevel("  O");
            this.setPreferenceType("O");
            this.setIsChangeLog(false);
            this.setOverwritePriceLimit(false);
            this.setIsUseUserOrgAccess(false);
            this.setMaxQueryRecords(0);
            this.setConfirmQueryRecords(0);
        }
    }

    public MRole(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public int getConfirmQueryRecords() {
        int no = super.getConfirmQueryRecords();
        if (no == 0) {
            return 500;
        }
        return no;
    }

    public boolean isQueryRequire(int noRecords) {
        if (noRecords < 2) {
            return false;
        }
        int max = this.getMaxQueryRecords();
        if (max > 0 && noRecords > max) {
            return true;
        }
        int qu = this.getConfirmQueryRecords();
        return noRecords > qu;
    }

    public boolean isQueryMax(int noRecords) {
        int max = this.getMaxQueryRecords();
        return max > 0 && noRecords > max;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() == 0) {
            this.setUserLevel("S  ");
        } else if (this.getUserLevel().equals("S  ")) {
            this.log.saveWarning("AccessTableNoUpdate", Msg.getElement(this.getCtx(), "UserLevel"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            MUserRoles su = new MUserRoles(this.getCtx(), 100, this.getAD_Role_ID(), this.get_TrxName());
            su.save();
            if (this.getCreatedBy() != 100) {
                MUserRoles ur = new MUserRoles(this.getCtx(), this.getCreatedBy(), this.getAD_Role_ID(), this.get_TrxName());
                ur.save();
            }
            this.updateAccessRecords();
        } else if (this.is_ValueChanged("UserLevel")) {
            this.updateAccessRecords();
        }
        if (s_defaultRole != null && s_defaultRole.get_ID() == this.get_ID()) {
            s_defaultRole = this;
        }
        return success;
    }

    public String updateAccessRecords() {
        if (this.isManual()) {
            return "-";
        }
        String roleClientOrgUser = this.getAD_Role_ID() + "," + this.getAD_Client_ID() + "," + this.getAD_Org_ID() + ",'Y', SysDate," + this.getUpdatedBy() + ", SysDate," + this.getUpdatedBy() + ",'Y' ";
        String sqlWindow = "INSERT INTO AD_Window_Access (AD_Window_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT w.AD_Window_ID, " + roleClientOrgUser + "FROM AD_Window w" + " INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID)" + " INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) " + "WHERE t.SeqNo=(SELECT MIN(SeqNo) FROM AD_Tab xt " + "WHERE xt.AD_Window_ID=w.AD_Window_ID)" + "AND tt.AccessLevel IN ";
        String sqlProcess = "INSERT INTO AD_Process_Access (AD_Process_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT p.AD_Process_ID, " + roleClientOrgUser + "FROM AD_Process p " + "WHERE AccessLevel IN ";
        String sqlForm = "INSERT INTO AD_Form_Access (AD_Form_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT f.AD_Form_ID, " + roleClientOrgUser + "FROM AD_Form f " + "WHERE AccessLevel IN ";
        String sqlWorkflow = "INSERT INTO AD_WorkFlow_Access (AD_WorkFlow_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT w.AD_WorkFlow_ID, " + roleClientOrgUser + "FROM AD_WorkFlow w " + "WHERE AccessLevel IN ";
        String roleAccessLevel = null;
        String roleAccessLevelWin = null;
        if ("S  ".equals(this.getUserLevel())) {
            roleAccessLevel = "('4','7','6')";
        } else if (" C ".equals(this.getUserLevel())) {
            roleAccessLevel = "('7','6','3','2')";
        } else if (" CO".equals(this.getUserLevel())) {
            roleAccessLevel = "('7','6','3','2','1')";
        } else {
            roleAccessLevel = "('3','1','7')";
            roleAccessLevelWin = roleAccessLevel + " AND w.Name NOT LIKE '%(all)%'";
        }
        if (roleAccessLevelWin == null) {
            roleAccessLevelWin = roleAccessLevel;
        }
        String whereDel = " WHERE AD_Role_ID=" + this.getAD_Role_ID();
        int winDel = DB.executeUpdate("DELETE FROM AD_Window_Access" + whereDel, this.get_TrxName());
        int win = DB.executeUpdate(sqlWindow + roleAccessLevelWin, this.get_TrxName());
        int procDel = DB.executeUpdate("DELETE FROM AD_Process_Access" + whereDel, this.get_TrxName());
        int proc = DB.executeUpdate(sqlProcess + roleAccessLevel, this.get_TrxName());
        int formDel = DB.executeUpdate("DELETE FROM AD_Form_Access" + whereDel, this.get_TrxName());
        int form = DB.executeUpdate(sqlForm + roleAccessLevel, this.get_TrxName());
        int wfDel = DB.executeUpdate("DELETE FROM AD_WorkFlow_Access" + whereDel, this.get_TrxName());
        int wf = DB.executeUpdate(sqlWorkflow + roleAccessLevel, this.get_TrxName());
        this.log.fine("AD_Window_ID=" + winDel + "+" + win + ", AD_Process_ID=" + procDel + "+" + proc + ", AD_Form_ID=" + formDel + "+" + form + ", AD_Workflow_ID=" + wfDel + "+" + wf);
        this.loadAccess(true);
        return "@AD_Window_ID@ #" + win + " -  @AD_Process_ID@ #" + proc + " -  @AD_Form_ID@ #" + form + " -  @AD_Workflow_ID@ #" + wf;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRole[");
        sb.append(this.getAD_Role_ID()).append(",").append(this.getName()).append(",UserLevel=").append(this.getUserLevel()).append(",").append(this.getClientWhere(false)).append(",").append(this.getOrgWhere(false)).append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append(Msg.translate(ctx, "AD_Role_ID")).append("=").append(this.getName()).append(" - ").append(Msg.translate(ctx, "IsCanExport")).append("=").append(this.isCanExport()).append(" - ").append(Msg.translate(ctx, "IsCanReport")).append("=").append(this.isCanReport()).append(Env.NL).append(Env.NL);
        for (i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            sb.append(this.m_orgAccess[i2].toString()).append(Env.NL);
        }
        sb.append(Env.NL);
        this.loadTableAccess(false);
        for (i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            sb.append(this.m_tableAccess[i2].toStringX(ctx)).append(Env.NL);
        }
        if (this.m_tableAccess.length > 0) {
            sb.append(Env.NL);
        }
        this.loadColumnAccess(false);
        for (i2 = 0; i2 < this.m_columnAccess.length; ++i2) {
            sb.append(this.m_columnAccess[i2].toStringX(ctx)).append(Env.NL);
        }
        if (this.m_columnAccess.length > 0) {
            sb.append(Env.NL);
        }
        this.loadRecordAccess(false);
        for (i2 = 0; i2 < this.m_recordAccess.length; ++i2) {
            sb.append(this.m_recordAccess[i2].toStringX(ctx)).append(Env.NL);
        }
        return sb.toString();
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
    }

    public int getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public void loadAccess(boolean reload) {
        this.loadOrgAccess(reload);
        this.loadTableAccess(reload);
        this.loadTableInfo(reload);
        this.loadColumnAccess(reload);
        this.loadRecordAccess(reload);
        if (reload) {
            this.m_windowAccess = null;
            this.m_processAccess = null;
            this.m_taskAccess = null;
            this.m_workflowAccess = null;
            this.m_formAccess = null;
        }
    }

    private void loadOrgAccess(boolean reload) {
        if (!reload && this.m_orgAccess != null) {
            return;
        }
        ArrayList<OrgAccess> list = new ArrayList<OrgAccess>();
        if (this.isUseUserOrgAccess()) {
            this.loadOrgAccessUser(list);
        } else {
            this.loadOrgAccessRole(list);
        }
        this.m_orgAccess = new OrgAccess[list.size()];
        list.toArray(this.m_orgAccess);
        this.log.fine("#" + this.m_orgAccess.length + (reload ? " - reload" : ""));
        if (Ini.isClient()) {
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(this.m_orgAccess[i2].AD_Org_ID);
            }
            Env.setContext(Env.getCtx(), "#User_Org", sb.toString());
        }
    }

    private void loadOrgAccessUser(ArrayList<OrgAccess> list) {
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_User_OrgAccess WHERE AD_User_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_User_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MUserOrgAccess oa = new MUserOrgAccess(this.getCtx(), rs, this.get_TrxName());
                this.loadOrgAccessAdd(list, new OrgAccess(oa.getAD_Client_ID(), oa.getAD_Org_ID(), oa.isReadOnly()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private void loadOrgAccessRole(ArrayList<OrgAccess> list) {
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Role_OrgAccess WHERE AD_Role_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRoleOrgAccess oa = new MRoleOrgAccess(this.getCtx(), rs, this.get_TrxName());
                this.loadOrgAccessAdd(list, new OrgAccess(oa.getAD_Client_ID(), oa.getAD_Org_ID(), oa.isReadOnly()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private void loadOrgAccessAdd(ArrayList<OrgAccess> list, OrgAccess oa) {
        if (list.contains(oa)) {
            return;
        }
        list.add(oa);
        if (this.getAD_Tree_Org_ID() == 0) {
            return;
        }
        MOrg org = MOrg.get(this.getCtx(), oa.AD_Org_ID);
        if (!org.isSummary()) {
            return;
        }
        MTree_Base tree = MTree_Base.get(this.getCtx(), this.getAD_Tree_Org_ID(), this.get_TrxName());
        String sql = "SELECT AD_Client_ID, AD_Org_ID FROM AD_Org WHERE IsActive='Y' AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, org.getAD_Org_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Client_ID = rs.getInt(1);
                int AD_Org_ID = rs.getInt(2);
                this.loadOrgAccessAdd(list, new OrgAccess(AD_Client_ID, AD_Org_ID, oa.readOnly));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private void loadTableAccess(boolean reload) {
        if (this.m_tableAccess != null && !reload) {
            return;
        }
        ArrayList<MTableAccess> list = new ArrayList<MTableAccess>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Table_Access WHERE AD_Role_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTableAccess(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_tableAccess = new MTableAccess[list.size()];
        list.toArray(this.m_tableAccess);
        this.log.fine("#" + this.m_tableAccess.length);
    }

    private void loadTableInfo(boolean reload) {
        if (this.m_tableAccessLevel != null && this.m_tableName != null && !reload) {
            return;
        }
        this.m_tableAccessLevel = new HashMap(300);
        this.m_tableName = new HashMap(300);
        CPreparedStatement pstmt = null;
        String sql = "SELECT AD_Table_ID, AccessLevel, TableName FROM AD_Table WHERE IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer ii = new Integer(rs.getInt(1));
                this.m_tableAccessLevel.put(ii, rs.getString(2));
                this.m_tableName.put(rs.getString(3), ii);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.fine("#" + this.m_tableAccessLevel.size());
    }

    private void loadColumnAccess(boolean reload) {
        if (this.m_columnAccess != null && !reload) {
            return;
        }
        ArrayList<MColumnAccess> list = new ArrayList<MColumnAccess>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Column_Access WHERE AD_Role_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MColumnAccess(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_columnAccess = new MColumnAccess[list.size()];
        list.toArray(this.m_columnAccess);
        this.log.fine("#" + this.m_columnAccess.length);
    }

    private void loadRecordAccess(boolean reload) {
        if (!reload && this.m_recordAccess != null && this.m_recordDependentAccess != null) {
            return;
        }
        ArrayList<MRecordAccess> list = new ArrayList<MRecordAccess>();
        ArrayList<MRecordAccess> dependent = new ArrayList<MRecordAccess>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Record_Access WHERE AD_Role_ID=? AND IsActive='Y' ORDER BY AD_Table_ID";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRecordAccess ra = new MRecordAccess(this.getCtx(), rs, this.get_TrxName());
                list.add(ra);
                if (!ra.isDependentEntities()) continue;
                dependent.add(ra);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_recordAccess = new MRecordAccess[list.size()];
        list.toArray(this.m_recordAccess);
        this.m_recordDependentAccess = new MRecordAccess[dependent.size()];
        dependent.toArray(this.m_recordDependentAccess);
        this.log.fine("#" + this.m_recordAccess.length + " - Dependent #" + this.m_recordDependentAccess.length);
    }

    public String getClientWhere(boolean rw) {
        if (this.isAccessAllOrgs()) {
            if (rw || this.getAD_Client_ID() == 0) {
                return "AD_Client_ID=" + this.getAD_Client_ID();
            }
            return "AD_Client_ID IN (0," + this.getAD_Client_ID() + ")";
        }
        this.loadOrgAccess(false);
        HashSet<String> set = new HashSet<String>();
        if (!rw) {
            set.add("0");
        }
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            set.add(String.valueOf(this.m_orgAccess[i2].AD_Client_ID));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        boolean oneOnly = true;
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
                oneOnly = false;
            }
            sb.append(it.next());
        }
        if (oneOnly) {
            if (sb.length() > 0) {
                return "AD_Client_ID=" + sb.toString();
            }
            this.log.log(Level.SEVERE, "No Access Org records");
            return "AD_Client_ID=-1";
        }
        return "AD_Client_ID IN(" + sb.toString() + ")";
    }

    public boolean isClientAccess(int AD_Client_ID, boolean rw) {
        if (AD_Client_ID == 0 && !rw) {
            return true;
        }
        this.loadOrgAccess(false);
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            if (this.m_orgAccess[i2].AD_Client_ID != AD_Client_ID) continue;
            if (!rw) {
                return true;
            }
            if (this.m_orgAccess[i2].readOnly) continue;
            return true;
        }
        return false;
    }

    public String getOrgWhere(boolean rw) {
        if (this.isAccessAllOrgs()) {
            return null;
        }
        this.loadOrgAccess(false);
        HashSet<String> set = new HashSet<String>();
        if (!rw) {
            set.add("0");
        }
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            if (!rw) {
                set.add(String.valueOf(this.m_orgAccess[i2].AD_Org_ID));
                continue;
            }
            if (this.m_orgAccess[i2].readOnly) continue;
            set.add(String.valueOf(this.m_orgAccess[i2].AD_Org_ID));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        boolean oneOnly = true;
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
                oneOnly = false;
            }
            sb.append(it.next());
        }
        if (oneOnly) {
            if (sb.length() > 0) {
                return "AD_Org_ID=" + sb.toString();
            }
            this.log.log(Level.SEVERE, "No Access Org records");
            return "AD_Org_ID=-1";
        }
        return "AD_Org_ID IN(" + sb.toString() + ")";
    }

    public boolean isOrgAccess(int AD_Org_ID, boolean rw) {
        if (this.isAccessAllOrgs()) {
            return true;
        }
        if (AD_Org_ID == 0 && !rw) {
            return true;
        }
        this.loadOrgAccess(false);
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            if (this.m_orgAccess[i2].AD_Org_ID != AD_Org_ID) continue;
            if (!rw) {
                return true;
            }
            return !this.m_orgAccess[i2].readOnly;
        }
        return false;
    }

    public boolean isCanReport(int AD_Table_ID) {
        if (!this.isCanReport()) {
            this.log.warning("Role denied");
            return false;
        }
        if (!this.isTableAccess(AD_Table_ID, true)) {
            return false;
        }
        boolean canReport = true;
        for (int i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            if (!"R".equals(this.m_tableAccess[i2].getAccessTypeRule())) continue;
            if (this.m_tableAccess[i2].isExclude()) {
                if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
                canReport = this.m_tableAccess[i2].isCanReport();
                this.log.fine("Exclude " + AD_Table_ID + " - " + canReport);
                return canReport;
            }
            canReport = false;
            if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            canReport = this.m_tableAccess[i2].isCanReport();
            this.log.fine("Include " + AD_Table_ID + " - " + canReport);
            return canReport;
        }
        this.log.fine(AD_Table_ID + " - " + canReport);
        return canReport;
    }

    public boolean isCanExport(int AD_Table_ID) {
        if (!this.isCanExport()) {
            this.log.warning("Role denied");
            return false;
        }
        if (!this.isTableAccess(AD_Table_ID, true)) {
            return false;
        }
        if (!this.isCanReport(AD_Table_ID)) {
            return false;
        }
        boolean canExport = true;
        for (int i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            if (!"E".equals(this.m_tableAccess[i2].getAccessTypeRule())) continue;
            if (this.m_tableAccess[i2].isExclude()) {
                canExport = this.m_tableAccess[i2].isCanExport();
                this.log.fine("Exclude " + AD_Table_ID + " - " + canExport);
                return canExport;
            }
            canExport = false;
            canExport = this.m_tableAccess[i2].isCanExport();
            this.log.fine("Include " + AD_Table_ID + " - " + canExport);
            return canExport;
        }
        this.log.fine(AD_Table_ID + " - " + canExport);
        return canExport;
    }

    public boolean isTableAccess(int AD_Table_ID, boolean ro) {
        if (!this.isTableAccessLevel(AD_Table_ID, ro)) {
            return false;
        }
        this.loadTableAccess(false);
        boolean hasAccess = true;
        for (int i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            if (!"A".equals(this.m_tableAccess[i2].getAccessTypeRule())) continue;
            if (this.m_tableAccess[i2].isExclude()) {
                if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
                hasAccess = ro ? this.m_tableAccess[i2].isReadOnly() : false;
                this.log.fine("Exclude AD_Table_ID=" + AD_Table_ID + " (ro=" + ro + ",TableAccessRO=" + this.m_tableAccess[i2].isReadOnly() + ") = " + hasAccess);
                return hasAccess;
            }
            hasAccess = false;
            if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            hasAccess = !ro ? !this.m_tableAccess[i2].isReadOnly() : true;
            this.log.fine("Include AD_Table_ID=" + AD_Table_ID + " (ro=" + ro + ",TableAccessRO=" + this.m_tableAccess[i2].isReadOnly() + ") = " + hasAccess);
            return hasAccess;
        }
        if (!hasAccess) {
            this.log.fine("AD_Table_ID=" + AD_Table_ID + "(ro=" + ro + ") = " + hasAccess);
        }
        return hasAccess;
    }

    public boolean isTableAccessLevel(int AD_Table_ID, boolean ro) {
        if (ro) {
            return true;
        }
        this.loadTableInfo(false);
        String roleAccessLevel = this.m_tableAccessLevel.get(new Integer(AD_Table_ID));
        if (roleAccessLevel == null) {
            this.log.fine("NO - No AccessLevel - AD_Table_ID=" + AD_Table_ID);
            return false;
        }
        if (roleAccessLevel.equals("7")) {
            return true;
        }
        String userLevel = this.getUserLevel();
        if (userLevel.charAt(0) == 'S' && (roleAccessLevel.equals("4") || roleAccessLevel.equals("6"))) {
            return true;
        }
        if (userLevel.charAt(1) == 'C' && (roleAccessLevel.equals("2") || roleAccessLevel.equals("6"))) {
            return true;
        }
        if (userLevel.charAt(2) == 'O' && (roleAccessLevel.equals("1") || roleAccessLevel.equals("3"))) {
            return true;
        }
        this.log.fine("NO - AD_Table_ID=" + AD_Table_ID + ", UserLevel=" + userLevel + ", AccessLevel=" + roleAccessLevel);
        return false;
    }

    public boolean isColumnAccess(int AD_Table_ID, int AD_Column_ID, boolean ro) {
        if (!this.isTableAccess(AD_Table_ID, ro)) {
            return false;
        }
        this.loadColumnAccess(false);
        boolean retValue = true;
        for (int i2 = 0; i2 < this.m_columnAccess.length; ++i2) {
            if (this.m_columnAccess[i2].isExclude()) {
                if (this.m_columnAccess[i2].getAD_Table_ID() != AD_Table_ID || this.m_columnAccess[i2].getAD_Column_ID() != AD_Column_ID) continue;
                retValue = ro ? this.m_columnAccess[i2].isReadOnly() : false;
                if (!retValue) {
                    this.log.fine("Exclude AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ",ColumnAccessRO=" + this.m_columnAccess[i2].isReadOnly() + ") = " + retValue);
                }
                return retValue;
            }
            if (this.m_columnAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            retValue = false;
            if (this.m_columnAccess[i2].getAD_Column_ID() != AD_Column_ID) continue;
            retValue = !ro ? !this.m_columnAccess[i2].isReadOnly() : true;
            if (!retValue) {
                this.log.fine("Include AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ",ColumnAccessRO=" + this.m_columnAccess[i2].isReadOnly() + ") = " + retValue);
            }
            return retValue;
        }
        if (!retValue) {
            this.log.fine("AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ") = " + retValue);
        }
        return retValue;
    }

    public boolean isRecordAccess(int AD_Table_ID, int Record_ID, boolean ro) {
        this.loadRecordAccess(false);
        boolean negativeList = true;
        for (int i2 = 0; i2 < this.m_recordAccess.length; ++i2) {
            MRecordAccess ra = this.m_recordAccess[i2];
            if (ra.getAD_Table_ID() != AD_Table_ID) continue;
            if (ra.isExclude()) {
                if (ra.getRecord_ID() != Record_ID) continue;
                if (ro) {
                    return ra.isReadOnly();
                }
                return false;
            }
            negativeList = false;
            if (ra.getRecord_ID() != Record_ID) continue;
            if (!ro) {
                return !ra.isReadOnly();
            }
            return true;
        }
        return negativeList;
    }

    public Boolean getWindowAccess(int AD_Window_ID) {
        if (this.m_windowAccess == null) {
            this.m_windowAccess = new HashMap(100);
            String sql = "SELECT AD_Window_ID, IsReadWrite FROM AD_Window_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_windowAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            this.log.fine("#" + this.m_windowAccess.size());
        }
        Boolean retValue = this.m_windowAccess.get(new Integer(AD_Window_ID));
        return retValue;
    }

    public Boolean getProcessAccess(int AD_Process_ID) {
        if (this.m_processAccess == null) {
            this.m_processAccess = new HashMap(50);
            String sql = "SELECT AD_Process_ID, IsReadWrite FROM AD_Process_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_processAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
        return this.m_processAccess.get(new Integer(AD_Process_ID));
    }

    public Boolean getTaskAccess(int AD_Task_ID) {
        if (this.m_taskAccess == null) {
            this.m_taskAccess = new HashMap(10);
            String sql = "SELECT AD_Task_ID, IsReadWrite FROM AD_Task_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_taskAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
        return this.m_taskAccess.get(new Integer(AD_Task_ID));
    }

    public Boolean getFormAccess(int AD_Form_ID) {
        if (this.m_formAccess == null) {
            this.m_formAccess = new HashMap(20);
            String sql = "SELECT AD_Form_ID, IsReadWrite FROM AD_Form_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_formAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
        return this.m_formAccess.get(new Integer(AD_Form_ID));
    }

    public Boolean getWorkflowAccess(int AD_Workflow_ID) {
        if (this.m_workflowAccess == null) {
            this.m_workflowAccess = new HashMap(20);
            String sql = "SELECT AD_Workflow_ID, IsReadWrite FROM AD_Workflow_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_workflowAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
        return this.m_workflowAccess.get(new Integer(AD_Workflow_ID));
    }

    public String addAccessSQL(String SQL, String TableNameIn, boolean fullyQualified, boolean rw) {
        StringBuffer retSQL = new StringBuffer();
        String orderBy = "";
        int posOrder = SQL.lastIndexOf(" ORDER BY ");
        if (posOrder != -1) {
            orderBy = SQL.substring(posOrder);
            retSQL.append(SQL.substring(0, posOrder));
        } else {
            retSQL.append(SQL);
        }
        AccessSqlParser asp = new AccessSqlParser(retSQL.toString());
        AccessSqlParser.TableInfo[] ti = asp.getTableInfo(asp.getMainSqlIndex());
        if (asp.getMainSql().indexOf(" WHERE ") == -1) {
            retSQL.append(" WHERE ");
        } else {
            retSQL.append(" AND ");
        }
        String tableName = "";
        if (ti.length > 0 && (tableName = ti[0].getSynonym()).length() == 0) {
            tableName = ti[0].getTableName();
        }
        if (TableNameIn != null && !tableName.equals(TableNameIn)) {
            String msg = "TableName not correctly parsed - TableNameIn=" + TableNameIn + " - " + asp;
            if (ti.length > 0) {
                msg = msg + " - #1 " + ti[0];
            }
            msg = msg + "\n = " + SQL;
            this.log.log(Level.SEVERE, msg);
            Trace.printStack();
            tableName = TableNameIn;
        }
        if (fullyQualified) {
            retSQL.append(tableName).append(".");
        }
        retSQL.append(this.getClientWhere(rw));
        if (!this.isAccessAllOrgs()) {
            retSQL.append(" AND ");
            if (fullyQualified) {
                retSQL.append(tableName).append(".");
            }
            retSQL.append(this.getOrgWhere(rw));
        }
        for (int i2 = 0; i2 < ti.length; ++i2) {
            String recordWhere;
            String TableName = ti[i2].getTableName();
            int AD_Table_ID = this.getAD_Table_ID(TableName);
            if (AD_Table_ID != 0 && !this.isTableAccess(AD_Table_ID, !rw)) {
                retSQL.append(" AND 1=3");
                this.log.fine("No access to AD_Table_ID=" + AD_Table_ID + " - " + TableName + " - " + retSQL);
                break;
            }
            String keyColumnName = "";
            if (fullyQualified) {
                keyColumnName = ti[i2].getSynonym();
                if (keyColumnName.length() == 0) {
                    keyColumnName = TableName;
                }
                keyColumnName = keyColumnName + ".";
            }
            if ((recordWhere = this.getRecordWhere(AD_Table_ID, keyColumnName = keyColumnName + TableName + "_ID", rw)).length() <= 0) continue;
            retSQL.append(" AND ").append(recordWhere);
            this.log.finest("Record access - " + recordWhere);
        }
        String mainSql = asp.getMainSql();
        this.loadRecordAccess(false);
        int AD_Table_ID = 0;
        String whereColumnName = null;
        ArrayList<Integer> includes = new ArrayList<Integer>();
        ArrayList<Integer> excludes = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.m_recordDependentAccess.length; ++i3) {
            char charCheck;
            int posColumn;
            String columnName = this.m_recordDependentAccess[i3].getKeyColumnName(asp.getTableInfo(asp.getMainSqlIndex()));
            if (columnName == null || (posColumn = mainSql.indexOf(columnName)) == -1 || (charCheck = mainSql.charAt(posColumn - 1)) != ',' && charCheck != '.' && charCheck != ' ' && charCheck != '(' || (charCheck = mainSql.charAt(posColumn + columnName.length())) != ',' && charCheck != ' ' && charCheck != ')') continue;
            if (AD_Table_ID != 0 && AD_Table_ID != this.m_recordDependentAccess[i3].getAD_Table_ID()) {
                retSQL.append(this.getDependentAccess(whereColumnName, includes, excludes));
            }
            AD_Table_ID = this.m_recordDependentAccess[i3].getAD_Table_ID();
            if (this.m_recordDependentAccess[i3].isExclude()) {
                excludes.add(this.m_recordDependentAccess[i3].getRecord_ID());
                this.log.fine("Exclude " + columnName + " - " + this.m_recordDependentAccess[i3]);
            } else if (!rw || !this.m_recordDependentAccess[i3].isReadOnly()) {
                includes.add(this.m_recordDependentAccess[i3].getRecord_ID());
                this.log.fine("Include " + columnName + " - " + this.m_recordDependentAccess[i3]);
            }
            whereColumnName = this.getDependentRecordWhereColumn(mainSql, columnName);
        }
        retSQL.append(this.getDependentAccess(whereColumnName, includes, excludes));
        retSQL.append(orderBy);
        this.log.finest(retSQL.toString());
        return retSQL.toString();
    }

    private String getDependentAccess(String whereColumnName, ArrayList<Integer> includes, ArrayList<Integer> excludes) {
        if (includes.size() == 0 && excludes.size() == 0) {
            return "";
        }
        if (includes.size() != 0 && excludes.size() != 0) {
            this.log.warning("Mixing Include and Excluse rules - Will not return values");
        }
        StringBuffer where = new StringBuffer(" AND ");
        if (includes.size() == 1) {
            where.append(whereColumnName).append("=").append(includes.get(0));
        } else if (includes.size() > 1) {
            where.append(whereColumnName).append(" IN (");
            for (int ii = 0; ii < includes.size(); ++ii) {
                if (ii > 0) {
                    where.append(",");
                }
                where.append(includes.get(ii));
            }
            where.append(")");
        } else if (excludes.size() == 1) {
            where.append(whereColumnName).append("<>").append(excludes.get(0));
        } else if (excludes.size() > 1) {
            where.append(whereColumnName).append(" NOT IN (");
            for (int ii = 0; ii < excludes.size(); ++ii) {
                if (ii > 0) {
                    where.append(",");
                }
                where.append(excludes.get(ii));
            }
            where.append(")");
        }
        this.log.finest(where.toString());
        return where.toString();
    }

    private String getDependentRecordWhereColumn(String mainSql, String columnName) {
        String retValue = columnName;
        int index = mainSql.indexOf(columnName);
        int offset = index - 1;
        char c = mainSql.charAt(offset);
        if (c == '.') {
            StringBuffer sb = new StringBuffer();
            while (c != ' ' && c != ',' && c != '(') {
                sb.insert(0, c);
                c = mainSql.charAt(--offset);
            }
            sb.append(columnName);
            return sb.toString();
        }
        return retValue;
    }

    public boolean canUpdate(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, int Record_ID, boolean createError) {
        String userLevel = this.getUserLevel();
        if (userLevel.indexOf("S") != -1) {
            return true;
        }
        boolean retValue = true;
        String whatMissing = "";
        if (AD_Client_ID == 0 && AD_Org_ID == 0 && userLevel.charAt(0) != 'S') {
            retValue = false;
            whatMissing = whatMissing + "S";
        } else if (AD_Client_ID != 0 && AD_Org_ID == 0 && userLevel.charAt(1) != 'C') {
            if (userLevel.charAt(2) != 'O' || !this.isOrgAccess(AD_Org_ID, true)) {
                retValue = false;
                whatMissing = whatMissing + "C";
            }
        } else if (AD_Client_ID != 0 && AD_Org_ID != 0 && userLevel.charAt(2) != 'O') {
            retValue = false;
            whatMissing = whatMissing + "O";
        }
        if (retValue) {
            retValue = this.isTableAccess(AD_Table_ID, false);
        }
        if (retValue && Record_ID != 0) {
            retValue = this.isRecordAccess(AD_Table_ID, Record_ID, false);
        }
        if (!retValue && createError) {
            this.log.saveWarning("AccessTableNoUpdate", "AD_Client_ID=" + AD_Client_ID + ", AD_Org_ID=" + AD_Org_ID + ", UserLevel=" + userLevel + " => missing=" + whatMissing);
            this.log.warning(this.toString());
        }
        return retValue;
    }

    public boolean canView(Properties ctx, String TableLevel) {
        String userLevel = this.getUserLevel();
        boolean retValue = true;
        if ("7".equals(TableLevel)) {
            retValue = true;
        } else if ("4".equals(TableLevel) && userLevel.charAt(0) != 'S') {
            retValue = false;
        } else if ("2".equals(TableLevel) && userLevel.charAt(1) != 'C') {
            retValue = false;
        } else if ("1".equals(TableLevel) && userLevel.charAt(2) != 'O') {
            retValue = false;
        } else if ("3".equals(TableLevel) && userLevel.charAt(1) != 'C' && userLevel.charAt(2) != 'O') {
            retValue = false;
        } else if ("6".equals(TableLevel) && userLevel.charAt(0) != 'S' && userLevel.charAt(1) != 'C') {
            retValue = false;
        }
        if (retValue) {
            return retValue;
        }
        this.log.saveWarning("AccessTableNoView", "Required=" + TableLevel + "(" + this.getTableLevelString(Env.getAD_Language(ctx), TableLevel) + ") != UserLevel=" + userLevel);
        this.log.info(this.toString());
        return retValue;
    }

    private String getTableLevelString(String AD_Language, String TableLevel) {
        String level = TableLevel + "??";
        if (TableLevel.equals("1")) {
            level = "AccessOrg";
        } else if (TableLevel.equals("2")) {
            level = "AccessClient";
        } else if (TableLevel.equals("3")) {
            level = "AccessClientOrg";
        } else if (TableLevel.equals("4")) {
            level = "AccessSystem";
        } else if (TableLevel.equals("6")) {
            level = "AccessSystemClient";
        } else if (TableLevel.equals("7")) {
            level = "AccessShared";
        }
        return Msg.getMsg(AD_Language, level);
    }

    private int getAD_Table_ID(String tableName) {
        this.loadTableInfo(false);
        Integer ii = this.m_tableName.get(tableName);
        if (ii != null) {
            return ii;
        }
        return 0;
    }

    private String getRecordWhere(int AD_Table_ID, String keyColumnName, boolean rw) {
        String lockedIDs;
        this.loadRecordAccess(false);
        StringBuffer sbInclude = new StringBuffer();
        StringBuffer sbExclude = new StringBuffer();
        for (int i2 = 0; i2 < this.m_recordAccess.length; ++i2) {
            if (this.m_recordAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            if (this.m_recordAccess[i2].isExclude()) {
                if (sbExclude.length() == 0) {
                    sbExclude.append(keyColumnName).append(" NOT IN (");
                } else {
                    sbExclude.append(",");
                }
                sbExclude.append(this.m_recordAccess[i2].getRecord_ID());
                continue;
            }
            if (rw && this.m_recordAccess[i2].isReadOnly()) continue;
            if (sbInclude.length() == 0) {
                sbInclude.append(keyColumnName).append(" IN (");
            } else {
                sbInclude.append(",");
            }
            sbInclude.append(this.m_recordAccess[i2].getRecord_ID());
        }
        StringBuffer sb = new StringBuffer();
        if (sbExclude.length() > 0) {
            sb.append(sbExclude).append(")");
        }
        if (sbInclude.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(sbInclude).append(")");
        }
        if (!this.isPersonalAccess() && (lockedIDs = MPrivateAccess.getLockedRecordWhere(AD_Table_ID, this.m_AD_User_ID)) != null) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(keyColumnName).append(lockedIDs);
        }
        return sb.toString();
    }

    public boolean isShowPreference() {
        return !"N".equals(this.getPreferenceType());
    }

    class OrgAccess {
        public int AD_Client_ID = 0;
        public int AD_Org_ID = 0;
        public boolean readOnly = true;

        public OrgAccess(int ad_Client_ID, int ad_Org_ID, boolean readonly) {
            this.AD_Client_ID = ad_Client_ID;
            this.AD_Org_ID = ad_Org_ID;
            this.readOnly = readonly;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof OrgAccess) {
                OrgAccess comp = (OrgAccess)obj;
                return comp.AD_Client_ID == this.AD_Client_ID && comp.AD_Org_ID == this.AD_Org_ID;
            }
            return false;
        }

        public int hashCode() {
            return this.AD_Client_ID * 7 + this.AD_Org_ID;
        }

        public String toString() {
            String clientName = "System";
            if (this.AD_Client_ID != 0) {
                clientName = MClient.get(MRole.this.getCtx(), this.AD_Client_ID).getName();
            }
            String orgName = "*";
            if (this.AD_Org_ID != 0) {
                orgName = MOrg.get(MRole.this.getCtx(), this.AD_Org_ID).getName();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(Msg.translate(MRole.this.getCtx(), "AD_Client_ID")).append("=").append(clientName).append(" - ").append(Msg.translate(MRole.this.getCtx(), "AD_Org_ID")).append("=").append(orgName);
            if (this.readOnly) {
                sb.append(" r/o");
            }
            return sb.toString();
        }
    }
}

