/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_M_Requisition;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRequisition
extends X_M_Requisition
implements DocAction {
    private MRequisitionLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MRequisition(Properties ctx, int M_Requisition_ID, String trxName) {
        super(ctx, M_Requisition_ID, trxName);
        if (M_Requisition_ID == 0) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDateRequired(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPriorityRule("5");
            this.setTotalLines(Env.ZERO);
            this.setIsApproved(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MRequisition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequisitionLine[] getLines() {
        if (this.m_lines != null) {
            return this.m_lines;
        }
        ArrayList<MRequisitionLine> list = new ArrayList<MRequisitionLine>();
        String sql = "SELECT * FROM M_RequisitionLine WHERE M_Requisition_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_Requisition_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRequisitionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MRequisitionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MRequisition[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",Status=").append(this.getDocStatus()).append(",Action=").append(this.getDocAction()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        return Msg.getElement(this.getCtx(), "M_Requisition_ID") + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public void setM_PriceList_ID() {
        MPriceList defaultPL = MPriceList.getDefault(this.getCtx(), false);
        if (defaultPL == null) {
            defaultPL = MPriceList.getDefault(this.getCtx(), true);
        }
        if (defaultPL != null) {
            this.setM_PriceList_ID(defaultPL.getM_PriceList_ID());
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_PriceList_ID() == 0) {
            this.setM_PriceList_ID();
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MRequisitionLine[] lines = this.getLines();
        if (this.getAD_User_ID() == 0 || this.getM_PriceList_ID() == 0 || this.getM_Warehouse_ID() == 0 || lines.length == 0) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), "POR")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        int precision = MPriceList.getStandardPrecision(this.getCtx(), this.getM_PriceList_ID());
        BigDecimal totalLines = Env.ZERO;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MRequisitionLine line = lines[i2];
            BigDecimal lineNet = line.getQty().multiply(line.getPriceActual());
            if ((lineNet = lineNet.setScale(precision, 4)).compareTo(line.getLineNetAmt()) != 0) {
                line.setLineNetAmt(lineNet);
                line.save();
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        if (totalLines.compareTo(this.getTotalLines()) != 0) {
            this.setTotalLines(totalLines);
            this.save();
        }
        this.m_justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        MRequisitionLine[] lines = this.getLines();
        BigDecimal totalLines = Env.ZERO;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MRequisitionLine line = lines[i2];
            BigDecimal finalQty = line.getQty();
            if (line.getC_OrderLine_ID() == 0) {
                finalQty = Env.ZERO;
            } else {
                MOrderLine ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                finalQty = ol.getQtyOrdered();
            }
            if (finalQty.compareTo(line.getQty()) != 0) {
                String description = line.getDescription();
                if (description == null) {
                    description = "";
                }
                description = description + " [" + line.getQty() + "]";
                line.setDescription(description);
                line.setQty(finalQty);
                line.setLineNetAmt();
                line.save();
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        if (totalLines.compareTo(this.getTotalLines()) != 0) {
            this.setTotalLines(totalLines);
            this.save();
        }
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        return this.reverseCorrectIt();
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(" - ").append(this.getUserName());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalLines")).append("=").append(this.getTotalLines()).append(" (#").append(this.getLines().length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getAD_User_ID();
    }

    public int getC_Currency_ID() {
        MPriceList pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), this.get_TrxName());
        return pl.getC_Currency_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getTotalLines();
    }

    public String getUserName() {
        return MUser.get(this.getCtx(), this.getAD_User_ID()).getName();
    }
}

