/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_AD_Ref_List;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class MRefList
extends X_AD_Ref_List {
    private static CLogger s_log = CLogger.getCLogger(MRefList.class);
    private static CCache<String, String> s_cache = new CCache("AD_Ref_List", 20);

    public static MRefList get(Properties ctx, int AD_Reference_ID, String Value, String trxName) {
        MRefList retValue = null;
        String sql = "SELECT * FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Reference_ID);
            pstmt.setString(2, Value);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MRefList(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        return retValue;
    }

    public static String getListName(Properties ctx, int AD_Reference_ID, String Value) {
        String AD_Language = Env.getAD_Language(ctx);
        String key = AD_Language + "_" + AD_Reference_ID + "_" + Value;
        String retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        boolean isBaseLanguage = Env.isBaseLanguage(AD_Language, "AD_Ref_List");
        String sql = isBaseLanguage ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?" : "SELECT t.Name FROM AD_Ref_List_Trl t INNER JOIN AD_Ref_List r ON (r.AD_Ref_List_ID=t.AD_Ref_List_ID) WHERE r.AD_Reference_ID=? AND r.Value=? AND t.AD_Language=?";
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_ID);
            pstmt.setString(2, Value);
            if (!isBaseLanguage) {
                pstmt.setString(3, AD_Language);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                retValue = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql + " - " + key, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (retValue == null) {
            retValue = "";
            s_log.warning("getListName - Not found " + key);
        }
        s_cache.put(key, retValue);
        return retValue;
    }

    public static ValueNamePair[] getList(int AD_Reference_ID, boolean optional) {
        String sql = "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND IsActive='Y' ORDER BY 1";
        CPreparedStatement pstmt = null;
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        if (optional) {
            list.add(new ValueNamePair("", ""));
        }
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new ValueNamePair(rs.getString(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        ValueNamePair[] retValue = new ValueNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRefList(Properties ctx, int AD_Ref_List_ID, String trxName) {
        super(ctx, AD_Ref_List_ID, trxName);
        if (AD_Ref_List_ID == 0) {
            this.setEntityType("U");
        }
    }

    public MRefList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        return this.getName();
    }
}

