/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MRMALine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_M_RMA;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRMA
extends X_M_RMA
implements DocAction {
    private MRMALine[] m_lines = null;
    private MInOut m_inout = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MRMA(Properties ctx, int M_RMA_ID, String trxName) {
        super(ctx, M_RMA_ID, trxName);
        if (M_RMA_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setProcessed(false);
        }
    }

    public MRMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRMALine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MRMALine> list = new ArrayList<MRMALine>();
        String sql = "SELECT * FROM M_RMALine WHERE M_RMA_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_RMA_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRMALine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MRMALine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MInOut getShipment() {
        if (this.m_inout == null && this.getM_InOut_ID() != 0) {
            this.m_inout = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        }
        return this.m_inout;
    }

    public void setM_InOut_ID(int M_InOut_ID) {
        super.setM_InOut_ID(M_InOut_ID);
        this.setC_Currency_ID(0);
        this.setAmt(Env.ZERO);
        this.setC_BPartner_ID(0);
        this.m_inout = null;
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_BPartner_ID() == 0) {
            this.getShipment();
            if (this.m_inout != null) {
                this.setC_BPartner_ID(this.m_inout.getC_BPartner_ID());
            }
        }
        if (this.getC_Currency_ID() == 0) {
            this.getShipment();
            if (this.m_inout != null) {
                if (this.m_inout.getC_Order_ID() != 0) {
                    MOrder order = new MOrder(this.getCtx(), this.m_inout.getC_Order_ID(), this.get_TrxName());
                    this.setC_Currency_ID(order.getC_Currency_ID());
                } else if (this.m_inout.getC_Invoice_ID() != 0) {
                    MInvoice invoice = new MInvoice(this.getCtx(), this.m_inout.getC_Invoice_ID(), this.get_TrxName());
                    this.setC_Currency_ID(invoice.getC_Currency_ID());
                }
            }
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MRMALine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal amt = Env.ZERO;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MRMALine line = lines[i2];
            amt = amt.add(line.getAmt());
        }
        this.setAmt(amt);
        this.m_justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        this.m_processMsg = "Need to code creating the credit memo";
        return "IP";
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return false;
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "Amt")).append("=").append(this.getAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getAmt();
    }
}

