/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.X_C_ProjectIssue;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProjectIssue
extends X_C_ProjectIssue {
    private MProject m_parent = null;

    public MProjectIssue(Properties ctx, int C_ProjectIssue_ID, String trxName) {
        super(ctx, C_ProjectIssue_ID, trxName);
        if (C_ProjectIssue_ID == 0) {
            this.setMovementQty(Env.ZERO);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MProjectIssue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectIssue(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg(project.getAD_Client_ID(), project.getAD_Org_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setLine(this.getNextLine());
        this.m_parent = project;
        this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        this.setMovementQty(Env.ZERO);
        this.setPosted(false);
        this.setProcessed(false);
    }

    private int getNextLine() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(Line),0)+10 FROM C_ProjectIssue WHERE C_Project_ID=?", this.getC_Project_ID());
    }

    public void setMandatory(int M_Locator_ID, int M_Product_ID, BigDecimal MovementQty) {
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setMovementQty(MovementQty);
    }

    public MProject getParent() {
        if (this.m_parent == null && this.getC_Project_ID() != 0) {
            this.m_parent = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean process() {
        if (!this.save()) {
            return false;
        }
        if (this.getM_Product_ID() == 0) {
            this.log.log(Level.SEVERE, "No Product");
            return false;
        }
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        if (!product.isStocked()) {
            this.setProcessed(true);
            return this.save();
        }
        MTransaction mTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "W+", this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
        mTrx.setC_ProjectIssue_ID(this.getC_ProjectIssue_ID());
        MLocator loc = MLocator.get(this.getCtx(), this.getM_Locator_ID());
        if (MStorage.add(this.getCtx(), loc.getM_Warehouse_ID(), this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), this.getMovementQty().negate(), null, null, this.get_TrxName())) {
            if (mTrx.save(this.get_TrxName())) {
                this.setProcessed(true);
                if (this.save()) {
                    return true;
                }
                this.log.log(Level.SEVERE, "Issue not saved");
            } else {
                this.log.log(Level.SEVERE, "Transaction not saved");
            }
        } else {
            this.log.log(Level.SEVERE, "Storage not updated");
        }
        return false;
    }
}

