/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MPriceList;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trace;

public class MProductPricing {
    private int m_M_Product_ID;
    private int m_C_BPartner_ID;
    private BigDecimal m_Qty = Env.ONE;
    private boolean m_isSOTrx = true;
    private int m_M_PriceList_ID = 0;
    private int m_M_PriceList_Version_ID = 0;
    private Timestamp m_PriceDate;
    private int m_precision = -1;
    private boolean m_calculated = false;
    private Boolean m_found = null;
    private BigDecimal m_PriceList = Env.ZERO;
    private BigDecimal m_PriceStd = Env.ZERO;
    private BigDecimal m_PriceLimit = Env.ZERO;
    private int m_C_Currency_ID = 0;
    private boolean m_enforcePriceLimit = false;
    private int m_C_UOM_ID = 0;
    private int m_M_Product_Category_ID;
    private boolean m_discountSchema = false;
    private boolean m_isTaxIncluded = false;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public MProductPricing(int M_Product_ID, int C_BPartner_ID, BigDecimal Qty, boolean isSOTrx) {
        this.m_M_Product_ID = M_Product_ID;
        this.m_C_BPartner_ID = C_BPartner_ID;
        if (Qty != null && Env.ZERO.compareTo(Qty) != 0) {
            this.m_Qty = Qty;
        }
        this.m_isSOTrx = isSOTrx;
    }

    public boolean calculatePrice() {
        if (this.m_M_Product_ID == 0 || this.m_found != null && !this.m_found.booleanValue()) {
            return false;
        }
        if (!this.m_calculated) {
            this.m_calculated = this.calculatePLV();
        }
        if (!this.m_calculated) {
            this.m_calculated = this.calculatePL();
        }
        if (!this.m_calculated) {
            this.m_calculated = this.calculateBPL();
        }
        if (!this.m_calculated) {
            this.setBaseInfo();
        }
        if (this.m_calculated) {
            this.calculateDiscount();
        }
        this.setPrecision();
        this.m_found = new Boolean(this.m_calculated);
        return this.m_calculated;
    }

    private boolean calculatePLV() {
        if (this.m_M_Product_ID == 0 || this.m_M_PriceList_Version_ID == 0) {
            return false;
        }
        String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_Version_ID=?";
        this.m_calculated = false;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            pstmt.setInt(2, this.m_M_PriceList_Version_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_PriceStd = rs.getBigDecimal(1);
                if (rs.wasNull()) {
                    this.m_PriceStd = Env.ZERO;
                }
                this.m_PriceList = rs.getBigDecimal(2);
                if (rs.wasNull()) {
                    this.m_PriceList = Env.ZERO;
                }
                this.m_PriceLimit = rs.getBigDecimal(3);
                if (rs.wasNull()) {
                    this.m_PriceLimit = Env.ZERO;
                }
                this.m_C_UOM_ID = rs.getInt(4);
                this.m_C_Currency_ID = rs.getInt(6);
                this.m_M_Product_Category_ID = rs.getInt(7);
                this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                this.m_isTaxIncluded = "Y".equals(rs.getString(9));
                this.log.fine("M_PriceList_Version_ID=" + this.m_M_PriceList_Version_ID + " - " + this.m_PriceStd);
                this.m_calculated = true;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.m_calculated = false;
        }
        return this.m_calculated;
    }

    private boolean calculatePL() {
        if (this.m_M_Product_ID == 0) {
            return false;
        }
        if (this.m_M_PriceList_ID == 0) {
            this.log.log(Level.SEVERE, "No PriceList");
            Trace.printStack();
            return false;
        }
        String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,pl.EnforcePriceLimit FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_ID=?ORDER BY pv.ValidFrom DESC";
        this.m_calculated = false;
        if (this.m_PriceDate == null) {
            this.m_PriceDate = new Timestamp(System.currentTimeMillis());
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            pstmt.setInt(2, this.m_M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            while (!this.m_calculated && rs.next()) {
                Timestamp plDate = rs.getTimestamp(5);
                if (plDate != null && this.m_PriceDate.before(plDate)) continue;
                this.m_PriceStd = rs.getBigDecimal(1);
                if (rs.wasNull()) {
                    this.m_PriceStd = Env.ZERO;
                }
                this.m_PriceList = rs.getBigDecimal(2);
                if (rs.wasNull()) {
                    this.m_PriceList = Env.ZERO;
                }
                this.m_PriceLimit = rs.getBigDecimal(3);
                if (rs.wasNull()) {
                    this.m_PriceLimit = Env.ZERO;
                }
                this.m_C_UOM_ID = rs.getInt(4);
                this.m_C_Currency_ID = rs.getInt(6);
                this.m_M_Product_Category_ID = rs.getInt(7);
                this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                this.log.fine("M_PriceList_ID=" + this.m_M_PriceList_ID + "(" + plDate + ")" + " - " + this.m_PriceStd);
                this.m_calculated = true;
                break;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.m_calculated = false;
        }
        if (!this.m_calculated) {
            this.log.finer("Not found (PL)");
        }
        return this.m_calculated;
    }

    private boolean calculateBPL() {
        if (this.m_M_Product_ID == 0 || this.m_M_PriceList_ID == 0) {
            return false;
        }
        String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist bpl ON (pv.M_PriceList_ID=bpl.M_PriceList_ID) INNER JOIN M_Pricelist pl ON (bpl.M_PriceList_ID=pl.BasePriceList_ID) WHERE pv.IsActive='Y' AND p.M_Product_ID=? AND pl.M_PriceList_ID=?ORDER BY pv.ValidFrom DESC";
        this.m_calculated = false;
        if (this.m_PriceDate == null) {
            this.m_PriceDate = new Timestamp(System.currentTimeMillis());
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            pstmt.setInt(2, this.m_M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            while (!this.m_calculated && rs.next()) {
                Timestamp plDate = rs.getTimestamp(5);
                if (plDate != null && this.m_PriceDate.before(plDate)) continue;
                this.m_PriceStd = rs.getBigDecimal(1);
                if (rs.wasNull()) {
                    this.m_PriceStd = Env.ZERO;
                }
                this.m_PriceList = rs.getBigDecimal(2);
                if (rs.wasNull()) {
                    this.m_PriceList = Env.ZERO;
                }
                this.m_PriceLimit = rs.getBigDecimal(3);
                if (rs.wasNull()) {
                    this.m_PriceLimit = Env.ZERO;
                }
                this.m_C_UOM_ID = rs.getInt(4);
                this.m_C_Currency_ID = rs.getInt(6);
                this.m_M_Product_Category_ID = rs.getInt(7);
                this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                this.m_isTaxIncluded = "Y".equals(rs.getString(9));
                this.log.fine("M_PriceList_ID=" + this.m_M_PriceList_ID + "(" + plDate + ")" + " - " + this.m_PriceStd);
                this.m_calculated = true;
                break;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.m_calculated = false;
        }
        if (!this.m_calculated) {
            this.log.finer("Not found (BPL)");
        }
        return this.m_calculated;
    }

    private void setBaseInfo() {
        if (this.m_M_Product_ID == 0) {
            return;
        }
        String sql = "SELECT C_UOM_ID, M_Product_Category_ID FROM M_Product WHERE M_Product_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_UOM_ID = rs.getInt(1);
                this.m_M_Product_Category_ID = rs.getInt(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }

    public boolean isTaxIncluded() {
        return this.m_isTaxIncluded;
    }

    private void calculateDiscount() {
        this.m_discountSchema = false;
        if (this.m_C_BPartner_ID == 0 || this.m_M_Product_ID == 0) {
            return;
        }
        int M_DiscountSchema_ID = 0;
        BigDecimal FlatDiscount = null;
        String sql = "SELECT COALESCE(p.M_DiscountSchema_ID,g.M_DiscountSchema_ID), COALESCE(p.PO_DiscountSchema_ID,g.PO_DiscountSchema_ID), p.FlatDiscount FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) WHERE p.C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_DiscountSchema_ID = rs.getInt(this.m_isSOTrx ? 1 : 2);
                FlatDiscount = rs.getBigDecimal(3);
                if (FlatDiscount == null) {
                    FlatDiscount = Env.ZERO;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (M_DiscountSchema_ID == 0) {
            return;
        }
        MDiscountSchema sd = MDiscountSchema.get(Env.getCtx(), M_DiscountSchema_ID);
        if (sd.get_ID() == 0) {
            return;
        }
        this.m_discountSchema = true;
        this.m_PriceStd = sd.calculatePrice(this.m_Qty, this.m_PriceStd, this.m_M_Product_ID, this.m_M_Product_Category_ID, FlatDiscount);
    }

    public BigDecimal getDiscount() {
        BigDecimal Discount = Env.ZERO;
        if (this.m_PriceList.intValue() != 0) {
            Discount = new BigDecimal((this.m_PriceList.doubleValue() - this.m_PriceStd.doubleValue()) / this.m_PriceList.doubleValue() * 100.0);
        }
        if (Discount.scale() > 2) {
            Discount = Discount.setScale(2, 4);
        }
        return Discount;
    }

    public int getM_Product_ID() {
        return this.m_M_Product_ID;
    }

    public int getM_PriceList_ID() {
        return this.m_M_PriceList_ID;
    }

    public void setM_PriceList_ID(int M_PriceList_ID) {
        this.m_M_PriceList_ID = M_PriceList_ID;
        this.m_calculated = false;
    }

    public int getM_PriceList_Version_ID() {
        return this.m_M_PriceList_Version_ID;
    }

    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        this.m_M_PriceList_Version_ID = M_PriceList_Version_ID;
        this.m_calculated = false;
    }

    public Timestamp getPriceDate() {
        return this.m_PriceDate;
    }

    public void setPriceDate(Timestamp priceDate) {
        this.m_PriceDate = priceDate;
        this.m_calculated = false;
    }

    private void setPrecision() {
        if (this.m_M_PriceList_ID != 0) {
            this.m_precision = MPriceList.getPricePrecision(Env.getCtx(), this.getM_PriceList_ID());
        }
    }

    public int getPrecision() {
        return this.m_precision;
    }

    private BigDecimal round(BigDecimal bd) {
        if (this.m_precision >= 0 && bd.scale() > this.m_precision) {
            return bd.setScale(this.m_precision, 4);
        }
        return bd;
    }

    public int getC_UOM_ID() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.m_C_UOM_ID;
    }

    public BigDecimal getPriceList() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.round(this.m_PriceList);
    }

    public BigDecimal getPriceStd() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.round(this.m_PriceStd);
    }

    public BigDecimal getPriceLimit() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.round(this.m_PriceLimit);
    }

    public int getC_Currency_ID() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.m_C_Currency_ID;
    }

    public boolean isEnforcePriceLimit() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.m_enforcePriceLimit;
    }

    public boolean isDiscountSchema() {
        return this.m_discountSchema;
    }

    public boolean isCalculated() {
        return this.m_calculated;
    }
}

