/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.X_M_ProductPrice;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductPrice
extends X_M_ProductPrice {
    private static CLogger s_log = CLogger.getCLogger(MProductPrice.class);

    public static MProductPrice get(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, String trxName) {
        MProductPrice retValue = null;
        String sql = "SELECT * FROM M_ProductPrice WHERE M_PriceList_Version_ID=? AND M_Product_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_PriceList_Version_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProductPrice(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MProductPrice(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setPriceLimit(Env.ZERO);
        this.setPriceList(Env.ZERO);
        this.setPriceStd(Env.ZERO);
    }

    public MProductPrice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductPrice(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.setM_Product_ID(M_Product_ID);
    }

    public MProductPrice(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit, String trxName) {
        this(ctx, M_PriceList_Version_ID, M_Product_ID, trxName);
        this.setPrices(PriceList, PriceStd, PriceLimit);
    }

    public MProductPrice(MPriceListVersion plv, int M_Product_ID, BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit) {
        this(plv.getCtx(), 0, plv.get_TrxName());
        this.setClientOrg(plv);
        this.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setPrices(PriceList, PriceStd, PriceLimit);
    }

    public void setPrices(BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit) {
        this.setPriceLimit(PriceLimit);
        this.setPriceList(PriceList);
        this.setPriceStd(PriceStd);
    }
}

