/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCostElement;
import org.compiere.model.X_M_Product_Category_Acct;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MProductCategoryAcct
extends X_M_Product_Category_Acct {
    private static CLogger s_log = CLogger.getCLogger(MProductCategoryAcct.class);

    public static MProductCategoryAcct get(Properties ctx, int M_Product_Category_ID, int C_AcctSchema_ID, String trxName) {
        MProductCategoryAcct retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM  M_Product_Category_Acct WHERE M_Product_Category_ID=? AND C_AcctSchema_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_Product_Category_ID);
            pstmt.setInt(2, C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProductCategoryAcct(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MProductCategoryAcct(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MProductCategoryAcct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void checkCosting() {
        if (this.getCostingMethod() != null && this.getCostingMethod().length() > 0) {
            MCostElement.getMaterialCostElement(this, this.getCostingMethod());
        }
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.checkCosting();
        return success;
    }
}

