/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_M_Product_Category;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductCategory
extends X_M_Product_Category {
    private static CCache<Integer, MProductCategory> s_cache = new CCache("M_Product_Category", 20);
    private static CCache<Integer, Integer> s_products = new CCache("M_Product", 100);
    private static CLogger s_log = CLogger.getCLogger(MProductCategory.class);

    public static MProductCategory get(Properties ctx, int M_Product_Category_ID) {
        Integer ii = new Integer(M_Product_Category_ID);
        MProductCategory pc = s_cache.get(ii);
        if (pc == null) {
            pc = new MProductCategory(ctx, M_Product_Category_ID, null);
        }
        return pc;
    }

    public static boolean isCategory(int M_Product_Category_ID, int M_Product_ID) {
        if (M_Product_ID == 0 || M_Product_Category_ID == 0) {
            return false;
        }
        Integer product = new Integer(M_Product_ID);
        Integer category = s_products.get(product);
        if (category != null) {
            return category == M_Product_Category_ID;
        }
        String sql = "SELECT M_Product_Category_ID FROM M_Product WHERE M_Product_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                category = new Integer(rs.getInt(1));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (category != null) {
            s_products.put(product, category);
            s_log.fine("M_Product_ID=" + M_Product_ID + "(" + category + ") in M_Product_Category_ID=" + M_Product_Category_ID + " - " + (category == M_Product_Category_ID));
            return category == M_Product_Category_ID;
        }
        s_log.log(Level.SEVERE, "Not found M_Product_ID=" + M_Product_ID);
        return false;
    }

    public MProductCategory(Properties ctx, int M_Product_Category_ID, String trxName) {
        super(ctx, M_Product_Category_ID, trxName);
        if (M_Product_Category_ID == 0) {
            this.setMMPolicy("F");
            this.setPlannedMargin(Env.ZERO);
            this.setIsDefault(false);
            this.setIsSelfService(true);
        }
    }

    public MProductCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            this.insert_Accounting("M_Product_Category_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("M_Product_Category_Acct");
    }

    public boolean isFiFo() {
        return "F".equals(this.getMMPolicy());
    }
}

