/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MYear;
import org.compiere.model.X_C_Period;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MPeriod
extends X_C_Period {
    private static CCache<Integer, MPeriod> s_cache = new CCache("C_Period", 10);
    private static CLogger s_log = CLogger.getCLogger(MPeriod.class);
    private MPeriodControl[] m_controls = null;

    public static MPeriod get(Properties ctx, int C_Period_ID) {
        Integer key = new Integer(C_Period_ID);
        MPeriod retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MPeriod(ctx, C_Period_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MPeriod get(Properties ctx, Timestamp DateAcct) {
        if (DateAcct == null) {
            return null;
        }
        for (MPeriod period : s_cache.values()) {
            if (!period.isStandardPeriod() || !period.isInPeriod(DateAcct)) continue;
            return period;
        }
        MPeriod retValue = null;
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID= (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN TRUNC(StartDate) AND TRUNC(EndDate) AND IsActive='Y' AND PeriodType='S'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setTimestamp(2, TimeUtil.getDay(DateAcct));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPeriod period = new MPeriod(ctx, rs, null);
                Integer key = new Integer(period.getC_Period_ID());
                s_cache.put(key, period);
                if (!period.isStandardPeriod()) continue;
                retValue = period;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "DateAcct=" + DateAcct, e);
        }
        if (retValue == null) {
            s_log.warning("No Standard Period for " + DateAcct + " (AD_Client_ID=" + AD_Client_ID + ")");
        }
        return retValue;
    }

    public static int getC_Period_ID(Properties ctx, Timestamp DateAcct) {
        MPeriod period = MPeriod.get(ctx, DateAcct);
        if (period == null) {
            return 0;
        }
        return period.getC_Period_ID();
    }

    public static boolean isOpen(Properties ctx, Timestamp DateAcct, String DocBaseType) {
        if (DateAcct == null) {
            s_log.warning("No DateAcct");
            return false;
        }
        if (DocBaseType == null) {
            s_log.warning("No DocBaseType");
            return false;
        }
        MPeriod period = MPeriod.get(ctx, DateAcct);
        if (period == null) {
            s_log.warning("No Period for " + DateAcct + " (" + DocBaseType + ")");
            return false;
        }
        boolean open = period.isOpen(DocBaseType);
        if (!open) {
            s_log.warning(period.getName() + ": Not open for " + DocBaseType + " (" + DateAcct + ")");
        }
        return open;
    }

    public static MPeriod getFirstInYear(Properties ctx, Timestamp DateAcct) {
        MPeriod retValue = null;
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT p.C_Year_ID FROM AD_ClientInfo c INNER JOIN C_Year y ON (c.C_Calendar_ID=y.C_Calendar_ID) INNER JOIN C_Period p ON (y.C_Year_ID=p.C_Year_ID) WHERE c.AD_Client_ID=?\tAND ? BETWEEN StartDate AND EndDate) AND IsActive='Y' AND PeriodType='S' ORDER BY StartDate";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setTimestamp(2, DateAcct);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MPeriod(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        return retValue;
    }

    public MPeriod(Properties ctx, int C_Period_ID, String trxName) {
        super(ctx, C_Period_ID, trxName);
        if (C_Period_ID == 0) {
            this.setPeriodType("S");
        }
    }

    public MPeriod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPeriod(MYear year, int PeriodNo, String name, Timestamp startDate, Timestamp endDate) {
        this(year.getCtx(), 0, year.get_TrxName());
        this.setClientOrg(year);
        this.setC_Year_ID(year.getC_Year_ID());
        this.setPeriodNo(PeriodNo);
        this.setName(name);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public MPeriodControl[] getPeriodControls(boolean requery) {
        if (this.m_controls != null && !requery) {
            return this.m_controls;
        }
        ArrayList<MPeriodControl> list = new ArrayList<MPeriodControl>();
        String sql = "SELECT * FROM C_PeriodControl WHERE C_Period_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getC_Period_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPeriodControl(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_controls = new MPeriodControl[list.size()];
        list.toArray(this.m_controls);
        return this.m_controls;
    }

    public MPeriodControl getPeriodControl(String DocBaseType) {
        if (DocBaseType == null) {
            return null;
        }
        this.getPeriodControls(false);
        for (int i2 = 0; i2 < this.m_controls.length; ++i2) {
            if (!DocBaseType.equals(this.m_controls[i2].getDocBaseType())) continue;
            return this.m_controls[i2];
        }
        return null;
    }

    public boolean isInPeriod(Timestamp date) {
        Timestamp from;
        if (date == null) {
            return false;
        }
        Timestamp dateOnly = TimeUtil.getDay(date);
        if (dateOnly.before(from = TimeUtil.getDay(this.getStartDate()))) {
            return false;
        }
        Timestamp to = TimeUtil.getDay(this.getEndDate());
        return !dateOnly.after(to);
    }

    public boolean isOpen(String DocBaseType) {
        if (!this.isActive()) {
            s_log.warning("Period not active: " + this.getName());
            return false;
        }
        MAcctSchema as = MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema();
        if (as != null && as.isAutoPeriodControl()) {
            Timestamp today = new Timestamp(System.currentTimeMillis());
            Timestamp first = TimeUtil.addDays(today, -as.getPeriod_OpenHistory());
            Timestamp last = TimeUtil.addDays(today, as.getPeriod_OpenFuture());
            if (today.before(first)) {
                this.log.warning("Today before first day - " + first);
                return false;
            }
            if (today.after(last)) {
                this.log.warning("Today after last day - " + first);
                return false;
            }
            if (this.isInPeriod(today)) {
                as.setC_Period_ID(this.getC_Period_ID());
                as.save();
            }
            return true;
        }
        if (DocBaseType == null) {
            this.log.warning(this.getName() + " - No DocBaseType");
            return false;
        }
        MPeriodControl pc = this.getPeriodControl(DocBaseType);
        if (pc == null) {
            this.log.warning(this.getName() + " - Period Control not found for " + DocBaseType);
            return false;
        }
        this.log.fine(this.getName() + ": " + DocBaseType);
        return pc.isOpen();
    }

    public boolean isStandardPeriod() {
        return "S".equals(this.getPeriodType());
    }

    protected boolean beforeSave(boolean newRecord) {
        Timestamp date = this.getStartDate();
        if (date == null) {
            return false;
        }
        this.setStartDate(TimeUtil.getDay(date));
        date = this.getEndDate();
        if (date != null) {
            this.setEndDate(TimeUtil.getDay(date));
        } else {
            this.setEndDate(TimeUtil.getMonthLastDay(this.getStartDate()));
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            MDocType[] types = MDocType.getOfClient(this.getCtx());
            int count = 0;
            ArrayList<String> baseTypes = new ArrayList<String>();
            for (int i2 = 0; i2 < types.length; ++i2) {
                MDocType type = types[i2];
                String DocBaseType = type.getDocBaseType();
                if (baseTypes.contains(DocBaseType)) continue;
                MPeriodControl pc = new MPeriodControl(this, DocBaseType);
                if (pc.save()) {
                    ++count;
                }
                baseTypes.add(DocBaseType);
            }
            this.log.fine("PeriodControl #" + count);
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPeriod[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(", ").append(this.getStartDate()).append("-").append(this.getEndDate()).append("]");
        return sb.toString();
    }
}

