/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_PaymentAllocate;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPaymentAllocate
extends X_C_PaymentAllocate {
    private static CLogger s_log = CLogger.getCLogger(MPaymentAllocate.class);
    private MInvoice m_invoice = null;

    public static MPaymentAllocate[] get(MPayment parent) {
        ArrayList<MPaymentAllocate> list = new ArrayList<MPaymentAllocate>();
        String sql = "SELECT * FROM C_PaymentAllocate WHERE C_Payment_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, parent.getC_Payment_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPaymentAllocate(parent.getCtx(), rs, parent.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MPaymentAllocate[] retValue = new MPaymentAllocate[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPaymentAllocate(Properties ctx, int C_PaymentAllocate_ID, String trxName) {
        super(ctx, C_PaymentAllocate_ID, trxName);
        if (C_PaymentAllocate_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setOverUnderAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setInvoiceAmt(Env.ZERO);
        }
    }

    public MPaymentAllocate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setC_Invoice_ID(int C_Invoice_ID) {
        super.setC_Invoice_ID(C_Invoice_ID);
        this.m_invoice = null;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    public int getC_BPartner_ID() {
        if (this.m_invoice == null) {
            this.getInvoice();
        }
        if (this.m_invoice == null) {
            return 0;
        }
        return this.m_invoice.getC_BPartner_ID();
    }

    protected boolean beforeSave(boolean newRecord) {
        MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if ((newRecord || this.is_ValueChanged("C_Invoice_ID")) && (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0)) {
            this.log.saveError("PaymentIsAllocated", "");
            return false;
        }
        BigDecimal check = this.getAmount().add(this.getDiscountAmt()).add(this.getWriteOffAmt()).add(this.getOverUnderAmt());
        if (check.compareTo(this.getInvoiceAmt()) != 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@InvoiceAmt@(" + this.getInvoiceAmt() + ") <> @Totals@(" + check + ")"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            this.getInvoice();
            if (this.m_invoice != null) {
                this.setAD_Org_ID(this.m_invoice.getAD_Org_ID());
            }
        }
        return true;
    }
}

