/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPAttributeLookup
extends Lookup
implements Serializable {
    private Properties m_ctx;
    private PreparedStatement m_pstmt = null;
    private static KeyNamePair NO_INSTANCE = new KeyNamePair(0, "");

    public MPAttributeLookup(Properties ctx, int WindowNo) {
        super(19, WindowNo);
        this.m_ctx = ctx;
    }

    @Override
    public String getDisplay(Object value) {
        if (value == null) {
            return "";
        }
        NamePair pp = this.get(value);
        if (pp == null) {
            return "<" + value.toString() + ">";
        }
        return pp.getName();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public NamePair get(Object value) {
        if (value == null) {
            return null;
        }
        int M_AttributeSetInstance_ID = 0;
        if (value instanceof Integer) {
            M_AttributeSetInstance_ID = (Integer)value;
        } else {
            try {
                M_AttributeSetInstance_ID = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Value=" + value, e);
            }
        }
        if (M_AttributeSetInstance_ID == 0) {
            return NO_INSTANCE;
        }
        if (this.m_pstmt == null) {
            this.m_pstmt = DB.prepareStatement("SELECT Description FROM M_AttributeSetInstance WHERE M_AttributeSetInstance_ID=?", null);
        }
        String Description = null;
        try {
            this.m_pstmt.setInt(1, M_AttributeSetInstance_ID);
            ResultSet rs = this.m_pstmt.executeQuery();
            if (rs.next() && ((Description = rs.getString(1)) == null || Description.length() == 0)) {
                Description = CLogMgt.isLevelFine() ? "{" + M_AttributeSetInstance_ID + "}" : "";
            }
            rs.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "get", e);
        }
        if (Description == null) {
            return null;
        }
        return new KeyNamePair(M_AttributeSetInstance_ID, Description);
    }

    @Override
    public void dispose() {
        try {
            if (this.m_pstmt != null) {
                this.m_pstmt.close();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "dispose", e);
        }
        this.log.fine("");
        super.dispose();
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        this.log.log(Level.SEVERE, "Not implemented");
        return null;
    }

    @Override
    public String getColumnName() {
        return "M_AttributeSetInstance_ID";
    }
}

