/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Org;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MOrg
extends X_AD_Org {
    private static CLogger s_log = CLogger.getCLogger(MOrg.class);
    private static CCache<Integer, MOrg> s_cache = new CCache("AD_Org", 20);
    private MOrgInfo m_info = null;
    private Integer m_linkedBPartner = null;

    public static MOrg[] getOfClient(PO po) {
        ArrayList<MOrg> list = new ArrayList<MOrg>();
        String sql = "SELECT * FROM AD_Org WHERE AD_Client_ID=? ORDER BY Value";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, po.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MOrg(po.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MOrg[] retValue = new MOrg[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MOrg get(Properties ctx, int AD_Org_ID) {
        Integer key = new Integer(AD_Org_ID);
        MOrg retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MOrg(ctx, AD_Org_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MOrg(Properties ctx, int AD_Org_ID, String trxName) {
        super(ctx, AD_Org_ID, trxName);
        if (AD_Org_ID == 0) {
            this.setIsSummary(false);
        }
    }

    public MOrg(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MOrg(MClient client, String name) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setAD_Client_ID(client.getAD_Client_ID());
        this.setValue(name);
        this.setName(name);
    }

    public MOrgInfo getInfo() {
        if (this.m_info == null) {
            this.m_info = MOrgInfo.get(this.getCtx(), this.getAD_Org_ID());
        }
        return this.m_info;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            this.m_info = new MOrgInfo(this);
            this.m_info.save();
            MRoleOrgAccess.createForOrg(this);
            MRole.getDefault(this.getCtx(), true);
            this.insert_Tree("OO");
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "AD_Org_ID=" + this.getAD_Org_ID(), this.get_TrxName());
            if ("Y".equals(Env.getContext(this.getCtx(), "$Element_OT"))) {
                MAccount.updateValueDescription(this.getCtx(), "AD_OrgTrx_ID=" + this.getAD_Org_ID(), this.get_TrxName());
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("OO");
        }
        return success;
    }

    public int getLinkedC_BPartner_ID() {
        if (this.m_linkedBPartner == null) {
            int C_BPartner_ID = DB.getSQLValue(null, "SELECT C_BPartner_ID FROM C_BPartner WHERE AD_OrgBP_ID=?", this.getAD_Org_ID());
            if (C_BPartner_ID < 0) {
                C_BPartner_ID = 0;
            }
            this.m_linkedBPartner = new Integer(C_BPartner_ID);
        }
        return this.m_linkedBPartner;
    }
}

