/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.X_M_MovementLineConfirm;
import org.compiere.util.Env;

public class MMovementLineConfirm
extends X_M_MovementLineConfirm {
    private MMovementLine m_line = null;

    public MMovementLineConfirm(Properties ctx, int M_MovementLineConfirm_ID, String trxName) {
        super(ctx, M_MovementLineConfirm_ID, trxName);
        if (M_MovementLineConfirm_ID == 0) {
            this.setConfirmedQty(Env.ZERO);
            this.setDifferenceQty(Env.ZERO);
            this.setScrappedQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MMovementLineConfirm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLineConfirm(MMovementConfirm parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_MovementConfirm_ID(parent.getM_MovementConfirm_ID());
    }

    public void setMovementLine(MMovementLine line) {
        this.setM_MovementLine_ID(line.getM_MovementLine_ID());
        this.setTargetQty(line.getMovementQty());
        this.setConfirmedQty(this.getTargetQty());
        this.m_line = line;
    }

    public MMovementLine getLine() {
        if (this.m_line == null) {
            this.m_line = new MMovementLine(this.getCtx(), this.getM_MovementLine_ID(), this.get_TrxName());
        }
        return this.m_line;
    }

    public boolean processLine() {
        MMovementLine line = this.getLine();
        line.setTargetQty(this.getTargetQty());
        line.setMovementQty(this.getConfirmedQty());
        line.setConfirmedQty(this.getConfirmedQty());
        line.setScrappedQty(this.getScrappedQty());
        return line.save(this.get_TrxName());
    }

    public boolean isFullyConfirmed() {
        return this.getTargetQty().compareTo(this.getConfirmedQty()) == 0;
    }

    protected boolean beforeDelete() {
        return false;
    }

    protected boolean beforeSave(boolean newRecord) {
        BigDecimal difference = this.getTargetQty();
        difference = difference.subtract(this.getConfirmedQty());
        difference = difference.subtract(this.getScrappedQty());
        this.setDifferenceQty(difference);
        return true;
    }
}

