/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MMovement;
import org.compiere.model.MProduct;
import org.compiere.model.X_M_MovementLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MMovementLine
extends X_M_MovementLine {
    private MMovement m_parent = null;

    public MMovementLine(Properties ctx, int M_MovementLine_ID, String trxName) {
        super(ctx, M_MovementLine_ID, trxName);
        if (M_MovementLine_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setMovementQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setScrappedQty(Env.ZERO);
            this.setConfirmedQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MMovementLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLine(MMovement parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_Movement_ID(parent.getM_Movement_ID());
    }

    public int getM_AttributeSetInstanceTo_ID() {
        int M_AttributeSetInstanceTo_ID = super.getM_AttributeSetInstanceTo_ID();
        if (M_AttributeSetInstanceTo_ID == 0) {
            M_AttributeSetInstanceTo_ID = super.getM_AttributeSetInstance_ID();
        }
        return M_AttributeSetInstanceTo_ID;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public MProduct getProduct() {
        if (this.getM_Product_ID() != 0) {
            return MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return null;
    }

    public void setMovementQty(BigDecimal MovementQty) {
        MProduct product;
        if (MovementQty != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            MovementQty = MovementQty.setScale(precision, 4);
        }
        super.setMovementQty(MovementQty);
    }

    public MMovement getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MMovement(this.getCtx(), this.getM_Movement_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM M_MovementLine WHERE M_Movement_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_Movement_ID());
            this.setLine(ii);
        }
        if (this.getM_Locator_ID() == this.getM_LocatorTo_ID()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@M_Locator_ID@ == @M_LocatorTo_ID@"));
            return false;
        }
        if (this.getMovementQty().signum() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "MovementQty"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setMovementQty(this.getMovementQty());
        }
        return true;
    }
}

