/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLotCtl;
import org.compiere.model.X_M_Lot;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class MLot
extends X_M_Lot {
    private static CLogger s_log = CLogger.getCLogger(MLot.class);

    public static MLot[] getProductLots(Properties ctx, int M_Product_ID, String trxName) {
        String sql = "SELECT * FROM M_Lot WHERE M_Product_ID=?";
        ArrayList<MLot> list = new ArrayList<MLot>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLot(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MLot[] retValue = new MLot[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MLot getProductLot(Properties ctx, int M_Product_ID, String lot, String trxName) {
        String sql = "SELECT * FROM M_Lot WHERE M_Product_ID=? AND Name=?";
        MLot retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setString(2, lot);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                retValue = new MLot(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        return retValue;
    }

    public static KeyNamePair[] getProductLotPairs(int M_Product_ID, String trxName) {
        String sql = "SELECT M_Lot_ID, Name FROM M_Lot WHERE M_Product_ID=?";
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MLot(Properties ctx, int M_Lot_ID, String trxName) {
        super(ctx, M_Lot_ID, trxName);
    }

    public MLot(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLot(MLotCtl ctl, int M_Product_ID, String Name2) {
        this(ctl.getCtx(), 0, ctl.get_TrxName());
        this.setClientOrg(ctl);
        this.setM_LotCtl_ID(ctl.getM_LotCtl_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setName(Name2);
    }

    public String toString() {
        return this.getName();
    }
}

