/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.LookupDisplayColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class MLookupFactory {
    private static CLogger s_log = CLogger.getCLogger(MLookupFactory.class);
    private static CCache<String, MLookupInfo> s_cacheRefTable = new CCache("AD_Ref_Table", 30, 60);

    public static MLookup get(Properties ctx, int WindowNo, int Column_ID, int AD_Reference_ID, Language language, String ColumnName, int AD_Reference_Value_ID, boolean IsParent, String ValidationCode) throws Exception {
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, WindowNo, Column_ID, AD_Reference_ID, language, ColumnName, AD_Reference_Value_ID, IsParent, ValidationCode);
        if (info == null) {
            throw new Exception("MLookup.create - no LookupInfo");
        }
        return new MLookup(info, 0);
    }

    public static MLookup get(Properties ctx, int WindowNo, int TabNo, int Column_ID, int AD_Reference_ID) {
        String ColumnName = "";
        int AD_Reference_Value_ID = 0;
        boolean IsParent = false;
        String ValidationCode = "";
        String sql = "SELECT c.ColumnName, c.AD_Reference_Value_ID, c.IsParent, vr.Code FROM AD_Column c LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE c.AD_Column_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Column_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ColumnName = rs.getString(1);
                AD_Reference_Value_ID = rs.getInt(2);
                IsParent = "Y".equals(rs.getString(3));
                ValidationCode = rs.getString(4);
            } else {
                s_log.log(Level.SEVERE, "Column Not Found - AD_Column_ID=" + Column_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, "create", ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, WindowNo, Column_ID, AD_Reference_ID, Env.getLanguage(ctx), ColumnName, AD_Reference_Value_ID, IsParent, ValidationCode);
        return new MLookup(info, TabNo);
    }

    public static MLookupInfo getLookupInfo(Properties ctx, int WindowNo, int Column_ID, int AD_Reference_ID, Language language, String ColumnName, int AD_Reference_Value_ID, boolean IsParent, String ValidationCode) {
        boolean hasWhere;
        MLookupInfo info = null;
        boolean needToAddSecurity = true;
        if (AD_Reference_ID == 17) {
            info = MLookupFactory.getLookup_List(language, AD_Reference_Value_ID);
            needToAddSecurity = false;
        } else {
            info = (AD_Reference_ID == 18 || AD_Reference_ID == 30) && AD_Reference_Value_ID != 0 ? MLookupFactory.getLookup_Table(ctx, language, WindowNo, AD_Reference_Value_ID) : MLookupFactory.getLookup_TableDir(ctx, language, WindowNo, ColumnName);
        }
        if (info == null) {
            s_log.severe("No SQL - " + ColumnName);
            return null;
        }
        info.ctx = ctx;
        info.WindowNo = WindowNo;
        info.Column_ID = Column_ID;
        info.DisplayType = AD_Reference_ID;
        info.AD_Reference_Value_ID = AD_Reference_Value_ID;
        info.IsParent = IsParent;
        info.ValidationCode = ValidationCode;
        if (info.ValidationCode == null) {
            info.ValidationCode = "";
        }
        if (info.Query.indexOf("@") != -1) {
            String newSQL = Env.parseContext(ctx, 0, info.Query, false);
            if (newSQL.length() == 0) {
                s_log.severe("SQL parse error: " + info.Query);
                return null;
            }
            info.Query = newSQL;
            s_log.fine("getLookupInfo, newSQL =" + newSQL);
        }
        int posOrder = info.Query.lastIndexOf(" ORDER BY ");
        boolean bl = hasWhere = info.Query.lastIndexOf(" WHERE ") != -1;
        if (hasWhere) {
            AccessSqlParser asp = new AccessSqlParser(info.Query);
            String mainQuery = asp.getMainSql();
            boolean bl2 = hasWhere = mainQuery.indexOf(" WHERE ") != -1;
        }
        info.QueryDirect = posOrder == -1 ? info.Query + (hasWhere ? " AND " : " WHERE ") + info.KeyColumn + "=?" : info.Query.substring(0, posOrder) + (hasWhere ? " AND " : " WHERE ") + info.KeyColumn + "=?";
        String local_validationCode = "";
        info.IsValidated = info.ValidationCode.length() == 0 ? true : (local_validationCode = Env.parseContext(ctx, WindowNo, info.ValidationCode, true)).length() != 0;
        if (local_validationCode.length() != 0) {
            info.Query = posOrder > 0 ? info.Query.substring(0, posOrder) + (hasWhere ? " AND " : " WHERE ") + local_validationCode + info.Query.substring(posOrder) : info.Query + (hasWhere ? " AND " : " WHERE ") + local_validationCode;
        }
        if (needToAddSecurity) {
            info.Query = MRole.getDefault(ctx, false).addAccessSQL(info.Query, info.TableName, true, false);
        }
        return info;
    }

    public static MLookupInfo getLookup_List(Language language, int AD_Reference_Value_ID) {
        StringBuffer realSQL = new StringBuffer("SELECT NULL, AD_Ref_List.Value,");
        if (Env.isBaseLanguage(language, "AD_Ref_List")) {
            realSQL.append("AD_Ref_List.Name,AD_Ref_List.IsActive FROM AD_Ref_List");
        } else {
            realSQL.append("trl.Name, AD_Ref_List.IsActive FROM AD_Ref_List INNER JOIN AD_Ref_List_Trl trl  ON (AD_Ref_List.AD_Ref_List_ID=trl.AD_Ref_List_ID AND trl.AD_Language='").append(language.getAD_Language()).append("')");
        }
        realSQL.append(" WHERE AD_Ref_List.AD_Reference_ID=").append(AD_Reference_Value_ID);
        realSQL.append(" ORDER BY 2");
        return new MLookupInfo(realSQL.toString(), "AD_Ref_List", "AD_Ref_List.Value", 101, 101, MQuery.getEqualQuery("AD_Reference_ID", AD_Reference_Value_ID));
    }

    public static String getLookup_ListEmbed(Language language, int AD_Reference_Value_ID, String linkColumnName) {
        StringBuffer realSQL = new StringBuffer("SELECT ");
        if (Env.isBaseLanguage(language, "AD_Ref_List")) {
            realSQL.append("AD_Ref_List.Name FROM AD_Ref_List");
        } else {
            realSQL.append("trl.Name FROM AD_Ref_List INNER JOIN AD_Ref_List_Trl trl  ON (AD_Ref_List.AD_Ref_List_ID=trl.AD_Ref_List_ID AND trl.AD_Language='").append(language.getAD_Language()).append("')");
        }
        realSQL.append(" WHERE AD_Ref_List.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND AD_Ref_List.Value=").append(linkColumnName);
        return realSQL.toString();
    }

    private static MLookupInfo getLookup_Table(Properties ctx, Language language, int WindowNo, int AD_Reference_Value_ID) {
        String key = String.valueOf(AD_Reference_Value_ID);
        MLookupInfo retValue = s_cacheRefTable.get(key);
        if (retValue != null) {
            s_log.finest("Cache: " + retValue);
            return retValue.cloneIt();
        }
        String sql0 = "SELECT t.TableName,ck.ColumnName AS KeyColumn,cd.ColumnName AS DisplayColumn,rt.IsValueDisplayed,cd.IsTranslated,rt.WhereClause,rt.OrderByClause,t.AD_Window_ID,t.PO_Window_ID, t.AD_Table_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Column ck ON (rt.AD_Key=ck.AD_Column_ID) INNER JOIN AD_Column cd ON (rt.AD_Display=cd.AD_Column_ID) WHERE rt.AD_Reference_ID=? AND rt.IsActive='Y' AND t.IsActive='Y'";
        String KeyColumn = null;
        String DisplayColumn = null;
        String TableName = null;
        String WhereClause = null;
        String OrderByClause = null;
        boolean IsTranslated = false;
        boolean isValueDisplayed = false;
        boolean isSOTrx = !"N".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        int ZoomWindow = 0;
        int ZoomWindowPO = 0;
        int AD_Table_ID = 0;
        boolean loaded = false;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql0, null);
            pstmt.setInt(1, AD_Reference_Value_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                TableName = rs.getString(1);
                KeyColumn = rs.getString(2);
                DisplayColumn = rs.getString(3);
                isValueDisplayed = "Y".equals(rs.getString(4));
                IsTranslated = "Y".equals(rs.getString(5));
                WhereClause = rs.getString(6);
                OrderByClause = rs.getString(7);
                ZoomWindow = rs.getInt(8);
                ZoomWindowPO = rs.getInt(9);
                AD_Table_ID = rs.getInt(10);
                loaded = true;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql0, e);
            return null;
        }
        if (!loaded) {
            s_log.log(Level.SEVERE, "No Table Reference Table ID=" + AD_Reference_Value_ID);
            return null;
        }
        StringBuffer realSQL = new StringBuffer("SELECT ");
        if (!KeyColumn.endsWith("_ID")) {
            realSQL.append("NULL,");
        }
        if (IsTranslated && !Env.isBaseLanguage(language, TableName)) {
            realSQL.append(TableName).append(".").append(KeyColumn).append(",");
            if (KeyColumn.endsWith("_ID")) {
                realSQL.append("NULL,");
            }
            if (isValueDisplayed) {
                realSQL.append(TableName).append(".Value || '-' || ");
            }
            realSQL.append(TableName).append("_Trl.").append(DisplayColumn).append(",").append(TableName).append(".IsActive");
            realSQL.append(" FROM ").append(TableName).append(" INNER JOIN ").append(TableName).append("_TRL ON (").append(TableName).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language='").append(language.getAD_Language()).append("')");
        } else {
            realSQL.append(TableName).append(".").append(KeyColumn).append(",");
            if (KeyColumn.endsWith("_ID")) {
                realSQL.append("NULL,");
            }
            if (isValueDisplayed) {
                realSQL.append(TableName).append(".Value || '-' || ");
            }
            realSQL.append(TableName).append(".").append(DisplayColumn);
            realSQL.append(",").append(TableName).append(".IsActive");
            realSQL.append(" FROM ").append(TableName);
        }
        MQuery zoomQuery = null;
        if (WhereClause != null) {
            String where = WhereClause;
            if (where.indexOf("@") != -1) {
                where = Env.parseContext(ctx, WindowNo, where, false);
            }
            if (where.length() == 0 && WhereClause.length() != 0) {
                s_log.severe("Could not resolve: " + WhereClause);
            }
            if (where.length() != 0) {
                realSQL.append(" WHERE ").append(where);
                if (where.indexOf(".") == -1) {
                    s_log.log(Level.SEVERE, "getLookup_Table - " + TableName + ": WHERE should be fully qualified: " + WhereClause);
                }
                zoomQuery = new MQuery(TableName);
                zoomQuery.addRestriction(where);
            }
        }
        if (OrderByClause != null) {
            realSQL.append(" ORDER BY ").append(OrderByClause);
            if (OrderByClause.indexOf(".") == -1) {
                s_log.log(Level.SEVERE, "getLookup_Table - " + TableName + ": ORDER BY must fully qualified: " + OrderByClause);
            }
        } else {
            realSQL.append(" ORDER BY 3");
        }
        s_log.finest("AD_Reference_Value_ID=" + AD_Reference_Value_ID + " - " + realSQL);
        retValue = new MLookupInfo(realSQL.toString(), TableName, TableName + "." + KeyColumn, ZoomWindow, ZoomWindowPO, zoomQuery);
        s_cacheRefTable.put(key, retValue.cloneIt());
        return retValue;
    }

    public static String getLookup_TableEmbed(Language language, String BaseColumn, String BaseTable, int AD_Reference_Value_ID) {
        boolean IsTranslated;
        boolean isValueDisplayed;
        String DisplayColumn;
        String KeyColumn;
        String TableName;
        String sql = "SELECT t.TableName,ck.ColumnName AS KeyColumn,cd.ColumnName AS DisplayColumn,rt.isValueDisplayed,cd.IsTranslated FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Column ck ON (rt.AD_Key=ck.AD_Column_ID) INNER JOIN AD_Column cd ON (rt.AD_Display=cd.AD_Column_ID) WHERE rt.AD_Reference_ID=? AND rt.IsActive='Y' AND t.IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_Value_ID);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                s_log.log(Level.SEVERE, "Cannot find Reference Table, ID=" + AD_Reference_Value_ID + ", Base=" + BaseTable + "." + BaseColumn);
                rs.close();
                pstmt.close();
                return null;
            }
            TableName = rs.getString(1);
            KeyColumn = rs.getString(2);
            DisplayColumn = rs.getString(3);
            isValueDisplayed = rs.getString(4).equals("Y");
            IsTranslated = rs.getString(5).equals("Y");
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
            return null;
        }
        StringBuffer embedSQL = new StringBuffer("SELECT ");
        if (IsTranslated && !Env.isBaseLanguage(language, TableName)) {
            if (isValueDisplayed) {
                embedSQL.append(TableName).append(".Value||'-'||");
            }
            embedSQL.append(TableName).append("_Trl.").append(DisplayColumn);
            embedSQL.append(" FROM ").append(TableName).append(" INNER JOIN ").append(TableName).append("_TRL ON (").append(TableName).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language='").append(language.getAD_Language()).append("')");
        } else {
            if (isValueDisplayed) {
                embedSQL.append(TableName).append(".Value||'-'||");
            }
            embedSQL.append(TableName).append(".").append(DisplayColumn);
            embedSQL.append(" FROM ").append(TableName);
        }
        embedSQL.append(" WHERE ").append(BaseTable).append(".").append(BaseColumn);
        embedSQL.append("=").append(TableName).append(".").append(KeyColumn);
        return embedSQL.toString();
    }

    private static MLookupInfo getLookup_TableDir(Properties ctx, Language language, int WindowNo, String ColumnName) {
        if (!ColumnName.endsWith("_ID")) {
            s_log.log(Level.SEVERE, "Key does not end with '_ID': " + ColumnName);
            return null;
        }
        if (ColumnName.equals("AD_OrgBP_ID")) {
            ColumnName = "AD_Org_ID";
        }
        String TableName = ColumnName.substring(0, ColumnName.length() - 3);
        boolean isSOTrx = !"N".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        int ZoomWindow = 0;
        int ZoomWindowPO = 0;
        String sql0 = "SELECT c.ColumnName,c.IsTranslated,c.AD_Reference_ID,c.AD_Reference_Value_ID,t.AD_Window_ID,t.PO_Window_ID FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE TableName=? AND c.IsIdentifier='Y' ORDER BY c.SeqNo";
        String KeyColumn = ColumnName;
        ArrayList<LookupDisplayColumn> list = new ArrayList<LookupDisplayColumn>();
        boolean isTranslated = false;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql0, null);
            pstmt.setString(1, TableName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                LookupDisplayColumn ldc = new LookupDisplayColumn(rs.getString(1), "Y".equals(rs.getString(2)), rs.getInt(3), rs.getInt(4));
                list.add(ldc);
                if (!isTranslated && ldc.IsTranslated) {
                    isTranslated = true;
                }
                ZoomWindow = rs.getInt(5);
                ZoomWindowPO = rs.getInt(6);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql0, e);
            return null;
        }
        if (list.size() == 0) {
            s_log.log(Level.SEVERE, "No Identifier records found: " + ColumnName);
            return null;
        }
        StringBuffer realSQL = new StringBuffer("SELECT ");
        realSQL.append(TableName).append(".").append(KeyColumn).append(",NULL,");
        StringBuffer displayColumn = new StringBuffer();
        int size = list.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String embeddedSQL;
            if (i2 > 0) {
                displayColumn.append(" ||'_'|| ");
            }
            LookupDisplayColumn ldc = (LookupDisplayColumn)list.get(i2);
            if (ldc.IsTranslated && !Env.isBaseLanguage(language, TableName)) {
                displayColumn.append(TableName).append("_Trl.").append(ldc.ColumnName);
                continue;
            }
            if (DisplayType.isDate(ldc.DisplayType)) {
                displayColumn.append(DB.TO_CHAR(TableName + "." + ldc.ColumnName, ldc.DisplayType, language.getAD_Language()));
                continue;
            }
            if ((ldc.DisplayType == 19 || ldc.DisplayType == 30) && ldc.ColumnName.endsWith("_ID")) {
                embeddedSQL = MLookupFactory.getLookup_TableDirEmbed(language, ldc.ColumnName, TableName);
                if (embeddedSQL == null) continue;
                displayColumn.append("(").append(embeddedSQL).append(")");
                continue;
            }
            if (ldc.DisplayType == 18 && ldc.AD_Reference_ID != 0) {
                embeddedSQL = MLookupFactory.getLookup_TableEmbed(language, ldc.ColumnName, TableName, ldc.AD_Reference_ID);
                if (embeddedSQL == null) continue;
                displayColumn.append("(").append(embeddedSQL).append(")");
                continue;
            }
            if (DisplayType.isNumeric(ldc.DisplayType)) {
                displayColumn.append(DB.TO_CHAR(TableName + "." + ldc.ColumnName, ldc.DisplayType, language.getAD_Language()));
                continue;
            }
            displayColumn.append(TableName).append(".").append(ldc.ColumnName);
        }
        realSQL.append(displayColumn.toString());
        realSQL.append(",").append(TableName).append(".IsActive");
        if (isTranslated && !Env.isBaseLanguage(language, TableName)) {
            realSQL.append(" FROM ").append(TableName).append(" INNER JOIN ").append(TableName).append("_TRL ON (").append(TableName).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language='").append(language.getAD_Language()).append("')");
        } else {
            realSQL.append(" FROM ").append(TableName);
        }
        realSQL.append(" ORDER BY 3");
        MQuery zoomQuery = null;
        if (CLogMgt.isLevelFinest()) {
            s_log.fine("ColumnName=" + ColumnName + " - " + realSQL);
        }
        MLookupInfo lInfo = new MLookupInfo(realSQL.toString(), TableName, TableName + "." + KeyColumn, ZoomWindow, ZoomWindowPO, zoomQuery);
        return lInfo;
    }

    public static String getLookup_TableDirEmbed(Language language, String ColumnName, String BaseTable) {
        return MLookupFactory.getLookup_TableDirEmbed(language, ColumnName, BaseTable, ColumnName);
    }

    public static String getLookup_TableDirEmbed(Language language, String ColumnName, String BaseTable, String BaseColumn) {
        String TableName = ColumnName.substring(0, ColumnName.length() - 3);
        String sql = "SELECT c.ColumnName,c.IsTranslated,c.AD_Reference_ID,c.AD_Reference_Value_ID FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE TableName=? AND c.IsIdentifier='Y' ORDER BY c.SeqNo";
        ArrayList<LookupDisplayColumn> list = new ArrayList<LookupDisplayColumn>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, TableName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                LookupDisplayColumn ldc = new LookupDisplayColumn(rs.getString(1), "Y".equals(rs.getString(2)), rs.getInt(3), rs.getInt(4));
                list.add(ldc);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
            return "";
        }
        if (list.size() == 0) {
            s_log.log(Level.SEVERE, "No Identifier records found: " + ColumnName);
            return "";
        }
        StringBuffer embedSQL = new StringBuffer("SELECT ");
        int size = list.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 > 0) {
                embedSQL.append("||' - '||");
            }
            LookupDisplayColumn ldc = (LookupDisplayColumn)list.get(i2);
            if (DisplayType.isDate(ldc.DisplayType) || DisplayType.isNumeric(ldc.DisplayType)) {
                embedSQL.append(DB.TO_CHAR(TableName + "." + ldc.ColumnName, ldc.DisplayType, language.getAD_Language()));
                continue;
            }
            if ((ldc.DisplayType == 19 || ldc.DisplayType == 30) && ldc.ColumnName.endsWith("_ID")) {
                String embeddedSQL = MLookupFactory.getLookup_TableDirEmbed(language, ldc.ColumnName, TableName);
                embedSQL.append("(").append(embeddedSQL).append(")");
                continue;
            }
            embedSQL.append(TableName).append(".").append(ldc.ColumnName);
        }
        embedSQL.append(" FROM ").append(TableName);
        embedSQL.append(" WHERE ").append(BaseTable).append(".").append(BaseColumn);
        embedSQL.append("=").append(TableName).append(".").append(ColumnName);
        return embedSQL.toString();
    }
}

