/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MLdapAccess;
import org.compiere.model.MLdapProcessorLog;
import org.compiere.model.MLdapUser;
import org.compiere.model.X_AD_LdapProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MLdapProcessor
extends X_AD_LdapProcessor
implements AdempiereProcessor {
    private static CLogger log = CLogger.getCLogger(MLdapProcessor.class);
    private MClient[] m_clients = null;
    private MInterestArea[] m_interests = null;
    private int m_auth = 0;
    private int m_ok = 0;
    private int m_error = 0;

    public static MLdapProcessor[] getActive(Properties ctx) {
        ArrayList<MLdapProcessor> list = new ArrayList<MLdapProcessor>();
        String sql = "SELECT * FROM AD_LdapProcessor WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLdapProcessor(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MLdapProcessor[] retValue = new MLdapProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MLdapProcessor(Properties ctx, int AD_LdapProcessor_ID, String trxName) {
        super(ctx, AD_LdapProcessor_ID, trxName);
    }

    public MLdapProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getServerID() {
        return "Ldap" + this.get_ID();
    }

    public String getInfo() {
        return "Auth=" + this.m_auth + ", OK=" + this.m_ok + ", Error=" + this.m_error;
    }

    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MLdapProcessorLog> list = new ArrayList<MLdapProcessorLog>();
        String sql = "SELECT * FROM AD_LdapProcessorLog WHERE AD_LdapProcessor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_LdapProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLdapProcessorLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MLdapProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE AD_LdapProcessorLog WHERE AD_LdapProcessor_ID=" + this.getAD_LdapProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    public int getFrequency() {
        return 1;
    }

    public String getFrequencyType() {
        return "M";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MLdapProcessor[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Port=").append(this.getLdapPort()).append("]");
        return sb.toString();
    }

    public MLdapUser authenticate(MLdapUser ldapUser, String usr, String o, String ou) {
        if (ldapUser == null) {
            ldapUser = new MLdapUser();
        }
        String error = null;
        String info = null;
        if (usr == null || usr.trim().length() == 0) {
            error = "@NotFound@ User";
            ldapUser.setErrorString(error);
            ++this.m_error;
            log.warning(error);
            return ldapUser;
        }
        usr = usr.trim();
        if (o == null || o.length() == 0) {
            error = "@NotFound@ O";
            ldapUser.setErrorString(error);
            ++this.m_error;
            log.warning(error);
            return ldapUser;
        }
        int AD_Client_ID = this.findClient(o);
        if (AD_Client_ID == 0) {
            error = "@NotFound@ O=" + o;
            ldapUser.setErrorString(error);
            ++this.m_error;
            log.config(error);
            return ldapUser;
        }
        int R_InterestArea_ID = 0;
        if (ou != null && ou.length() > 0 && (R_InterestArea_ID = this.findInterestArea(AD_Client_ID, ou)) == 0) {
            error = "@NotFound@ OU=" + ou;
            ldapUser.setErrorString(error);
            ++this.m_error;
            log.config(error);
            return ldapUser;
        }
        ++this.m_auth;
        int AD_User_ID = 0;
        String Value = null;
        String LdapUser = null;
        String EMail2 = null;
        String Name2 = null;
        String Password = null;
        boolean IsActive = false;
        String EMailVerify = null;
        boolean isUnique = false;
        String sql = "SELECT AD_User_ID, Value, LdapUser, EMail, Name, Password, IsActive, EMailVerify FROM AD_User WHERE AD_Client_ID=? AND (EMail=? OR Value=? OR LdapUser=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setString(2, usr);
            pstmt.setString(3, usr);
            pstmt.setString(4, usr);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_User_ID = rs.getInt(1);
                Value = rs.getString(2);
                LdapUser = rs.getString(3);
                EMail2 = rs.getString(4);
                Name2 = rs.getString(5);
                Password = rs.getString(6);
                IsActive = "Y".equals(rs.getString(7));
                EMailVerify = rs.getString(8);
                isUnique = rs.next();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            error = "System Error";
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (error != null) {
            ++this.m_error;
            ldapUser.setErrorString(error);
            return ldapUser;
        }
        if (AD_User_ID == 0) {
            error = "@NotFound@ User=" + usr;
            info = "User not found - " + usr;
        } else if (!IsActive) {
            error = "@NotFound@ User=" + usr;
            info = "User not active - " + usr;
        } else if (EMailVerify == null) {
            error = "@UserNotVerified@ User=" + usr;
            info = "User EMail not verified - " + usr;
        } else {
            info = usr.equalsIgnoreCase(LdapUser) ? "User verified - Ldap=" + usr + (isUnique ? "" : " - Not Unique") : (usr.equalsIgnoreCase(Value) ? "User verified - Value=" + usr + (isUnique ? "" : " - Not Unique") : (usr.equalsIgnoreCase(EMail2) ? "User verified - EMail=" + usr + (isUnique ? "" : " - Not Unique") : "User verified ?? " + usr + " - Name=" + Name2 + ", Ldap=" + LdapUser + ", Value=" + Value + (isUnique ? "" : " - Not Unique")));
        }
        if (error != null) {
            this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info, error);
            ldapUser.setErrorString(Msg.translate(this.getCtx(), error));
            return ldapUser;
        }
        if (R_InterestArea_ID == 0) {
            this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info, null);
            ldapUser.setOrg(o);
            ldapUser.setOrgUnit(ou);
            ldapUser.setUserId(usr);
            ldapUser.setPassword(Password);
            return ldapUser;
        }
        String OptOutDate = null;
        boolean found = false;
        sql = "SELECT IsActive, OptOutDate FROM R_ContactInterest WHERE R_InterestArea_ID=? AND AD_User_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, R_InterestArea_ID);
            pstmt.setInt(2, AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                found = true;
                IsActive = "Y".equals(rs.getString(1));
                OptOutDate = rs.getString(2);
                isUnique = rs.next();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            error = "System Error (2)";
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (error != null) {
            ++this.m_error;
            ldapUser.setErrorString(error);
            return ldapUser;
        }
        if (!found) {
            error = "@UserNotSubscribed@ User=" + usr;
            info = "No User Interest - " + usr + " - R_InterestArea_ID=" + R_InterestArea_ID;
        } else if (OptOutDate != null) {
            error = "@UserNotSubscribed@ User=" + usr + " @OptOutDate@=" + OptOutDate;
            info = "Opted out - " + usr + " - OptOutDate=" + OptOutDate;
        } else if (!IsActive) {
            error = "@UserNotSubscribed@ User=" + usr;
            info = "User Interest Not Active - " + usr;
        } else {
            info = "User subscribed - " + usr;
        }
        if (error != null) {
            this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info, error);
            ldapUser.setErrorString(Msg.translate(this.getCtx(), error));
            return ldapUser;
        }
        this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info, null);
        ldapUser.setOrg(o);
        ldapUser.setOrgUnit(ou);
        ldapUser.setUserId(usr);
        ldapUser.setPassword(Password);
        return ldapUser;
    }

    private int findClient(String client) {
        if (this.m_clients == null) {
            this.m_clients = MClient.getAll(this.getCtx());
        }
        for (int i2 = 0; i2 < this.m_clients.length; ++i2) {
            if (!client.equalsIgnoreCase(this.m_clients[i2].getValue())) continue;
            return this.m_clients[i2].getAD_Client_ID();
        }
        return 0;
    }

    private int findInterestArea(int AD_Client_ID, String interestArea) {
        if (this.m_interests == null) {
            this.m_interests = MInterestArea.getAll(this.getCtx());
        }
        for (int i2 = 0; i2 < this.m_interests.length; ++i2) {
            if (AD_Client_ID != this.m_interests[i2].getAD_Client_ID() || !interestArea.equalsIgnoreCase(this.m_interests[i2].getValue())) continue;
            return this.m_interests[i2].getR_InterestArea_ID();
        }
        return 0;
    }

    private void logAccess(int AD_Client_ID, int AD_User_ID, int R_InterestArea_ID, String info, String error) {
        if (error != null) {
            log.log(Level.CONFIG, info);
            ++this.m_error;
        } else {
            log.log(Level.INFO, info);
            ++this.m_ok;
        }
        MLdapAccess access = new MLdapAccess(this.getCtx(), 0, null);
        access.setAD_Client_ID(AD_Client_ID);
        access.setAD_User_ID(AD_User_ID);
        access.setR_InterestArea_ID(R_InterestArea_ID);
        access.setIsError(error != null);
        access.setSummary(info);
        access.save();
    }
}

