/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MDocType;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_GL_Journal;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MJournal
extends X_GL_Journal
implements DocAction {
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MJournal(Properties ctx, int GL_Journal_ID, String trxName) {
        super(ctx, GL_Journal_ID, trxName);
        if (GL_Journal_ID == 0) {
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPostingType("A");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MJournal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournal(MJournalBatch parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setGL_JournalBatch_ID(parent.getGL_JournalBatch_ID());
        this.setC_DocType_ID(parent.getC_DocType_ID());
        this.setPostingType(parent.getPostingType());
        this.setDateDoc(parent.getDateDoc());
        this.setC_Period_ID(parent.getC_Period_ID());
        this.setDateAcct(parent.getDateAcct());
        this.setC_Currency_ID(parent.getC_Currency_ID());
    }

    public MJournal(MJournal original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setGL_JournalBatch_ID(original.getGL_JournalBatch_ID());
        this.setC_AcctSchema_ID(original.getC_AcctSchema_ID());
        this.setGL_Budget_ID(original.getGL_Budget_ID());
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
        this.setC_ConversionType_ID(original.getC_ConversionType_ID());
        this.setCurrencyRate(original.getCurrencyRate());
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
        if (DateAcct == null) {
            return;
        }
        if (this.getC_Period_ID() != 0) {
            return;
        }
        int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), DateAcct);
        if (C_Period_ID == 0) {
            this.log.warning("setDateAcct - Period not found");
        } else {
            this.setC_Period_ID(C_Period_ID);
        }
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        if (C_Currency_ID != 0) {
            this.setC_Currency_ID(C_Currency_ID);
        }
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.compareTo(Env.ZERO) == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    public MJournalLine[] getLines(boolean requery) {
        ArrayList<MJournalLine> list = new ArrayList<MJournalLine>();
        String sql = "SELECT * FROM GL_JournalLine WHERE GL_Journal_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getGL_Journal_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MJournalLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "getLines", ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MJournalLine[] retValue = new MJournalLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MJournal fromJournal, Timestamp dateAcct, char typeCR) {
        if (this.isProcessed() || fromJournal == null) {
            return 0;
        }
        int count = 0;
        MJournalLine[] fromLines = fromJournal.getLines(false);
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MJournalLine toLine = new MJournalLine(this.getCtx(), 0, fromJournal.get_TrxName());
            PO.copyValues(fromLines[i2], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setGL_Journal_ID(this.getGL_Journal_ID());
            if (dateAcct != null) {
                toLine.setDateAcct(dateAcct);
            }
            if (typeCR == 'C') {
                toLine.setAmtSourceDr(fromLines[i2].getAmtSourceDr().negate());
                toLine.setAmtSourceCr(fromLines[i2].getAmtSourceCr().negate());
            } else if (typeCR == 'R') {
                toLine.setAmtSourceDr(fromLines[i2].getAmtSourceCr());
                toLine.setAmtSourceCr(fromLines[i2].getAmtSourceDr());
            }
            toLine.setIsGenerated(true);
            toLine.setProcessed(false);
            if (!toLine.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "copyLinesFrom - Line difference - JournalLines=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE GL_JournalLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine(processed + " - Lines=" + noLine);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateDoc() == null) {
            if (this.getDateAcct() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            } else {
                this.setDateDoc(this.getDateAcct());
            }
        }
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    private boolean updateBatch() {
        String sql = "UPDATE GL_JournalBatch jb SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0) FROM GL_Journal j WHERE j.IsActive='Y' AND jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) WHERE GL_JournalBatch_ID=" + this.getGL_JournalBatch_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("afterSave - Update Batch #" + no);
        }
        return no == 1;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        return true;
    }

    public String prepareIt() {
        MAcctSchemaGL gl;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MPeriod period = MPeriod.get(this.getCtx(), this.getDateAcct());
        if (period == null) {
            this.log.warning("No Period for " + this.getDateAcct());
            this.m_processMsg = "@PeriodNotFound@";
            return "IN";
        }
        if (period.getC_Period_ID() != this.getC_Period_ID() && period.isStandardPeriod()) {
            this.m_processMsg = "@PeriodNotValid@";
            return "IN";
        }
        boolean open = period.isOpen(dt.getDocBaseType());
        if (!open) {
            this.log.warning(period.getName() + ": Not open for " + dt.getDocBaseType() + " (" + this.getDateAcct() + ")");
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MJournalLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal AmtSourceDr = Env.ZERO;
        BigDecimal AmtSourceCr = Env.ZERO;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MJournalLine line = lines[i2];
            if (!this.isActive()) continue;
            if (line.isDocControlled()) {
                this.m_processMsg = "@DocControlledError@ - @Line@=" + line.getLine() + " - " + line.getAccountElementValue();
                return "IN";
            }
            AmtSourceDr = AmtSourceDr.add(line.getAmtSourceDr());
            AmtSourceCr = AmtSourceCr.add(line.getAmtSourceCr());
        }
        this.setTotalDr(AmtSourceDr);
        this.setTotalCr(AmtSourceCr);
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.m_processMsg = "@ControlAmtError@";
            return "IN";
        }
        if (!(AmtSourceDr.compareTo(AmtSourceCr) == 0 || (gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID())) != null && gl.isUseSuspenseBalancing())) {
            this.m_processMsg = "@UnbalancedJornal@";
            return "IN";
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.m_justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus())) {
            this.setProcessed(true);
            this.setDocAction("--");
            return true;
        }
        return false;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        if ("CO".equals(this.getDocStatus())) {
            this.setProcessed(true);
            this.setDocAction("--");
            return true;
        }
        return false;
    }

    public boolean reverseCorrectIt() {
        return this.reverseCorrectIt(this.getGL_JournalBatch_ID()) != null;
    }

    public MJournal reverseCorrectIt(int GL_JournalBatch_ID) {
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setDateDoc(this.getDateDoc());
        reverse.setC_Period_ID(this.getC_Period_ID());
        reverse.setDateAcct(this.getDateAcct());
        String description = reverse.getDescription();
        description = description == null ? "** " + this.getDocumentNo() + " **" : description + " ** " + this.getDocumentNo() + " **";
        reverse.setDescription(description);
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, null, 'C');
        this.setProcessed(true);
        this.setDocAction("--");
        return reverse;
    }

    public boolean reverseAccrualIt() {
        return this.reverseAccrualIt(this.getGL_JournalBatch_ID()) != null;
    }

    public MJournal reverseAccrualIt(int GL_JournalBatch_ID) {
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setC_Period_ID(0);
        reverse.setDateDoc(new Timestamp(System.currentTimeMillis()));
        reverse.setDateAcct(reverse.getDateDoc());
        String description = reverse.getDescription();
        description = description == null ? "** " + this.getDocumentNo() + " **" : description + " ** " + this.getDocumentNo() + " **";
        reverse.setDescription(description);
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, reverse.getDateAcct(), 'R');
        this.setProcessed(true);
        this.setDocAction("--");
        return reverse;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate(this.getCtx(), "TotalCR")).append("=").append(this.getTotalCr()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MJournal[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",DR=").append(this.getTotalDr()).append(",CR=").append(this.getTotalCr()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }
}

