/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySchedule;
import org.compiere.model.X_C_InvoicePaySchedule;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MInvoicePaySchedule
extends X_C_InvoicePaySchedule {
    private static CLogger s_log = CLogger.getCLogger(MInvoicePaySchedule.class);
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private MInvoice m_parent = null;

    public static MInvoicePaySchedule[] getInvoicePaySchedule(Properties ctx, int C_Invoice_ID, int C_InvoicePaySchedule_ID, String trxName) {
        String sql = "SELECT * FROM C_InvoicePaySchedule ips ";
        sql = C_Invoice_ID != 0 ? sql + "WHERE C_Invoice_ID=? " : sql + "WHERE EXISTS (SELECT * FROM C_InvoicePaySchedule x WHERE x.C_InvoicePaySchedule_ID=? AND ips.C_Invoice_ID=x.C_Invoice_ID) ";
        sql = sql + "ORDER BY DueDate";
        ArrayList<MInvoicePaySchedule> list = new ArrayList<MInvoicePaySchedule>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            if (C_Invoice_ID != 0) {
                pstmt.setInt(1, C_Invoice_ID);
            } else {
                pstmt.setInt(1, C_InvoicePaySchedule_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoicePaySchedule(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getInvoicePaySchedule", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MInvoicePaySchedule[] retValue = new MInvoicePaySchedule[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MInvoicePaySchedule(Properties ctx, int C_InvoicePaySchedule_ID, String trxName) {
        super(ctx, C_InvoicePaySchedule_ID, trxName);
        if (C_InvoicePaySchedule_ID == 0) {
            this.setIsValid(false);
        }
    }

    public MInvoicePaySchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoicePaySchedule(MInvoice invoice, MPaySchedule paySchedule) {
        super(invoice.getCtx(), 0, invoice.get_TrxName());
        this.m_parent = invoice;
        this.setClientOrg(invoice);
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setC_PaySchedule_ID(paySchedule.getC_PaySchedule_ID());
        int scale = MCurrency.getStdPrecision(this.getCtx(), invoice.getC_Currency_ID());
        BigDecimal due = invoice.getGrandTotal();
        if (due.compareTo(Env.ZERO) == 0) {
            this.setDueAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsValid(false);
        } else {
            due = due.multiply(paySchedule.getPercentage()).divide(HUNDRED, scale, 4);
            this.setDueAmt(due);
            BigDecimal discount = due.multiply(paySchedule.getDiscount()).divide(HUNDRED, scale, 4);
            this.setDiscountAmt(discount);
            this.setIsValid(true);
        }
        Timestamp dueDate = TimeUtil.addDays(invoice.getDateInvoiced(), paySchedule.getNetDays());
        this.setDueDate(dueDate);
        Timestamp discountDate = TimeUtil.addDays(invoice.getDateInvoiced(), paySchedule.getDiscountDays());
        this.setDiscountDate(discountDate);
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MInvoice parent) {
        this.m_parent = parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoicePaySchedule[");
        sb.append(this.get_ID()).append("-Due=" + this.getDueDate() + "/" + this.getDueAmt()).append(";Discount=").append(this.getDiscountDate() + "/" + this.getDiscountAmt()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("DueAmt")) {
            this.log.fine("beforeSave");
            this.setIsValid(false);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.is_ValueChanged("DueAmt")) {
            this.log.fine("afterSave");
            this.getParent();
            this.m_parent.validatePaySchedule();
            this.m_parent.save();
        }
        return success;
    }
}

