/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MLandedCost;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.Tax;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MInvoiceLine
extends X_C_InvoiceLine {
    private static CLogger s_log = CLogger.getCLogger(MInvoiceLine.class);
    private int m_M_PriceList_ID = 0;
    private Timestamp m_DateInvoiced = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_BPartner_Location_ID = 0;
    private boolean m_IsSOTrx = true;
    private boolean m_priceSet = false;
    private MProduct m_product = null;
    private String m_name = null;
    private Integer m_precision = null;
    private MProductPricing m_productPricing = null;
    private MInvoice m_parent = null;

    public static MInvoiceLine getOfInOutLine(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        MInvoiceLine retValue = null;
        String sql = "SELECT * FROM C_InvoiceLine WHERE M_InOutLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, sLine.get_TrxName());
            pstmt.setInt(1, sLine.getM_InOutLine_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MInvoiceLine(sLine.getCtx(), rs, sLine.get_TrxName());
                if (rs.next()) {
                    s_log.warning("More than one C_InvoiceLine of " + sLine);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        super(ctx, C_InvoiceLine_ID, trxName);
        if (C_InvoiceLine_ID == 0) {
            this.setIsDescription(false);
            this.setIsPrinted(true);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setTaxAmt(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.setQtyInvoiced(Env.ZERO);
        }
    }

    public MInvoiceLine(MInvoice invoice) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        if (invoice.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setInvoice(invoice);
    }

    public MInvoiceLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setInvoice(MInvoice invoice) {
        this.m_parent = invoice;
        this.m_M_PriceList_ID = invoice.getM_PriceList_ID();
        this.m_DateInvoiced = invoice.getDateInvoiced();
        this.m_C_BPartner_ID = invoice.getC_BPartner_ID();
        this.m_C_BPartner_Location_ID = invoice.getC_BPartner_Location_ID();
        this.m_IsSOTrx = invoice.isSOTrx();
        this.m_precision = new Integer(invoice.getPrecision());
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setIsDescription(oLine.isDescription());
        this.setDescription(oLine.getDescription());
        this.setC_Charge_ID(oLine.getC_Charge_ID());
        this.setM_Product_ID(oLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
        this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        this.setPriceEntered(oLine.getPriceEntered());
        this.setPriceActual(oLine.getPriceActual());
        this.setPriceLimit(oLine.getPriceLimit());
        this.setPriceList(oLine.getPriceList());
        this.setC_Tax_ID(oLine.getC_Tax_ID());
        this.setLineNetAmt(oLine.getLineNetAmt());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
        this.setRRAmt(oLine.getRRAmt());
        this.setRRStartDate(oLine.getRRStartDate());
    }

    public void setShipLine(MInOutLine sLine) {
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        this.setLine(sLine.getLine());
        this.setIsDescription(sLine.isDescription());
        this.setDescription(sLine.getDescription());
        this.setM_Product_ID(sLine.getM_Product_ID());
        this.setC_UOM_ID(sLine.getC_UOM_ID());
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        this.setC_Charge_ID(sLine.getC_Charge_ID());
        int C_OrderLine_ID = sLine.getC_OrderLine_ID();
        if (C_OrderLine_ID != 0) {
            MOrderLine oLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.get_TrxName());
            this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
            this.setPriceEntered(oLine.getPriceEntered());
            this.setPriceActual(oLine.getPriceActual());
            this.setPriceLimit(oLine.getPriceLimit());
            this.setPriceList(oLine.getPriceList());
            this.setC_Tax_ID(oLine.getC_Tax_ID());
            this.setLineNetAmt(oLine.getLineNetAmt());
            this.setC_Project_ID(oLine.getC_Project_ID());
        } else {
            this.setPrice();
            this.setTax();
        }
        this.setC_Project_ID(sLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(sLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(sLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(sLine.getC_Activity_ID());
        this.setC_Campaign_ID(sLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(sLine.getAD_OrgTrx_ID());
        this.setUser1_ID(sLine.getUser1_ID());
        this.setUser2_ID(sLine.getUser2_ID());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", (Object)new Integer(0));
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            this.setInvoice(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            throw new IllegalStateException("setPrice - PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID, this.m_C_BPartner_ID);
    }

    public void setPrice(int M_PriceList_ID, int C_BPartner_ID) {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        this.m_productPricing = new MProductPricing(this.getM_Product_ID(), C_BPartner_ID, this.getQtyInvoiced(), this.m_IsSOTrx);
        this.m_productPricing.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPricing.setPriceDate(this.m_DateInvoiced);
        this.setPriceActual(this.m_productPricing.getPriceStd());
        this.setPriceList(this.m_productPricing.getPriceList());
        this.setPriceLimit(this.m_productPricing.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyInvoiced()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyInvoiced().divide(this.getQtyEntered(), 6, 4)));
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPricing.getC_UOM_ID());
        }
        this.m_priceSet = true;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public boolean setTax() {
        if (this.isDescription()) {
            return true;
        }
        int M_Warehouse_ID = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
        int C_Tax_ID = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.m_DateInvoiced, this.m_DateInvoiced, this.getAD_Org_ID(), M_Warehouse_ID, this.m_C_BPartner_Location_ID, this.m_C_BPartner_Location_ID, this.m_IsSOTrx);
        if (C_Tax_ID == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(C_Tax_ID);
        if (this.m_IsSOTrx) {
            // empty if block
        }
        return true;
    }

    public void setTaxAmt() {
        BigDecimal TaxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        MTax tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        if (tax.isDocumentLevel() && this.m_IsSOTrx) {
            return;
        }
        TaxAmt = tax.calculateTax(this.getLineNetAmt(), this.isTaxIncluded(), this.getPrecision());
        if (this.isTaxIncluded()) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(TaxAmt));
        }
        super.setTaxAmt(TaxAmt);
    }

    public void setLineNetAmt() {
        BigDecimal net = this.getPriceActual().multiply(this.getQtyInvoiced());
        if (net.scale() > this.getPrecision()) {
            net = net.setScale(this.getPrecision(), 4);
        }
        super.setLineNetAmt(net);
    }

    public void setQty(int Qty) {
        this.setQty(new BigDecimal(Qty));
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setQtyInvoiced(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setQtyInvoiced(BigDecimal QtyInvoiced) {
        MProduct product = this.getProduct();
        if (QtyInvoiced != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyInvoiced = QtyInvoiced.setScale(precision, 4);
        }
        super.setQtyInvoiced(QtyInvoiced);
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoiceLine[").append(this.get_ID()).append(",").append(this.getLine()).append(",QtyInvoiced=").append(this.getQtyInvoiced()).append(",LineNetAmt=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.m_name == null) {
            String sql = "SELECT COALESCE (p.Name, c.Name) FROM C_InvoiceLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge C ON (il.C_Charge_ID=c.C_Charge_ID) WHERE C_InvoiceLine_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_InvoiceLine_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (this.m_name == null) {
                    this.m_name = "??";
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getName", e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {}
                pstmt = null;
            }
        }
        return this.m_name;
    }

    public void setName(String tempName) {
        this.m_name = tempName;
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Invoice x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Invoice_ID=?";
        int i2 = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
        if (i2 < 0) {
            this.log.warning("getPrecision = " + i2 + " - set to 2");
            i2 = 2;
        }
        this.m_precision = new Integer(i2);
        return this.m_precision;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM C_Invoice WHERE C_Invoice_ID=?", this.getC_Invoice_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        this.log.fine("New=" + newRecord);
        if (this.getC_Charge_ID() != 0) {
            if (this.getM_Product_ID() != 0) {
                this.setM_Product_ID(0);
            }
        } else if (!this.m_priceSet && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
            this.setPrice();
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_InvoiceLine WHERE C_Invoice_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyInvoiced")) {
            this.setQtyInvoiced(this.getQtyInvoiced());
        }
        this.setLineNetAmt();
        if (this.getTaxAmt().compareTo(Env.ZERO) == 0) {
            this.setTaxAmt();
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        MInvoiceTax tax;
        if (!success) {
            return success;
        }
        if (!newRecord && this.is_ValueChanged("C_Tax_ID") && (tax = MInvoiceTax.get(this, this.getPrecision(), true, this.get_TrxName())) != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (!tax.save(this.get_TrxName())) {
                return true;
            }
        }
        return this.updateHeaderTax();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        String sql;
        int no;
        MInvoiceTax tax = MInvoiceTax.get(this, this.getPrecision(), false, this.get_TrxName());
        if (tax != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (!tax.save(this.get_TrxName())) {
                return false;
            }
        }
        if ((no = DB.executeUpdate(sql = "UPDATE C_Invoice i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Invoice_ID(), this.get_TrxName())) != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdate(sql = this.isTaxIncluded() ? "UPDATE C_Invoice i  SET GrandTotal=TotalLines WHERE C_Invoice_ID=" + this.getC_Invoice_ID() : "UPDATE C_Invoice i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_InvoiceTax it WHERE i.C_Invoice_ID=it.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Invoice_ID(), this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }

    public String allocateLandedCosts() {
        int i2;
        MInOutLine iol;
        if (this.isProcessed()) {
            return "Processed";
        }
        MLandedCost[] lcs = MLandedCost.getLandedCosts(this);
        if (lcs.length == 0) {
            return "";
        }
        String sql = "DELETE C_LandedCostAllocation WHERE C_InvoiceLine_ID=" + this.getC_InvoiceLine_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 0) {
            this.log.info("Deleted #" + no);
        }
        int inserted = 0;
        if (lcs.length == 1) {
            MLandedCost lc = lcs[0];
            if (lc.getM_InOut_ID() != 0) {
                MInOutLine iol2;
                int i3;
                ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                for (int i4 = 0; i4 < lines.length; ++i4) {
                    if (lines[i4].isDescription() || lines[i4].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i4].getM_Product_ID()) continue;
                    list.add(lines[i4]);
                }
                if (list.size() == 0) {
                    return "No Matching Lines (with Product) in Shipment";
                }
                BigDecimal total = Env.ZERO;
                for (i3 = 0; i3 < list.size(); ++i3) {
                    iol2 = (MInOutLine)list.get(i3);
                    total = total.add(iol2.getBase(lc.getLandedCostDistribution()));
                }
                if (total.signum() == 0) {
                    return "Total of Base values is 0 - " + lc.getLandedCostDistribution();
                }
                for (i3 = 0; i3 < list.size(); ++i3) {
                    iol2 = (MInOutLine)list.get(i3);
                    MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                    lca.setM_Product_ID(iol2.getM_Product_ID());
                    lca.setM_AttributeSetInstance_ID(iol2.getM_AttributeSetInstance_ID());
                    BigDecimal base = iol2.getBase(lc.getLandedCostDistribution());
                    lca.setBase(base);
                    if (base.signum() != 0) {
                        double result = this.getLineNetAmt().multiply(base).doubleValue();
                        lca.setAmt(result /= total.doubleValue(), this.getPrecision());
                    }
                    if (!lca.save()) {
                        return "Cannot save line Allocation = " + lca;
                    }
                    ++inserted;
                }
                this.log.info("Inserted " + inserted);
                this.allocateLandedCostRounding();
                return "";
            }
            if (lc.getM_InOutLine_ID() != 0) {
                MInOutLine iol3 = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName());
                if (iol3.isDescription() || iol3.getM_Product_ID() == 0) {
                    return "Invalid Receipt Line - " + iol3;
                }
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(iol3.getM_Product_ID());
                lca.setM_AttributeSetInstance_ID(iol3.getM_AttributeSetInstance_ID());
                lca.setAmt(this.getLineNetAmt());
                if (lca.save()) {
                    return "";
                }
                return "Cannot save single line Allocation = " + lc;
            }
            if (lc.getM_Product_ID() != 0) {
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(lc.getM_Product_ID());
                lca.setAmt(this.getLineNetAmt());
                if (lca.save()) {
                    return "";
                }
                return "Cannot save Product Allocation = " + lc;
            }
            return "No Reference for " + lc;
        }
        String LandedCostDistribution = lcs[0].getLandedCostDistribution();
        int M_CostElement_ID = lcs[0].getM_CostElement_ID();
        for (int i5 = 0; i5 < lcs.length; ++i5) {
            MLandedCost lc = lcs[i5];
            if (!LandedCostDistribution.equals(lc.getLandedCostDistribution())) {
                return "Multiple Landed Cost Rules must have consistent Landed Cost Distribution";
            }
            if (lc.getM_Product_ID() != 0 && lc.getM_InOut_ID() == 0 && lc.getM_InOutLine_ID() == 0) {
                return "Multiple Landed Cost Rules cannot directly allocate to a Product";
            }
            if (M_CostElement_ID == lc.getM_CostElement_ID()) continue;
            return "Multiple Landed Cost Rules cannot different Cost Elements";
        }
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        for (int ii = 0; ii < lcs.length; ++ii) {
            MLandedCost lc = lcs[ii];
            if (lc.getM_InOut_ID() != 0 && lc.getM_InOutLine_ID() == 0) {
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                for (int i6 = 0; i6 < lines.length; ++i6) {
                    if (lines[i6].isDescription() || lines[i6].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i6].getM_Product_ID()) continue;
                    list.add(lines[i6]);
                }
                continue;
            }
            if (lc.getM_InOutLine_ID() == 0 || (iol = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName())).isDescription() || iol.getM_Product_ID() == 0) continue;
            list.add(iol);
        }
        if (list.size() == 0) {
            return "No Matching Lines (with Product)";
        }
        BigDecimal total = Env.ZERO;
        for (i2 = 0; i2 < list.size(); ++i2) {
            iol = (MInOutLine)list.get(i2);
            total = total.add(iol.getBase(LandedCostDistribution));
        }
        if (total.signum() == 0) {
            return "Total of Base values is 0 - " + LandedCostDistribution;
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            iol = (MInOutLine)list.get(i2);
            MLandedCostAllocation lca = new MLandedCostAllocation(this, lcs[0].getM_CostElement_ID());
            lca.setM_Product_ID(iol.getM_Product_ID());
            lca.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            BigDecimal base = iol.getBase(LandedCostDistribution);
            lca.setBase(base);
            if (base.signum() != 0) {
                double result = this.getLineNetAmt().multiply(base).doubleValue();
                lca.setAmt(result /= total.doubleValue(), this.getPrecision());
            }
            if (!lca.save()) {
                return "Cannot save line Allocation = " + lca;
            }
            ++inserted;
        }
        this.log.info("Inserted " + inserted);
        this.allocateLandedCostRounding();
        return "";
    }

    private void allocateLandedCostRounding() {
        MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        MLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        for (int i2 = 0; i2 < allocations.length; ++i2) {
            MLandedCostAllocation allocation = allocations[i2];
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
        }
        BigDecimal difference = this.getLineNetAmt().subtract(allocationAmt);
        if (difference.signum() != 0) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.save();
            this.log.config("Difference=" + difference + ", C_LandedCostAllocation_ID=" + largestAmtAllocation.getC_LandedCostAllocation_ID() + ", Amt" + largestAmtAllocation.getAmt());
        }
    }
}

