/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_InOutLine;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInvoice
extends X_C_Invoice
implements DocAction {
    private static CCache<Integer, MInvoice> s_cache = new CCache("C_Invoice", 20, 2);
    private BigDecimal m_openAmt = null;
    private MInvoiceLine[] m_lines;
    private MInvoiceTax[] m_taxes;
    private static CLogger s_log = CLogger.getCLogger(MInvoice.class);
    private boolean m_reversal = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MInvoice[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        ArrayList<MInvoice> list = new ArrayList<MInvoice>();
        String sql = "SELECT * FROM C_Invoice WHERE C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoice(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MInvoice[] retValue = new MInvoice[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInvoice to = new MInvoice(from.getCtx(), 0, null);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Invoice_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setDateInvoiced(dateDoc);
        to.setDateAcct(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setIsPaid(false);
        to.setIsInDispute(false);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setIsSelfService(false);
        if (!setOrder) {
            to.setC_Order_ID(0);
        }
        if (counter) {
            MOrder peer;
            to.setRef_Invoice_ID(from.getC_Invoice_ID());
            if (from.getC_Order_ID() != 0 && (peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName())).getRef_Order_ID() != 0) {
                to.setC_Order_ID(peer.getRef_Order_ID());
            }
        } else {
            to.setRef_Invoice_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Invoice");
        }
        if (counter) {
            from.setRef_Invoice_ID(to.getC_Invoice_ID());
        }
        if (to.copyLinesFrom(from, counter, setOrder) == 0) {
            throw new IllegalStateException("Could not create Invoice Lines");
        }
        return to;
    }

    public static String getPDFFileName(String documentDir, int C_Invoice_ID) {
        StringBuffer sb = new StringBuffer(documentDir);
        if (sb.length() == 0) {
            sb.append(".");
        }
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("C_Invoice_ID_").append(C_Invoice_ID).append(".pdf");
        return sb.toString();
    }

    public static MInvoice get(Properties ctx, int C_Invoice_ID) {
        Integer key = new Integer(C_Invoice_ID);
        MInvoice retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInvoice(ctx, C_Invoice_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
        if (C_Invoice_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPaymentRule("P");
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
            this.setIsSOTrx(true);
            this.setIsTaxIncluded(false);
            this.setIsApproved(false);
            this.setIsDiscountPrinted(false);
            this.setIsPaid(false);
            this.setSendEMail(false);
            this.setIsPrinted(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            this.setIsPayScheduleValid(false);
            this.setIsInDispute(false);
            this.setPosted(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoice(MOrder order, int C_DocTypeTarget_ID, Timestamp invoiceDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        this.setClientOrg(order);
        this.setOrder(order);
        if (C_DocTypeTarget_ID == 0) {
            C_DocTypeTarget_ID = DB.getSQLValue(null, "SELECT C_DocTypeInvoice_ID FROM C_DocType WHERE C_DocType_ID=?", order.getC_DocType_ID());
        }
        this.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_BPartner_ID(order.getBill_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getBill_Location_ID());
        this.setAD_User_ID(order.getBill_User_ID());
    }

    public MInvoice(MInOut ship, Timestamp invoiceDate) {
        this(ship.getCtx(), 0, ship.get_TrxName());
        this.setClientOrg(ship);
        this.setShipment(ship);
        this.setC_DocTypeTarget_ID();
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(ship.getSalesRep_ID());
        this.setAD_User_ID(ship.getAD_User_ID());
    }

    public MInvoice(MInvoiceBatch batch, MInvoiceBatchLine line) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setDocumentNo(line.getDocumentNo());
        this.setIsSOTrx(batch.isSOTrx());
        MBPartner bp = new MBPartner(line.getCtx(), line.getC_BPartner_ID(), line.get_TrxName());
        this.setBPartner(bp);
        this.setIsTaxIncluded(line.isTaxIncluded());
        this.setC_Currency_ID(batch.getC_Currency_ID());
        this.setC_ConversionType_ID(batch.getC_ConversionType_ID());
        this.setDescription(batch.getDescription());
        this.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
        this.setC_Project_ID(line.getC_Project_ID());
        this.setC_Activity_ID(line.getC_Activity_ID());
        this.setUser1_ID(line.getUser1_ID());
        this.setUser2_ID(line.getUser2_ID());
        this.setC_DocTypeTarget_ID(line.getC_DocType_ID());
        this.setDateInvoiced(line.getDateInvoiced());
        this.setDateAcct(line.getDateAcct());
        this.setSalesRep_ID(batch.getSalesRep_ID());
        this.setC_BPartner_ID(line.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(line.getC_BPartner_Location_ID());
        this.setAD_User_ID(line.getAD_User_ID());
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((locs = bp.getLocations(false)) != null) {
            for (int i2 = 0; i2 < locs.length; ++i2) {
                if ((!locs[i2].isBillTo() || !this.isSOTrx()) && (!locs[i2].isPayFrom() || this.isSOTrx())) continue;
                this.setC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "Has no To Address: " + bp);
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void setOrder(MOrder order) {
        if (order == null) {
            return;
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setIsSOTrx(order.isSOTrx());
        this.setIsDiscountPrinted(order.isDiscountPrinted());
        this.setIsSelfService(order.isSelfService());
        this.setSendEMail(order.isSendEMail());
        this.setM_PriceList_ID(order.getM_PriceList_ID());
        this.setIsTaxIncluded(order.isTaxIncluded());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setC_ConversionType_ID(order.getC_ConversionType_ID());
        this.setPaymentRule(order.getPaymentRule());
        this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
        this.setPOReference(order.getPOReference());
        this.setDescription(order.getDescription());
        this.setDateOrdered(order.getDateOrdered());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
    }

    public void setShipment(MInOut ship) {
        if (ship == null) {
            return;
        }
        this.setIsSOTrx(ship.isSOTrx());
        MBPartner bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), null);
        this.setBPartner(bp);
        this.setSendEMail(ship.isSendEMail());
        this.setPOReference(ship.getPOReference());
        this.setDescription(ship.getDescription());
        this.setDateOrdered(ship.getDateOrdered());
        this.setAD_OrgTrx_ID(ship.getAD_OrgTrx_ID());
        this.setC_Project_ID(ship.getC_Project_ID());
        this.setC_Campaign_ID(ship.getC_Campaign_ID());
        this.setC_Activity_ID(ship.getC_Activity_ID());
        this.setUser1_ID(ship.getUser1_ID());
        this.setUser2_ID(ship.getUser2_ID());
        if (ship.getC_Order_ID() != 0) {
            this.setC_Order_ID(ship.getC_Order_ID());
            MOrder order = new MOrder(this.getCtx(), ship.getC_Order_ID(), this.get_TrxName());
            this.setIsDiscountPrinted(order.isDiscountPrinted());
            this.setM_PriceList_ID(order.getM_PriceList_ID());
            this.setIsTaxIncluded(order.isTaxIncluded());
            this.setC_Currency_ID(order.getC_Currency_ID());
            this.setC_ConversionType_ID(order.getC_ConversionType_ID());
            this.setPaymentRule(order.getPaymentRule());
            this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            MDocType dt = MDocType.get(this.getCtx(), order.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setC_BPartner_Location_ID(order.getBill_Location_ID());
        }
    }

    public void setC_DocTypeTarget_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID(), DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AC_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine(DocBaseType);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            boolean isSOTrx = "ARI".equals(DocBaseType) || "ARC".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID("ARI");
        } else {
            this.setC_DocTypeTarget_ID("API");
        }
    }

    public BigDecimal getGrandTotal(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getGrandTotal();
        }
        BigDecimal amt = this.getGrandTotal();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MInvoiceLine[] getLines(String whereClause) {
        ArrayList<MInvoiceLine> list = new ArrayList<MInvoiceLine>();
        String sql = "SELECT * FROM C_InvoiceLine WHERE C_Invoice_ID=? ";
        if (whereClause != null) {
            sql = sql + whereClause;
        }
        sql = sql + " ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Invoice_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInvoiceLine il = new MInvoiceLine(this.getCtx(), rs, this.get_TrxName());
                il.setInvoice(this);
                list.add(il);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MInvoiceLine[] lines = new MInvoiceLine[list.size()];
        list.toArray(lines);
        return lines;
    }

    public MInvoiceLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        return this.m_lines;
    }

    public MInvoiceLine[] getLines() {
        return this.getLines(false);
    }

    public void renumberLines(int step) {
        int number = step;
        MInvoiceLine[] lines = this.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MInvoiceLine line = lines[i2];
            line.setLine(number);
            line.save();
            number += step;
        }
        this.m_lines = null;
    }

    public int copyLinesFrom(MInvoice otherInvoice, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || otherInvoice == null) {
            return 0;
        }
        MInvoiceLine[] fromLines = otherInvoice.getLines(false);
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MInvoiceLine line = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            MInvoiceLine fromLine = fromLines[i2];
            if (counter) {
                PO.copyValues(fromLine, line, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues(fromLine, line, fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            }
            line.setC_Invoice_ID(this.getC_Invoice_ID());
            line.setInvoice(this);
            line.set_ValueNoCheck("C_InvoiceLine_ID", I_ZERO);
            if (!setOrder) {
                line.setC_OrderLine_ID(0);
            }
            line.setRef_InvoiceLine_ID(0);
            line.setM_InOutLine_ID(0);
            line.setA_Asset_ID(0);
            line.setM_AttributeSetInstance_ID(0);
            line.setS_ResourceAssignment_ID(0);
            if (this.getC_BPartner_ID() != otherInvoice.getC_BPartner_ID()) {
                line.setTax();
            }
            if (counter) {
                PO peer;
                line.setRef_InvoiceLine_ID(fromLine.getC_InvoiceLine_ID());
                if (fromLine.getC_OrderLine_ID() != 0 && ((X_C_OrderLine)(peer = new MOrderLine(this.getCtx(), fromLine.getC_OrderLine_ID(), this.get_TrxName()))).getRef_OrderLine_ID() != 0) {
                    line.setC_OrderLine_ID(((X_C_OrderLine)peer).getRef_OrderLine_ID());
                }
                line.setM_InOutLine_ID(0);
                if (fromLine.getM_InOutLine_ID() != 0 && ((X_M_InOutLine)(peer = new MInOutLine(this.getCtx(), fromLine.getM_InOutLine_ID(), this.get_TrxName()))).getRef_InOutLine_ID() != 0) {
                    line.setM_InOutLine_ID(((X_M_InOutLine)peer).getRef_InOutLine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (!counter) continue;
            fromLine.setRef_InvoiceLine_ID(line.getC_InvoiceLine_ID());
            fromLine.save(this.get_TrxName());
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    private boolean isReversal() {
        return this.m_reversal;
    }

    public MInvoiceTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        String sql = "SELECT * FROM C_InvoiceTax WHERE C_Invoice_ID=?";
        ArrayList<MInvoiceTax> list = new ArrayList<MInvoiceTax>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Invoice_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoiceTax(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getTaxes", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_taxes = new MInvoiceTax[list.size()];
        list.toArray(this.m_taxes);
        return this.m_taxes;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean isCreditMemo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID() == 0 ? this.getC_DocTypeTarget_ID() : this.getC_DocType_ID());
        return "APC".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType());
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Invoice_ID=" + this.getC_Invoice_ID();
        int noLine = DB.executeUpdate("UPDATE C_InvoiceLine " + set, this.get_TrxName());
        int noTax = DB.executeUpdate("UPDATE C_InvoiceTax " + set, this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine(processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    public boolean validatePaySchedule() {
        MInvoicePaySchedule[] schedule = MInvoicePaySchedule.getInvoicePaySchedule(this.getCtx(), this.getC_Invoice_ID(), 0, this.get_TrxName());
        this.log.fine("#" + schedule.length);
        if (schedule.length == 0) {
            this.setIsPayScheduleValid(false);
            return false;
        }
        BigDecimal total = Env.ZERO;
        for (int i2 = 0; i2 < schedule.length; ++i2) {
            schedule[i2].setParent(this);
            BigDecimal due = schedule[i2].getDueAmt();
            if (due == null) continue;
            total = total.add(due);
        }
        boolean valid = this.getGrandTotal().compareTo(total) == 0;
        this.setIsPayScheduleValid(valid);
        for (int i3 = 0; i3 < schedule.length; ++i3) {
            if (schedule[i3].isValid() == valid) continue;
            schedule[i3].setIsValid(valid);
            schedule[i3].save(this.get_TrxName());
        }
        return valid;
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        String sql;
        this.log.fine("");
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getM_PriceList_ID() == 0) {
            int ii2 = Env.getContextAsInt(this.getCtx(), "#M_PriceList_ID");
            if (ii2 != 0) {
                this.setM_PriceList_ID(ii2);
            } else {
                sql = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii2 = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii2 != 0) {
                    this.setM_PriceList_ID(ii2);
                }
            }
        }
        if (this.getC_Currency_ID() == 0) {
            String sql2 = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, sql2, this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(this.isSOTrx() ? "ARI" : "API");
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt(this.getCtx(), "#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.getC_Order_ID() != 0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoice[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",GrandTotal=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            String sql = "UPDATE C_InvoiceLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM C_Invoice o WHERE ol.C_Invoice_ID=o.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Order_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Lines -> #" + no);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setM_PriceList_ID(int M_PriceList_ID) {
        String sql = "SELECT M_PriceList_ID, C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                super.setM_PriceList_ID(rs.getInt(1));
                this.setC_Currency_ID(rs.getInt(2));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "setM_PriceList_ID", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
    }

    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue = null;
        String sql = "SELECT SUM(currencyConvert(al.Amount+al.DiscountAmt+al.WriteOffAmt,ah.C_Currency_ID, i.C_Currency_ID,ah.DateTrx,i.C_ConversionType_ID, al.AD_Client_ID,al.AD_Org_ID)) FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID) INNER JOIN C_Invoice i ON (al.C_Invoice_ID=i.C_Invoice_ID) WHERE al.C_Invoice_ID=? AND ah.IsActive='Y' AND al.IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Invoice_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public boolean testAllocation() {
        boolean change;
        BigDecimal alloc = this.getAllocatedAmt();
        if (alloc == null) {
            alloc = Env.ZERO;
        }
        BigDecimal total = this.getGrandTotal();
        if (!this.isSOTrx()) {
            total = total.negate();
        }
        if (this.isCreditMemo()) {
            total = total.negate();
        }
        boolean test = total.compareTo(alloc) == 0;
        boolean bl = change = test != this.isPaid();
        if (change) {
            this.setIsPaid(test);
        }
        this.log.fine("Paid=" + test + " (" + alloc + "=" + total + ")");
        return change;
    }

    public static void setIsPaid(Properties ctx, int C_BPartner_ID, String trxName) {
        int counter = 0;
        String sql = "SELECT * FROM C_Invoice WHERE IsPaid='N' AND DocStatus IN ('CO','CL')";
        sql = C_BPartner_ID > 1 ? sql + " AND C_BPartner_ID=?" : sql + " AND AD_Client_ID=" + Env.getAD_Client_ID(ctx);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            if (C_BPartner_ID > 1) {
                pstmt.setInt(1, C_BPartner_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInvoice invoice = new MInvoice(ctx, rs, trxName);
                if (!invoice.testAllocation() || !invoice.save()) continue;
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.config("#" + counter);
    }

    public BigDecimal getOpenAmt() {
        return this.getOpenAmt(true, null);
    }

    public BigDecimal getOpenAmt(boolean creditMemoAdjusted, Timestamp paymentDate) {
        if (this.isPaid()) {
            return Env.ZERO;
        }
        if (this.m_openAmt == null) {
            BigDecimal allocated;
            this.m_openAmt = this.getGrandTotal();
            if (paymentDate != null) {
                // empty if block
            }
            if ((allocated = this.getAllocatedAmt()) != null) {
                allocated = allocated.abs();
                this.m_openAmt = this.m_openAmt.subtract(allocated);
            }
        }
        if (!creditMemoAdjusted) {
            return this.m_openAmt;
        }
        if (this.isCreditMemo()) {
            return this.m_openAmt.negate();
        }
        return this.m_openAmt;
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 2, this.getC_Invoice_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getPDFFileName(String documentDir) {
        return MInvoice.getPDFFileName(documentDir, this.getC_Invoice_ID());
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MBPartner bp;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocTypeTarget_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MInvoiceLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if ("B".equals(this.getPaymentRule()) && MCashBook.get(this.getCtx(), this.getAD_Org_ID(), this.getC_Currency_ID()) == null) {
            this.m_processMsg = "@NoCashBook@";
            return "IN";
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (this.getC_DocType_ID() == 0) {
            this.m_processMsg = "No Document Type";
            return "IN";
        }
        this.explodeBOM();
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating Tax";
            return "IN";
        }
        this.createPaySchedule();
        if (this.isSOTrx() && !this.isReversal() && "S".equals((bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null)).getSOCreditStatus())) {
            this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
            return "IN";
        }
        if (!this.isSOTrx()) {
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MInvoiceLine line = lines[i2];
                String error = line.allocateLandedCosts();
                if (error == null || error.length() <= 0) continue;
                this.m_processMsg = error;
                return "IN";
            }
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void explodeBOM() {
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_InvoiceLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? " + where;
        int count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
        while (count != 0) {
            this.renumberLines(100);
            MInvoiceLine[] lines = this.getLines(where);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MInvoiceLine line = lines[i2];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MProductBOM[] boms = MProductBOM.getBOMLines(product);
                for (int j = 0; j < boms.length; ++j) {
                    MProductBOM bom = boms[j];
                    MInvoiceLine newLine = new MInvoiceLine(this);
                    newLine.setLine(++lineNo);
                    newLine.setM_Product_ID(bom.getProduct().getM_Product_ID(), bom.getProduct().getC_UOM_ID());
                    newLine.setQty(line.getQtyInvoiced().multiply(bom.getBOMQty()));
                    if (bom.getDescription() != null) {
                        newLine.setDescription(bom.getDescription());
                    }
                    newLine.setPrice();
                    newLine.save(this.get_TrxName());
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPriceEntered(Env.ZERO);
                line.setPriceActual(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = description + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = description + " " + line.getDescription();
                }
                line.setDescription(description);
                line.save(this.get_TrxName());
            }
            this.m_lines = null;
            count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.renumberLines(10);
        }
    }

    private boolean calculateTaxTotal() {
        MInvoiceTax iTax;
        this.log.fine("");
        DB.executeUpdate("DELETE C_InvoiceTax WHERE C_Invoice_ID=" + this.getC_Invoice_ID(), this.get_TrxName());
        this.m_taxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MInvoiceLine[] lines = this.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MInvoiceLine line = lines[i2];
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID) && (iTax = MInvoiceTax.get(line, this.getPrecision(), false, this.get_TrxName())) != null) {
                iTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!iTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!iTax.save()) {
                    return false;
                }
                taxList.add(taxID);
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        BigDecimal grandTotal = totalLines;
        MInvoiceTax[] taxes = this.getTaxes(true);
        for (int i3 = 0; i3 < taxes.length; ++i3) {
            iTax = taxes[i3];
            MTax tax = iTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                for (int j = 0; j < cTaxes.length; ++j) {
                    MTax cTax = cTaxes[j];
                    BigDecimal taxAmt = cTax.calculateTax(iTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MInvoiceTax newITax = new MInvoiceTax(this.getCtx(), 0, this.get_TrxName());
                    newITax.setClientOrg(this);
                    newITax.setC_Invoice_ID(this.getC_Invoice_ID());
                    newITax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newITax.setPrecision(this.getPrecision());
                    newITax.setIsTaxIncluded(this.isTaxIncluded());
                    newITax.setTaxBaseAmt(iTax.getTaxBaseAmt());
                    newITax.setTaxAmt(taxAmt);
                    if (!newITax.save(this.get_TrxName())) {
                        return false;
                    }
                    if (this.isTaxIncluded()) continue;
                    grandTotal = grandTotal.add(taxAmt);
                }
                if (iTax.delete(true, this.get_TrxName())) continue;
                return false;
            }
            if (this.isTaxIncluded()) continue;
            grandTotal = grandTotal.add(iTax.getTaxAmt());
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    private boolean createPaySchedule() {
        if (this.getC_PaymentTerm_ID() == 0) {
            return false;
        }
        MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), null);
        this.log.fine(pt.toString());
        return pt.apply(this);
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        if ("B".equals(this.getPaymentRule())) {
            MCash cash = MCash.get(this.getCtx(), this.getAD_Org_ID(), this.getDateInvoiced(), this.getC_Currency_ID(), this.get_TrxName());
            if (cash == null || cash.get_ID() == 0) {
                this.m_processMsg = "@NoCashBook@";
                return "IN";
            }
            MCashLine cl = new MCashLine(cash);
            cl.setInvoice(this);
            if (!cl.save(this.get_TrxName())) {
                this.m_processMsg = "Could not save Cash Journal Line";
                return "IN";
            }
            info.append("@C_Cash_ID@: " + cash.getName() + " #" + cl.getLine());
            this.setC_CashLine_ID(cl.getC_CashLine_ID());
        }
        int matchInv = 0;
        int matchPO = 0;
        MInvoiceLine[] lines = this.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            BigDecimal matchQty;
            MInvoiceLine line = lines[i2];
            MOrderLine ol = null;
            if (line.getC_OrderLine_ID() != 0) {
                if (this.isSOTrx() || line.getM_Product_ID() == 0) {
                    ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                    if (line.getQtyInvoiced() != null) {
                        ol.setQtyInvoiced(ol.getQtyInvoiced().add(line.getQtyInvoiced()));
                    }
                    if (!ol.save(this.get_TrxName())) {
                        this.m_processMsg = "Could not update Order Line";
                        return "IN";
                    }
                } else if (!this.isSOTrx() && line.getM_Product_ID() != 0 && !this.isReversal()) {
                    matchQty = line.getQtyInvoiced();
                    MMatchPO po = MMatchPO.create(line, null, this.getDateInvoiced(), matchQty);
                    if (!po.save(this.get_TrxName())) {
                        this.m_processMsg = "Could not create PO Matching";
                        return "IN";
                    }
                    ++matchPO;
                }
            }
            if (this.isSOTrx() || line.getM_InOutLine_ID() == 0 || line.getM_Product_ID() == 0 || this.isReversal()) continue;
            matchQty = line.getQtyInvoiced();
            MMatchInv inv = new MMatchInv(line, this.getDateInvoiced(), matchQty);
            if (!inv.save(this.get_TrxName())) {
                this.m_processMsg = "Could not create Invoice Matching";
                return "IN";
            }
            ++matchInv;
        }
        if (matchInv > 0) {
            info.append(" @M_MatchInv_ID@#").append(matchInv).append(" ");
        }
        if (matchPO > 0) {
            info.append(" @M_MatchPO_ID@#").append(matchPO).append(" ");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        BigDecimal invAmt = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(true), this.getC_Currency_ID(), this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID());
        if (invAmt == null) {
            this.m_processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to base C_Currency_ID=" + MClient.get(Env.getCtx()).getC_Currency_ID();
            return "IN";
        }
        BigDecimal newBalance = bp.getTotalOpenBalance(false);
        if (newBalance == null) {
            newBalance = Env.ZERO;
        }
        if (this.isSOTrx()) {
            BigDecimal newLifeAmt;
            newBalance = newBalance.add(invAmt);
            if (bp.getFirstSale() == null) {
                bp.setFirstSale(this.getDateInvoiced());
            }
            newLifeAmt = (newLifeAmt = bp.getActualLifeTimeValue()) == null ? invAmt : newLifeAmt.add(invAmt);
            BigDecimal newCreditAmt = bp.getSO_CreditUsed();
            newCreditAmt = newCreditAmt == null ? invAmt : newCreditAmt.add(invAmt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") BP Life=" + bp.getActualLifeTimeValue() + "->" + newLifeAmt + ", Credit=" + bp.getSO_CreditUsed() + "->" + newCreditAmt + ", Balance=" + bp.getTotalOpenBalance(false) + " -> " + newBalance);
            bp.setActualLifeTimeValue(newLifeAmt);
            bp.setSO_CreditUsed(newCreditAmt);
        } else {
            newBalance = newBalance.subtract(invAmt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") Balance=" + bp.getTotalOpenBalance(false) + " -> " + newBalance);
        }
        bp.setTotalOpenBalance(newBalance);
        bp.setSOCreditStatus();
        if (!bp.save(this.get_TrxName())) {
            this.m_processMsg = "Could not update Business Partner";
            return "IN";
        }
        if (this.getAD_User_ID() != 0) {
            MUser user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
            user.setLastContact(new Timestamp(System.currentTimeMillis()));
            user.setLastResult(Msg.translate(this.getCtx(), "C_Invoice_ID") + ": " + this.getDocumentNo());
            if (!user.save(this.get_TrxName())) {
                this.m_processMsg = "Could not update Business Partner User";
                return "IN";
            }
        }
        if (this.isSOTrx() && this.getC_Project_ID() != 0) {
            MProject project = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
            BigDecimal amt = this.getGrandTotal(true);
            int C_CurrencyTo_ID = project.getC_Currency_ID();
            if (C_CurrencyTo_ID != this.getC_Currency_ID()) {
                amt = MConversionRate.convert(this.getCtx(), amt, this.getC_Currency_ID(), C_CurrencyTo_ID, this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID());
            }
            if (amt == null) {
                this.m_processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to Project C_Currency_ID=" + C_CurrencyTo_ID;
                return "IN";
            }
            BigDecimal newAmt = project.getInvoicedAmt();
            newAmt = newAmt == null ? amt : newAmt.add(amt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + amt + ") Project " + project.getName() + " - Invoiced=" + project.getInvoicedAmt() + "->" + newAmt);
            project.setInvoicedAmt(newAmt);
            if (!project.save(this.get_TrxName())) {
                this.m_processMsg = "Could not update Project";
                return "IN";
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        MInvoice counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @C_Invoice_ID@=").append(counter.getDocumentNo());
        }
        this.m_processMsg = info.toString().trim();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private MInvoice createCounterDoc() {
        if (this.getRef_Invoice_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID();
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null);
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, null);
        MOrgInfo counterOrgInfo = MOrgInfo.get(this.getCtx(), counterAD_Org_ID);
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInvoice counter = MInvoice.copyFrom(this, this.getDateInvoiced(), C_DocTypeTarget_ID, !this.isSOTrx(), true, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setBPartner(counterBP);
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        MInvoiceLine[] counterLines = counter.getLines(true);
        for (int i2 = 0; i2 < counterLines.length; ++i2) {
            MInvoiceLine counterLine = counterLines[i2];
            counterLine.setClientOrg(counter);
            counterLine.setInvoice(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.save(this.get_TrxName());
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInvoiceLine[] lines = this.getLines(false);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MInvoiceLine line = lines[i2];
                BigDecimal old = line.getQtyInvoiced();
                if (old.compareTo(Env.ZERO) == 0) continue;
                line.setQty(Env.ZERO);
                line.setTaxAmt(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setLineTotalAmt(Env.ZERO);
                line.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + old + ")");
                if (line.getM_InOutLine_ID() != 0) {
                    MInOutLine ioLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                    ioLine.setIsInvoiced(false);
                    ioLine.save(this.get_TrxName());
                    line.setM_InOutLine_ID(0);
                }
                line.save(this.get_TrxName());
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setIsPaid(true);
        this.setC_Payment_ID(0);
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        int i2;
        this.log.info(this.toString());
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return false;
        }
        MAllocationHdr[] allocations = MAllocationHdr.getOfInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        for (int i3 = 0; i3 < allocations.length; ++i3) {
            allocations[i3].setDocAction("RC");
            allocations[i3].reverseCorrectIt();
            allocations[i3].save(this.get_TrxName());
        }
        if (!this.isSOTrx()) {
            MMatchInv[] mInv = MMatchInv.getInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            for (int i4 = 0; i4 < mInv.length; ++i4) {
                mInv[i4].delete(true);
            }
            MMatchPO[] mPO = MMatchPO.getInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            for (i2 = 0; i2 < mPO.length; ++i2) {
                if (mPO[i2].getM_InOutLine_ID() == 0) {
                    mPO[i2].delete(true);
                    continue;
                }
                mPO[i2].setC_InvoiceLine_ID(null);
                mPO[i2].save(this.get_TrxName());
            }
        }
        this.load(this.get_TrxName());
        MInvoice reversal = MInvoice.copyFrom(this, this.getDateInvoiced(), this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true);
        if (reversal == null) {
            this.m_processMsg = "Could not create Invoice Reversal";
            return false;
        }
        reversal.setReversal(true);
        MInvoiceLine[] rLines = reversal.getLines(false);
        for (i2 = 0; i2 < rLines.length; ++i2) {
            MInvoiceLine rLine = rLines[i2];
            rLine.setQtyEntered(rLine.getQtyEntered().negate());
            rLine.setQtyInvoiced(rLine.getQtyInvoiced().negate());
            rLine.setLineNetAmt(rLine.getLineNetAmt().negate());
            if (rLine.getTaxAmt() != null && rLine.getTaxAmt().compareTo(Env.ZERO) != 0) {
                rLine.setTaxAmt(rLine.getTaxAmt().negate());
            }
            if (rLine.getLineTotalAmt() != null && rLine.getLineTotalAmt().compareTo(Env.ZERO) != 0) {
                rLine.setLineTotalAmt(rLine.getLineTotalAmt().negate());
            }
            if (rLine.save(this.get_TrxName())) continue;
            this.m_processMsg = "Could not correct Invoice Reversal Line";
            return false;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.setC_Payment_ID(0);
        reversal.setIsPaid(true);
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.save(this.get_TrxName());
        this.m_processMsg = reversal.getDocumentNo();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        MInvoiceLine[] iLines = this.getLines(false);
        for (int i5 = 0; i5 < iLines.length; ++i5) {
            MInvoiceLine iLine = iLines[i5];
            if (iLine.getM_InOutLine_ID() == 0) continue;
            MInOutLine ioLine = new MInOutLine(this.getCtx(), iLine.getM_InOutLine_ID(), this.get_TrxName());
            ioLine.setIsInvoiced(false);
            ioLine.save(this.get_TrxName());
            iLine.setM_InOutLine_ID(0);
            iLine.save(this.get_TrxName());
        }
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setC_Payment_ID(0);
        this.setIsPaid(true);
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateAcct(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Invoice_ID") + ": " + this.getDocumentNo() + "/" + reversal.getDocumentNo(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        if (alloc.save()) {
            BigDecimal gt = this.getGrandTotal(true);
            if (!this.isSOTrx()) {
                gt = gt.negate();
            }
            MAllocationLine aLine = new MAllocationLine(alloc, gt, Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_Invoice_ID(this.getC_Invoice_ID());
            aLine.save();
            MAllocationLine rLine = new MAllocationLine(alloc, gt.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
            rLine.setC_Invoice_ID(reversal.getC_Invoice_ID());
            rLine.save();
            if (alloc.processIt("CO")) {
                alloc.save();
            }
        }
        return true;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "GrandTotal")).append("=").append(this.getGrandTotal()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }
}

