/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.X_M_InventoryLine;
import org.compiere.model.X_M_InventoryLineMA;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventoryLine
extends X_M_InventoryLine {
    private static CLogger s_log = CLogger.getCLogger(MInventoryLine.class);
    private boolean m_isManualEntry = true;
    private MInventory m_parent = null;
    private MProduct m_product = null;

    public static MInventoryLine get(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        MInventoryLine retValue = null;
        String sql = "SELECT * FROM M_InventoryLine WHERE M_Inventory_ID=? AND M_Locator_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, inventory.get_TrxName());
            pstmt.setInt(1, inventory.getM_Inventory_ID());
            pstmt.setInt(2, M_Locator_ID);
            pstmt.setInt(3, M_Product_ID);
            pstmt.setInt(4, M_AttributeSetInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MInventoryLine(inventory.getCtx(), rs, inventory.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MInventoryLine(Properties ctx, int M_InventoryLine_ID, String trxName) {
        super(ctx, M_InventoryLine_ID, trxName);
        if (M_InventoryLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setInventoryType("D");
            this.setQtyBook(Env.ZERO);
            this.setQtyCount(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInventoryLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventoryLine(MInventory inventory, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal QtyBook, BigDecimal QtyCount) {
        this(inventory.getCtx(), 0, inventory.get_TrxName());
        if (inventory.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.m_parent = inventory;
        this.setM_Inventory_ID(inventory.getM_Inventory_ID());
        this.setClientOrg(inventory.getAD_Client_ID(), inventory.getAD_Org_ID());
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        if (QtyBook != null) {
            this.setQtyBook(QtyBook);
        }
        if (QtyCount != null && QtyCount.signum() != 0) {
            this.setQtyCount(QtyCount);
        }
        this.m_isManualEntry = false;
    }

    public BigDecimal getQtyBook() {
        BigDecimal bd = super.getQtyBook();
        if (bd == null) {
            bd = Env.ZERO;
        }
        return bd;
    }

    public BigDecimal getQtyCount() {
        BigDecimal bd = super.getQtyCount();
        if (bd == null) {
            bd = Env.ZERO;
        }
        return bd;
    }

    public MProduct getProduct() {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return null;
        }
        if (this.m_product != null && this.m_product.getM_Product_ID() != M_Product_ID) {
            this.m_product = null;
        }
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), M_Product_ID);
        }
        return this.m_product;
    }

    public void setQtyCount(BigDecimal QtyCount) {
        MProduct product;
        if (QtyCount != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyCount = QtyCount.setScale(precision, 4);
        }
        super.setQtyCount(QtyCount);
    }

    public void setQtyInternalUse(BigDecimal QtyInternalUse) {
        MProduct product;
        if (QtyInternalUse != null && (product = this.getProduct()) != null) {
            int precision = product.getUOMPrecision();
            QtyInternalUse = QtyInternalUse.setScale(precision, 4);
        }
        super.setQtyInternalUse(QtyInternalUse);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    protected void setParent(MInventory parent) {
        this.m_parent = parent;
    }

    public MInventory getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInventory(this.getCtx(), this.getM_Inventory_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInventoryLine[");
        sb.append(this.get_ID()).append("-M_Product_ID=").append(this.getM_Product_ID()).append(",QtyCount=").append(this.getQtyCount()).append(",QtyInternalUse=").append(this.getQtyInternalUse()).append(",QtyBook=").append(this.getQtyBook()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        MAttributeSet mas;
        MProduct product;
        if (newRecord && this.m_isManualEntry && this.getM_AttributeSetInstance_ID() == 0 && (product = MProduct.get(this.getCtx(), this.getM_Product_ID())).getM_AttributeSet_ID() != 0 && (mas = MAttributeSet.get(this.getCtx(), product.getM_AttributeSet_ID())).isInstanceAttribute() && (mas.isMandatory() || mas.isMandatoryAlways())) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_AttributeSetInstance_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM M_InventoryLine WHERE M_Inventory_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_Inventory_ID());
            this.setLine(ii);
        }
        if (newRecord || this.is_ValueChanged("QtyCount")) {
            this.setQtyCount(this.getQtyCount());
        }
        if (newRecord || this.is_ValueChanged("QtyInternalUse")) {
            this.setQtyInternalUse(this.getQtyInternalUse());
        }
        if (this.getQtyInternalUse().signum() != 0) {
            if (!"C".equals(this.getInventoryType())) {
                this.setInventoryType("C");
            }
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("InternalUseNeedsCharge", "");
                return false;
            }
        } else if ("C".equals(this.getInventoryType())) {
            if (this.getC_Charge_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Charge_ID"));
                return false;
            }
        } else if (this.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(0);
        }
        if (this.getC_Charge_ID() == 0) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success && this.m_isManualEntry && this.getM_AttributeSetInstance_ID() == 0) {
            this.createMA();
        }
        return true;
    }

    private void createMA() {
        MStorage[] storages = MStorage.getAll(this.getCtx(), this.getM_Product_ID(), this.getM_Locator_ID(), this.get_TrxName());
        boolean allZeroASI = true;
        for (int i2 = 0; i2 < storages.length; ++i2) {
            if (storages[i2].getM_AttributeSetInstance_ID() == 0) continue;
            allZeroASI = false;
            break;
        }
        if (allZeroASI) {
            return;
        }
        X_M_InventoryLineMA ma = null;
        BigDecimal sum = Env.ZERO;
        for (int i3 = 0; i3 < storages.length; ++i3) {
            MStorage storage = storages[i3];
            if (storage.getQtyOnHand().signum() == 0) continue;
            if (ma != null && ma.getM_AttributeSetInstance_ID() == storage.getM_AttributeSetInstance_ID()) {
                ma.setMovementQty(ma.getMovementQty().add(storage.getQtyOnHand()));
            } else {
                ma = new MInventoryLineMA(this, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
            }
            if (!ma.save()) {
                // empty if block
            }
            sum = sum.add(storage.getQtyOnHand());
        }
        if (sum.compareTo(this.getQtyBook()) != 0) {
            this.log.warning("QtyBook=" + this.getQtyBook() + " corrected to Sum of MA=" + sum);
            this.setQtyBook(sum);
        }
    }
}

