/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_M_Inventory;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventory
extends X_M_Inventory
implements DocAction {
    private static CCache<Integer, MInventory> s_cache = new CCache("M_Inventory", 5, 5);
    private MInventoryLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MInventory get(Properties ctx, int M_Inventory_ID) {
        Integer key = new Integer(M_Inventory_ID);
        MInventory retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInventory(ctx, M_Inventory_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MInventory(Properties ctx, int M_Inventory_ID, String trxName) {
        super(ctx, M_Inventory_ID, trxName);
        if (M_Inventory_ID == 0) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MInventory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventory(MWarehouse wh) {
        this(wh.getCtx(), 0, wh.get_TrxName());
        this.setClientOrg(wh);
        this.setM_Warehouse_ID(wh.getM_Warehouse_ID());
    }

    public MInventoryLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MInventoryLine> list = new ArrayList<MInventoryLine>();
        String sql = "SELECT * FROM M_InventoryLine WHERE M_Inventory_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_Inventory_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInventoryLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MInventoryLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInventory[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",M_Warehouse_ID=").append(this.getM_Warehouse_ID()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] types = MDocType.getOfDocBaseType(this.getCtx(), "MMI");
            if (types.length > 0) {
                this.setC_DocType_ID(types[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_InventoryLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE M_Inventory_ID=" + this.getM_Inventory_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine("Processed=" + processed + " - Lines=" + noLine);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), "MMI")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MInventoryLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MInventoryLine[] lines = this.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            BigDecimal qtyDiff;
            BigDecimal qtyNew;
            MInventoryLine line = lines[i2];
            if (!line.isActive()) continue;
            MTransaction trx = null;
            if (line.getM_AttributeSetInstance_ID() == 0) {
                BigDecimal qtyDiff2 = line.getQtyInternalUse().negate();
                if (qtyDiff2.signum() == 0) {
                    qtyDiff2 = line.getQtyCount().subtract(line.getQtyBook());
                }
                if (qtyDiff2.signum() > 0) {
                    MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), 0, this.get_TrxName());
                    if (storage == null) {
                        storage = MStorage.getCreate(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), 0, this.get_TrxName());
                    }
                    qtyNew = storage.getQtyOnHand().add(qtyDiff2);
                    this.log.fine("Diff=" + qtyDiff2 + " - OnHand=" + storage.getQtyOnHand() + "->" + qtyNew);
                    storage.setQtyOnHand(qtyNew);
                    storage.setDateLastInventory(this.getMovementDate());
                    if (!storage.save(this.get_TrxName())) {
                        this.m_processMsg = "Storage not updated(1)";
                        return "IN";
                    }
                    this.log.fine(storage.toString());
                    trx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "I+", line.getM_Locator_ID(), line.getM_Product_ID(), 0, qtyDiff2, this.getMovementDate(), this.get_TrxName());
                    trx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                    if (!trx.save()) {
                        this.m_processMsg = "Transaction not inserted(1)";
                        return "IN";
                    }
                } else {
                    MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), line.getM_InventoryLine_ID(), this.get_TrxName());
                    for (int j = 0; j < mas.length; ++j) {
                        BigDecimal maxDiff;
                        MInventoryLineMA ma = mas[j];
                        MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                        if (storage == null) {
                            storage = MStorage.getCreate(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                        }
                        if ((maxDiff = qtyDiff2).signum() < 0 && ma.getMovementQty().compareTo(maxDiff.negate()) < 0) {
                            maxDiff = ma.getMovementQty().negate();
                        }
                        BigDecimal qtyNew2 = ma.getMovementQty().add(maxDiff);
                        this.log.fine("MA Qty=" + ma.getMovementQty() + ",Diff=" + qtyDiff2 + "|" + maxDiff + " - OnHand=" + storage.getQtyOnHand() + "->" + qtyNew2 + " {" + ma.getM_AttributeSetInstance_ID() + "}");
                        storage.setQtyOnHand(qtyNew2);
                        storage.setDateLastInventory(this.getMovementDate());
                        if (!storage.save(this.get_TrxName())) {
                            this.m_processMsg = "Storage not updated (MA)";
                            return "IN";
                        }
                        this.log.fine(storage.toString());
                        trx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "I+", line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), maxDiff, this.getMovementDate(), this.get_TrxName());
                        trx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                        if (!trx.save()) {
                            this.m_processMsg = "Transaction not inserted (MA)";
                            return "IN";
                        }
                        if ((qtyDiff2 = qtyDiff2.subtract(maxDiff)).signum() == 0) break;
                    }
                }
            }
            if (trx != null) continue;
            MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
            if (storage == null) {
                storage = MStorage.getCreate(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
            }
            if (Env.ZERO.compareTo(qtyDiff = line.getQtyInternalUse().negate()) == 0) {
                qtyDiff = line.getQtyCount().subtract(line.getQtyBook());
            }
            qtyNew = storage.getQtyOnHand().add(qtyDiff);
            this.log.fine("Count=" + line.getQtyCount() + ",Book=" + line.getQtyBook() + ", Difference=" + qtyDiff + " - OnHand=" + storage.getQtyOnHand() + "->" + qtyNew);
            storage.setQtyOnHand(qtyNew);
            storage.setDateLastInventory(this.getMovementDate());
            if (!storage.save(this.get_TrxName())) {
                this.m_processMsg = "Storage not updated(2)";
                return "IN";
            }
            this.log.fine(storage.toString());
            trx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "I+", line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), qtyDiff, this.getMovementDate(), this.get_TrxName());
            trx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
            if (trx.save()) continue;
            this.m_processMsg = "Transaction not inserted(2)";
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void checkMaterialPolicy() {
        int no = MInventoryLineMA.deleteInventoryMA(this.getM_Inventory_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        MInventoryLine[] lines = this.getLines(false);
        MClient client = MClient.get(this.getCtx());
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MInventoryLine line = lines[i2];
            boolean needSave = false;
            if (line.getM_AttributeSetInstance_ID() == 0) {
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                BigDecimal qtyDiff = line.getQtyInternalUse().negate();
                if (Env.ZERO.compareTo(qtyDiff) == 0) {
                    qtyDiff = line.getQtyCount().subtract(line.getQtyBook());
                }
                this.log.fine("Count=" + line.getQtyCount() + ",Book=" + line.getQtyBook() + ", Difference=" + qtyDiff);
                if (qtyDiff.signum() > 0) {
                    MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), 0, this.get_TrxName());
                    asi.setClientOrg(this.getAD_Client_ID(), 0);
                    asi.setM_AttributeSet_ID(product.getM_AttributeSet_ID());
                    if (asi.save()) {
                        line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                        needSave = true;
                    }
                } else {
                    MProductCategory pc = MProductCategory.get(this.getCtx(), product.getM_Product_Category_ID());
                    String MMPolicy = pc.getMMPolicy();
                    if (MMPolicy == null || MMPolicy.length() == 0) {
                        MMPolicy = client.getMMPolicy();
                    }
                    MStorage[] storages = MStorage.getAllWithASI(this.getCtx(), line.getM_Product_ID(), line.getM_Locator_ID(), "F".equals(MMPolicy), this.get_TrxName());
                    BigDecimal qtyToDeliver = qtyDiff.negate();
                    for (int ii = 0; ii < storages.length; ++ii) {
                        MInventoryLineMA ma;
                        MStorage storage = storages[ii];
                        if (ii == 0) {
                            if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                                line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                                needSave = true;
                                this.log.config("Direct - " + line);
                                qtyToDeliver = Env.ZERO;
                            } else {
                                this.log.config("Split - " + line);
                                ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand().negate());
                                if (!ma.save()) {
                                    // empty if block
                                }
                                qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                                this.log.fine("#" + ii + ": " + ma + ", QtyToDeliver=" + qtyToDeliver);
                            }
                        } else {
                            ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver.negate());
                            if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                                qtyToDeliver = Env.ZERO;
                            } else {
                                ma.setMovementQty(storage.getQtyOnHand().negate());
                                qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                            }
                            if (!ma.save()) {
                                // empty if block
                            }
                            this.log.fine("#" + ii + ": " + ma + ", QtyToDeliver=" + qtyToDeliver);
                        }
                        if (qtyToDeliver.signum() == 0) break;
                    }
                    if (qtyToDeliver.signum() != 0) {
                        MInventoryLineMA ma = new MInventoryLineMA(line, 0, qtyToDeliver.negate());
                        if (!ma.save()) {
                            // empty if block
                        }
                        this.log.fine("##: " + ma);
                    }
                }
            }
            if (!needSave || line.save()) continue;
            this.log.severe("NOT saved " + line);
        }
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInventoryLine[] lines = this.getLines(false);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MInventoryLine line = lines[i2];
                BigDecimal oldCount = line.getQtyCount();
                BigDecimal oldInternal = line.getQtyInternalUse();
                if (oldCount.compareTo(line.getQtyBook()) == 0 && oldInternal.signum() == 0) continue;
                line.setQtyInternalUse(Env.ZERO);
                line.setQtyCount(line.getQtyBook());
                line.addDescription("Void (" + oldCount + "/" + oldInternal + ")");
                line.save(this.get_TrxName());
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return false;
        }
        MInventory reversal = new MInventory(this.getCtx(), 0, this.get_TrxName());
        MInventory.copyValues(this, reversal, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        if (!reversal.save()) {
            this.m_processMsg = "Could not create Inventory Reversal";
            return false;
        }
        MInventoryLine[] oLines = this.getLines(true);
        for (int i2 = 0; i2 < oLines.length; ++i2) {
            MInventoryLine oLine = oLines[i2];
            MInventoryLine rLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
            MInventory.copyValues(oLine, rLine, oLine.getAD_Client_ID(), oLine.getAD_Org_ID());
            rLine.setM_Inventory_ID(reversal.getM_Inventory_ID());
            rLine.setParent(reversal);
            rLine.setQtyBook(oLine.getQtyCount());
            rLine.setQtyCount(oLine.getQtyBook());
            rLine.setQtyInternalUse(oLine.getQtyInternalUse().negate());
            if (rLine.save()) continue;
            this.m_processMsg = "Could not create Inventory Reversal Line";
            return false;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.save();
        this.m_processMsg = reversal.getDocumentNo();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    public int getC_Currency_ID() {
        return 0;
    }
}

