/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.X_M_InOutLineConfirm;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInOutLineConfirm
extends X_M_InOutLineConfirm {
    private MInOutLine m_line = null;

    public MInOutLineConfirm(Properties ctx, int M_InOutLineConfirm_ID, String trxName) {
        super(ctx, M_InOutLineConfirm_ID, trxName);
        if (M_InOutLineConfirm_ID == 0) {
            this.setDifferenceQty(Env.ZERO);
            this.setScrappedQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInOutLineConfirm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLineConfirm(MInOutConfirm header) {
        this(header.getCtx(), 0, header.get_TrxName());
        this.setClientOrg(header);
        this.setM_InOutConfirm_ID(header.getM_InOutConfirm_ID());
    }

    public void setInOutLine(MInOutLine line) {
        this.setM_InOutLine_ID(line.getM_InOutLine_ID());
        this.setTargetQty(line.getMovementQty());
        this.setConfirmedQty(this.getTargetQty());
        this.m_line = line;
    }

    public MInOutLine getLine() {
        if (this.m_line == null) {
            this.m_line = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
        }
        return this.m_line;
    }

    public boolean processLine(boolean isSOTrx, String confirmType) {
        MInOutLine line = this.getLine();
        if ("XC".equals(confirmType)) {
            line.setConfirmedQty(this.getConfirmedQty());
        } else if (!"DS".equals(confirmType)) {
            if ("PC".equals(confirmType)) {
                line.setTargetQty(this.getTargetQty());
                line.setMovementQty(this.getConfirmedQty());
                line.setPickedQty(this.getConfirmedQty());
                line.setScrappedQty(this.getScrappedQty());
            } else if ("SC".equals(confirmType)) {
                line.setTargetQty(this.getTargetQty());
                BigDecimal qty = this.getConfirmedQty();
                if (!isSOTrx) {
                    qty = qty.add(this.getScrappedQty());
                }
                line.setMovementQty(qty);
                line.setScrappedQty(this.getScrappedQty());
            } else if ("XV".equals(confirmType)) {
                line.setConfirmedQty(this.getConfirmedQty());
            }
        }
        return line.save(this.get_TrxName());
    }

    public boolean isFullyConfirmed() {
        return this.getTargetQty().compareTo(this.getConfirmedQty()) == 0;
    }

    protected boolean beforeDelete() {
        this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
        return false;
    }

    protected boolean beforeSave(boolean newRecord) {
        BigDecimal difference = this.getTargetQty();
        difference = difference.subtract(this.getConfirmedQty());
        difference = difference.subtract(this.getScrappedQty());
        this.setDifferenceQty(difference);
        return true;
    }
}

