/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.X_AD_EntityType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MEntityType
extends X_AD_EntityType {
    private static MEntityType[] s_entityTypes = null;
    private static CLogger s_log = CLogger.getCLogger(MEntityType.class);
    private static final int s_maxAD_EntityType_ID = 221;

    public static MEntityType[] getEntityTypes(Properties ctx) {
        if (s_entityTypes != null) {
            return s_entityTypes;
        }
        ArrayList<MEntityType> list = new ArrayList<MEntityType>();
        String sql = "SELECT * FROM AD_EntityType WHERE IsActive='Y' ORDER BY AD_EntityType_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MEntityType(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_entityTypes = new MEntityType[list.size()];
        list.toArray(s_entityTypes);
        s_log.finer("# " + s_entityTypes.length);
        return s_entityTypes;
    }

    public static String[] getEntityTypeStrings(Properties ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx);
        ArrayList<String> list = new ArrayList<String>();
        String[] retValue = new String[entityTypes.length];
        for (int i2 = 0; i2 < entityTypes.length; ++i2) {
            String s = entityTypes[i2].getEntityType().trim();
            list.add(s);
            retValue[i2] = s;
        }
        s_log.finer(list.toString());
        return retValue;
    }

    public static String[] getClasspaths(Properties ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx);
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < entityTypes.length; ++i2) {
            String classpath = entityTypes[i2].getClasspath();
            if (classpath == null || classpath.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(classpath, ";, \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0 || list.contains(token)) continue;
                list.add(token);
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        s_log.finer(list.toString());
        return retValue;
    }

    public static String[] getModelPackages(Properties ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx);
        ArrayList<String> list = new ArrayList<String>();
        list.add("adempiere.model");
        for (int i2 = 0; i2 < entityTypes.length; ++i2) {
            String modelPackage = entityTypes[i2].getModelPackage();
            if (modelPackage == null || modelPackage.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(modelPackage, ";, \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0 || list.contains(token)) continue;
                list.add(token);
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        s_log.finer(list.toString());
        return retValue;
    }

    public MEntityType(Properties ctx, int AD_EntityType_ID, String trxName) {
        super(ctx, AD_EntityType_ID, trxName);
    }

    public MEntityType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isSystemMaintained() {
        int id = this.getAD_EntityType_ID();
        return id < 221;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord) {
            boolean systemMaintained;
            int id = this.getAD_EntityType_ID();
            boolean bl = systemMaintained = id == 10 || id == 20;
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify a System maintained entity");
                return false;
            }
            systemMaintained = this.is_ValueChanged("EntityType");
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify EntityType");
                return false;
            }
            boolean bl2 = systemMaintained = id < 221 && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("IsActive"));
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify Name,Description,Help");
                return false;
            }
        } else {
            this.setEntityType(this.getEntityType().toUpperCase());
            if (this.getEntityType().trim().length() < 4) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "EntityType") + " - 4 Characters");
                return false;
            }
            boolean ok = true;
            char[] cc = this.getEntityType().toCharArray();
            for (int i2 = 0; i2 < cc.length; ++i2) {
                char c = cc[i2];
                if (Character.isDigit(c) || c >= 'A' && c <= 'Z') continue;
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "EntityType") + " - Must be ASCII Letter or Digit");
                return false;
            }
        }
        s_entityTypes = null;
        return true;
    }

    protected boolean beforeDelete() {
        if (this.isSystemMaintained()) {
            this.log.saveError("Error", "You cannot delete a System maintained entity");
            return false;
        }
        s_entityTypes = null;
        return true;
    }
}

