/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.X_C_DunningRun;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MDunningRun
extends X_C_DunningRun {
    private MDunningLevel m_level = null;
    private MDunningRunEntry[] m_entries = null;

    public MDunningRun(Properties ctx, int C_DunningRun_ID, String trxName) {
        super(ctx, C_DunningRun_ID, trxName);
        if (C_DunningRun_ID == 0) {
            this.setDunningDate(new Timestamp(System.currentTimeMillis()));
            this.setProcessed(false);
        }
    }

    public MDunningRun(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningLevel getLevel() {
        if (this.m_level == null) {
            this.m_level = new MDunningLevel(this.getCtx(), this.getC_DunningLevel_ID(), this.get_TrxName());
        }
        return this.m_level;
    }

    public MDunningRunEntry[] getEntries(boolean requery) {
        if (this.m_entries != null && !requery) {
            return this.m_entries;
        }
        String sql = "SELECT * FROM C_DunningRunEntry WHERE C_DunningRun_ID=?";
        ArrayList<MDunningRunEntry> list = new ArrayList<MDunningRunEntry>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_DunningRun_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDunningRunEntry(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getEntries", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_entries = new MDunningRunEntry[list.size()];
        list.toArray(this.m_entries);
        return this.m_entries;
    }

    public boolean deleteEntries(boolean force) {
        boolean ok;
        this.getEntries(true);
        for (int i2 = 0; i2 < this.m_entries.length; ++i2) {
            MDunningRunEntry entry = this.m_entries[i2];
            entry.delete(force);
        }
        boolean bl = ok = this.getEntries(true).length == 0;
        if (ok) {
            this.m_entries = null;
        }
        return ok;
    }

    public MDunningRunEntry getEntry(int C_BPartner_ID, int C_Currency_ID, int SalesRep_ID) {
        int C_BPartnerRelated_ID = C_BPartner_ID;
        this.getEntries(false);
        for (int i2 = 0; i2 < this.m_entries.length; ++i2) {
            MDunningRunEntry entry = this.m_entries[i2];
            if (entry.getC_BPartner_ID() != C_BPartnerRelated_ID) continue;
            return entry;
        }
        MDunningRunEntry entry = new MDunningRunEntry(this);
        MBPartner bp = new MBPartner(this.getCtx(), C_BPartnerRelated_ID, this.get_TrxName());
        entry.setBPartner(bp, true);
        if (entry.getSalesRep_ID() == 0) {
            entry.setSalesRep_ID(SalesRep_ID);
        }
        entry.setC_Currency_ID(C_Currency_ID);
        this.m_entries = null;
        return entry;
    }
}

