/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.X_C_DocTypeCounter;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MDocTypeCounter
extends X_C_DocTypeCounter {
    private static CCache<Integer, MDocTypeCounter> s_cache = new CCache("C_DocTypeCounter", 20);
    private static CCache<Integer, MDocTypeCounter> s_counter = new CCache("C_DocTypeCounter", 20);
    private static CLogger s_log = CLogger.getCLogger(MDocTypeCounter.class);

    public static int getCounterDocType_ID(Properties ctx, int C_DocType_ID) {
        MDocTypeCounter dtCounter = MDocTypeCounter.getCounterDocType(ctx, C_DocType_ID);
        if (dtCounter != null) {
            if (!dtCounter.isCreateCounter() || !dtCounter.isValid()) {
                return -1;
            }
            return dtCounter.getCounter_C_DocType_ID();
        }
        int Counter_C_DocType_ID = 0;
        MDocType dt = MDocType.get(ctx, C_DocType_ID);
        if (!dt.isCreateCounter()) {
            return -1;
        }
        String cDocBaseType = MDocTypeCounter.getCounterDocBaseType(dt.getDocBaseType());
        if (cDocBaseType == null) {
            return 0;
        }
        MDocType[] counters = MDocType.getOfDocBaseType(ctx, cDocBaseType);
        for (int i2 = 0; i2 < counters.length; ++i2) {
            MDocType counter = counters[i2];
            if (counter.isDefaultCounterDoc()) {
                Counter_C_DocType_ID = counter.getC_DocType_ID();
                break;
            }
            if (counter.isDefault()) {
                Counter_C_DocType_ID = counter.getC_DocType_ID();
                continue;
            }
            if (i2 != 0) continue;
            Counter_C_DocType_ID = counter.getC_DocType_ID();
        }
        return Counter_C_DocType_ID;
    }

    public static MDocTypeCounter getCounterDocType(Properties ctx, int C_DocType_ID) {
        Integer key = new Integer(C_DocType_ID);
        MDocTypeCounter retValue = s_counter.get(key);
        if (retValue != null) {
            return retValue;
        }
        MDocTypeCounter temp = null;
        String sql = "SELECT * FROM C_DocTypeCounter WHERE C_DocType_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_DocType_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next() && retValue == null) {
                retValue = new MDocTypeCounter(ctx, rs, null);
                if (retValue.isCreateCounter() && retValue.isValid()) continue;
                temp = retValue;
                retValue = null;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getCounterDocType", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            return retValue;
        }
        if (temp != null) {
            return temp;
        }
        return null;
    }

    public static MDocTypeCounter get(Properties ctx, int C_DocTypeCounter_ID, String trxName) {
        Integer key = new Integer(C_DocTypeCounter_ID);
        MDocTypeCounter retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDocTypeCounter(ctx, C_DocTypeCounter_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getCounterDocBaseType(String DocBaseType) {
        if (DocBaseType == null) {
            return null;
        }
        String retValue = null;
        if ("SOO".equals(DocBaseType)) {
            retValue = "POO";
        } else if ("POO".equals(DocBaseType)) {
            retValue = "SOO";
        } else if ("API".equals(DocBaseType)) {
            retValue = "ARI";
        } else if ("ARI".equals(DocBaseType)) {
            retValue = "API";
        } else if ("MMS".equals(DocBaseType)) {
            retValue = "MMR";
        } else if ("MMR".equals(DocBaseType)) {
            retValue = "MMS";
        } else if ("APC".equals(DocBaseType)) {
            retValue = "ARC";
        } else if ("ARC".equals(DocBaseType)) {
            retValue = "APC";
        } else if ("ARR".equals(DocBaseType)) {
            retValue = "APP";
        } else if ("APP".equals(DocBaseType)) {
            retValue = "ARR";
        } else {
            s_log.log(Level.SEVERE, "getCounterDocBaseType for " + DocBaseType + ": None found");
        }
        return retValue;
    }

    public MDocTypeCounter(Properties ctx, int C_DocTypeCounter_ID, String trxName) {
        super(ctx, C_DocTypeCounter_ID, trxName);
        if (C_DocTypeCounter_ID == 0) {
            this.setIsCreateCounter(true);
            this.setIsValid(false);
        }
    }

    public MDocTypeCounter(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setC_DocType_ID(int C_DocType_ID) {
        super.setC_DocType_ID(C_DocType_ID);
        if (this.isValid()) {
            this.setIsValid(false);
        }
    }

    public void setCounter_C_DocType_ID(int Counter_C_DocType_ID) {
        super.setCounter_C_DocType_ID(Counter_C_DocType_ID);
        if (this.isValid()) {
            this.setIsValid(false);
        }
    }

    public MDocType getDocType() {
        MDocType dt = null;
        if (this.getC_DocType_ID() > 0 && (dt = MDocType.get(this.getCtx(), this.getC_DocType_ID())).get_ID() == 0) {
            dt = null;
        }
        return dt;
    }

    public MDocType getCounterDocType() {
        MDocType dt = null;
        if (this.getCounter_C_DocType_ID() > 0 && (dt = MDocType.get(this.getCtx(), this.getCounter_C_DocType_ID())).get_ID() == 0) {
            dt = null;
        }
        return dt;
    }

    public String validate() {
        MDocType dt = this.getDocType();
        if (dt == null) {
            this.log.log(Level.SEVERE, "No DocType=" + this.getC_DocType_ID());
            this.setIsValid(false);
            return "No Document Type";
        }
        MDocType c_dt = this.getCounterDocType();
        if (c_dt == null) {
            this.log.log(Level.SEVERE, "No Counter DocType=" + this.getCounter_C_DocType_ID());
            this.setIsValid(false);
            return "No Counter Document Type";
        }
        String dtBT = dt.getDocBaseType();
        String c_dtBT = c_dt.getDocBaseType();
        this.log.fine(dtBT + " -> " + c_dtBT);
        if ("SOO".equals(dtBT) && "POO".equals(c_dtBT) || "SOO".equals(c_dtBT) && "POO".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("API".equals(dtBT) && "ARI".equals(c_dtBT) || "API".equals(c_dtBT) && "ARI".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("MMS".equals(dtBT) && "MMR".equals(c_dtBT) || "MMS".equals(c_dtBT) && "MMR".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("APC".equals(dtBT) && "ARC".equals(c_dtBT) || "APC".equals(c_dtBT) && "ARC".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("ARR".equals(dtBT) && "APP".equals(c_dtBT) || "ARR".equals(c_dtBT) && "APP".equals(dtBT)) {
            this.setIsValid(true);
        } else {
            this.log.warning("NOT - " + dtBT + " -> " + c_dtBT);
            this.setIsValid(false);
            return "Not valid";
        }
        if (!c_dt.isDocNoControlled()) {
            return "Counter Document Type should be automatically Document Number controlled";
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MDocTypeCounter[");
        sb.append(this.get_ID()).append(",").append(this.getName()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(",Counter=").append(this.getCounter_C_DocType_ID()).append(",DocAction=").append(this.getDocAction()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (!newRecord && (this.is_ValueChanged("C_DocType_ID") || this.is_ValueChanged("Counter_C_DocType_ID"))) {
            this.setIsValid(false);
        }
        if (!this.isValid()) {
            this.validate();
        }
        return true;
    }
}

