/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_DocType;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDocType
extends X_C_DocType {
    private static CCache<Integer, MDocType> s_cache = new CCache("C_DocType", 20);
    private static CLogger s_log = CLogger.getCLogger(MDocType.class);

    public static MDocType[] getOfDocBaseType(Properties ctx, String DocBaseType) {
        ArrayList<MDocType> list = new ArrayList<MDocType>();
        String sql = "SELECT * FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            pstmt.setString(2, DocBaseType);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDocType(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MDocType[] retValue = new MDocType[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MDocType[] getOfClient(Properties ctx) {
        ArrayList<MDocType> list = new ArrayList<MDocType>();
        String sql = "SELECT * FROM C_DocType WHERE AD_Client_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDocType(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MDocType[] retValue = new MDocType[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MDocType get(Properties ctx, int C_DocType_ID) {
        Integer key = new Integer(C_DocType_ID);
        MDocType retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MDocType(ctx, C_DocType_ID, null);
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MDocType(Properties ctx, int C_DocType_ID, String trxName) {
        super(ctx, C_DocType_ID, trxName);
        if (C_DocType_ID == 0) {
            this.setDocumentCopies(0);
            this.setHasCharges(false);
            this.setIsDefault(false);
            this.setIsDocNoControlled(false);
            this.setIsSOTrx(false);
            this.setIsPickQAConfirm(false);
            this.setIsShipConfirm(false);
            this.setIsSplitWhenDifference(false);
            this.setIsCreateCounter(true);
            this.setIsDefaultCounterDoc(false);
            this.setIsIndexed(true);
        }
    }

    public MDocType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDocType(Properties ctx, String DocBaseType, String Name2, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setDocBaseType(DocBaseType);
        this.setName(Name2);
        this.setPrintName(Name2);
        this.setGL_Category_ID();
    }

    public void setGL_Category_ID() {
        String sql = "SELECT * FROM GL_Category WHERE AD_Client_ID=? AND IsDefault='Y'";
        int GL_Category_ID = DB.getSQLValue(this.get_TrxName(), sql, this.getAD_Client_ID());
        if (GL_Category_ID == 0) {
            sql = "SELECT * FROM GL_Category WHERE AD_Client_ID=?";
            GL_Category_ID = DB.getSQLValue(this.get_TrxName(), sql, this.getAD_Client_ID());
        }
        this.setGL_Category_ID(GL_Category_ID);
    }

    public void setIsSOTrx() {
        boolean isSOTrx = "SOO".equals(this.getDocBaseType()) || "MMS".equals(this.getDocBaseType()) || this.getDocBaseType().startsWith("AR");
        super.setIsSOTrx(isSOTrx);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MDocType[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",DocNoSequence_ID=").append(this.getDocNoSequence_ID()).append("]");
        return sb.toString();
    }

    public boolean isQuotation() {
        return "OB".equals(this.getDocSubTypeSO()) && "SOO".equals(this.getDocBaseType());
    }

    public boolean isProposal() {
        return "ON".equals(this.getDocSubTypeSO()) && "SOO".equals(this.getDocBaseType());
    }

    public boolean isOffer() {
        return ("ON".equals(this.getDocSubTypeSO()) || "OB".equals(this.getDocSubTypeSO())) && "SOO".equals(this.getDocBaseType());
    }

    public String getPrintName(String AD_Language) {
        if (AD_Language == null || AD_Language.length() == 0) {
            return super.getPrintName();
        }
        String retValue = this.get_Translation("PrintName", AD_Language);
        if (retValue != null) {
            return retValue;
        }
        return super.getPrintName();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }
}

