/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.model.X_M_DistributionRunLine;
import org.compiere.util.Env;

public class MDistributionRunLine
extends X_M_DistributionRunLine {
    private MProduct m_product = null;
    private BigDecimal m_actualQty = Env.ZERO;
    private BigDecimal m_actualMin = Env.ZERO;
    private BigDecimal m_actualAllocation = Env.ZERO;
    private BigDecimal m_lastDifference = Env.ZERO;
    private BigDecimal m_maxAllocation = Env.ZERO;

    public MDistributionRunLine(Properties ctx, int M_DistributionRunLine_ID, String trxName) {
        super(ctx, M_DistributionRunLine_ID, trxName);
    }

    public MDistributionRunLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public BigDecimal getActualQty() {
        return this.m_actualQty;
    }

    public void addActualQty(BigDecimal add) {
        this.m_actualQty = this.m_actualQty.add(add);
    }

    public BigDecimal getActualMin() {
        return this.m_actualMin;
    }

    public void addActualMin(BigDecimal add) {
        this.m_actualMin = this.m_actualMin.add(add);
    }

    public boolean isActualMinGtTotal() {
        return this.m_actualMin.compareTo(this.getTotalQty()) > 0;
    }

    public BigDecimal getActualAllocation() {
        return this.m_actualAllocation;
    }

    public void addActualAllocation(BigDecimal add) {
        this.m_actualAllocation = this.m_actualAllocation.add(add);
    }

    public boolean isActualAllocationEqTotal() {
        return this.m_actualAllocation.compareTo(this.getTotalQty()) == 0;
    }

    public BigDecimal getActualAllocationDiff() {
        return this.getTotalQty().subtract(this.m_actualAllocation);
    }

    public BigDecimal getLastDifference() {
        return this.m_lastDifference;
    }

    public void setLastDifference(BigDecimal difference) {
        this.m_lastDifference = difference;
    }

    public BigDecimal getMaxAllocation() {
        return this.m_maxAllocation;
    }

    public void setMaxAllocation(BigDecimal max, boolean set) {
        if (set || max.compareTo(this.m_maxAllocation) > 0) {
            this.m_maxAllocation = max;
        }
    }

    public void resetCalculations() {
        this.m_actualQty = Env.ZERO;
        this.m_actualMin = Env.ZERO;
        this.m_actualAllocation = Env.ZERO;
        this.m_maxAllocation = Env.ZERO;
    }

    public MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public int getUOMPrecision() {
        return this.getProduct().getUOMPrecision();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MDistributionRunLine[").append(this.get_ID()).append("-").append(this.getInfo()).append("]");
        return sb.toString();
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Line=").append(this.getLine()).append(",TotalQty=").append(this.getTotalQty()).append(",SumMin=").append(this.getActualMin()).append(",SumQty=").append(this.getActualQty()).append(",SumAllocation=").append(this.getActualAllocation()).append(",MaxAllocation=").append(this.getMaxAllocation()).append(",LastDiff=").append(this.getLastDifference());
        return sb.toString();
    }
}

