/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MDistribution;
import org.compiere.model.X_GL_DistributionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MDistributionLine
extends X_GL_DistributionLine {
    private MDistribution m_parent = null;
    private BigDecimal m_amt = null;
    private MAccount m_account = null;

    public MDistributionLine(Properties ctx, int GL_DistributionLine_ID, String trxName) {
        super(ctx, GL_DistributionLine_ID, trxName);
        if (GL_DistributionLine_ID == 0) {
            this.setOverwriteAcct(false);
            this.setOverwriteActivity(false);
            this.setOverwriteBPartner(false);
            this.setOverwriteCampaign(false);
            this.setOverwriteLocFrom(false);
            this.setOverwriteLocTo(false);
            this.setOverwriteOrg(false);
            this.setOverwriteOrgTrx(false);
            this.setOverwriteProduct(false);
            this.setOverwriteProject(false);
            this.setOverwriteSalesRegion(false);
            this.setOverwriteUser1(false);
            this.setOverwriteUser2(false);
            this.setPercent(Env.ZERO);
        }
    }

    public MDistributionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDistribution getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MDistribution(this.getCtx(), this.getGL_Distribution_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MDistribution parent) {
        this.m_parent = parent;
    }

    public void setAccount(MAccount acct) {
        this.m_account = acct;
    }

    public MAccount getAccount() {
        MAccount acct = MAccount.get(this.getCtx(), this.m_account.getAD_Client_ID(), this.isOverwriteOrg() && this.getOrg_ID() != 0 ? this.getOrg_ID() : this.m_account.getAD_Org_ID(), this.m_account.getC_AcctSchema_ID(), this.isOverwriteAcct() && this.getAccount_ID() != 0 ? this.getAccount_ID() : this.m_account.getAccount_ID(), this.m_account.getC_SubAcct_ID(), this.isOverwriteProduct() ? this.getM_Product_ID() : this.m_account.getM_Product_ID(), this.isOverwriteBPartner() ? this.getC_BPartner_ID() : this.m_account.getC_BPartner_ID(), this.isOverwriteOrgTrx() ? this.getAD_OrgTrx_ID() : this.m_account.getAD_OrgTrx_ID(), this.isOverwriteLocFrom() ? this.getC_LocFrom_ID() : this.m_account.getC_LocFrom_ID(), this.isOverwriteLocTo() ? this.getC_LocTo_ID() : this.m_account.getC_LocTo_ID(), this.isOverwriteSalesRegion() ? this.getC_SalesRegion_ID() : this.m_account.getC_SalesRegion_ID(), this.isOverwriteProject() ? this.getC_Project_ID() : this.m_account.getC_Project_ID(), this.isOverwriteCampaign() ? this.getC_Campaign_ID() : this.m_account.getC_Campaign_ID(), this.isOverwriteActivity() ? this.getC_Activity_ID() : this.m_account.getC_Activity_ID(), this.isOverwriteUser1() ? this.getUser1_ID() : this.m_account.getUser1_ID(), this.isOverwriteUser2() ? this.getUser2_ID() : this.m_account.getUser2_ID(), this.m_account.getUserElement1_ID(), this.m_account.getUserElement2_ID());
        return acct;
    }

    public BigDecimal getAmt() {
        return this.m_amt;
    }

    public void setAmt(BigDecimal amt) {
        this.m_amt = amt;
    }

    public void calculateAmt(BigDecimal amt, int precision) {
        this.m_amt = amt.multiply(this.getPercent());
        this.m_amt = this.m_amt.divide(Env.ONEHUNDRED, precision, 4);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM GL_DistributionLine WHERE GL_Distribution_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getGL_Distribution_ID());
            this.setLine(ii);
        }
        if (!this.isOverwriteAcct() && this.getAccount_ID() != 0) {
            this.setAccount_ID(0);
        }
        if (!this.isOverwriteActivity() && this.getC_Activity_ID() != 0) {
            this.setC_Activity_ID(0);
        }
        if (!this.isOverwriteBPartner() && this.getC_BPartner_ID() != 0) {
            this.setC_BPartner_ID(0);
        }
        if (!this.isOverwriteCampaign() && this.getC_Campaign_ID() != 0) {
            this.setC_Campaign_ID(0);
        }
        if (!this.isOverwriteLocFrom() && this.getC_LocFrom_ID() != 0) {
            this.setC_LocFrom_ID(0);
        }
        if (!this.isOverwriteLocTo() && this.getC_LocTo_ID() != 0) {
            this.setC_LocTo_ID(0);
        }
        if (!this.isOverwriteOrg() && this.getOrg_ID() != 0) {
            this.setOrg_ID(0);
        }
        if (!this.isOverwriteOrgTrx() && this.getAD_OrgTrx_ID() != 0) {
            this.setAD_OrgTrx_ID(0);
        }
        if (!this.isOverwriteProduct() && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (!this.isOverwriteProject() && this.getC_Project_ID() != 0) {
            this.setC_Project_ID(0);
        }
        if (!this.isOverwriteSalesRegion() && this.getC_SalesRegion_ID() != 0) {
            this.setC_SalesRegion_ID(0);
        }
        if (!this.isOverwriteUser1() && this.getUser1_ID() != 0) {
            this.setUser1_ID(0);
        }
        if (!this.isOverwriteUser2() && this.getUser2_ID() != 0) {
            this.setUser2_ID(0);
        }
        if (this.isOverwriteAcct() && this.getAccount_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Account_ID@ = 0"));
            return false;
        }
        if (this.isOverwriteOrg() && this.getOrg_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Org_ID@ = 0"));
            return false;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.getParent();
        this.m_parent.validate();
        this.m_parent.save();
        return success;
    }
}

