/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.cm.CacheHandler;
import org.compiere.model.MCStage;
import org.compiere.model.MContainerElement;
import org.compiere.model.MIndex;
import org.compiere.model.MTemplate;
import org.compiere.model.MWebProject;
import org.compiere.model.PO;
import org.compiere.model.X_CM_CStageTTable;
import org.compiere.model.X_CM_CStage_Element;
import org.compiere.model.X_CM_Container;
import org.compiere.model.X_CM_ContainerTTable;
import org.compiere.model.X_CM_Container_Element;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MContainer
extends X_CM_Container {
    private static final long serialVersionUID = 395679572291279730L;
    private static CLogger s_log = CLogger.getCLogger(MContainer.class);
    private MWebProject m_project = null;
    private MCStage m_stage = null;
    private MTemplate m_template = null;

    public static MContainer get(Properties ctx, String relURL, int CM_WebProject_Id, String trxName) {
        MContainer thisContainer = null;
        String sql = "SELECT * FROM CM_Container WHERE (RelativeURL LIKE ? OR RelativeURL LIKE ?) AND CM_WebProject_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setString(1, relURL);
            pstmt.setString(2, relURL + "/");
            pstmt.setInt(3, CM_WebProject_Id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                thisContainer = new MContainer(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return thisContainer;
    }

    public static MContainer get(Properties ctx, int CM_Container_ID, int CM_WebProject_Id, String trxName) {
        MContainer thisContainer = null;
        String sql = "SELECT * FROM CM_Container WHERE CM_Container_ID=? AND CM_WebProject_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, CM_Container_ID);
            pstmt.setInt(2, CM_WebProject_Id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                thisContainer = new MContainer(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return thisContainer;
    }

    public static MContainer copy(MWebProject project, MCStage stage, String path) {
        MContainer cc = MContainer.getDirect(stage.getCtx(), stage.getCM_CStage_ID(), stage.get_TrxName());
        if (cc == null) {
            cc = new MContainer(stage.getCtx(), 0, stage.get_TrxName());
        }
        cc.setStage(project, stage, path);
        cc.save();
        if (!stage.isSummary()) {
            cc.updateElements(project, stage, stage.get_TrxName());
            cc.updateTTables(project, stage, stage.get_TrxName());
        }
        return cc;
    }

    public static MContainer getDirect(Properties ctx, int CM_Container_ID, String trxName) {
        MContainer cc = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_Container WHERE CM_Container_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, CM_Container_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                cc = new MContainer(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return cc;
    }

    public static MContainer[] getContainers(MWebProject project) {
        ArrayList<MContainer> list = new ArrayList<MContainer>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_Container WHERE CM_WebProject_ID=? ORDER BY CM_Container_ID";
        try {
            pstmt = DB.prepareStatement(sql, project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MContainer(project.getCtx(), rs, project.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MContainer[] retValue = new MContainer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MContainer(Properties ctx, int CM_Container_ID, String trxName) {
        super(ctx, CM_Container_ID, trxName);
        if (CM_Container_ID == 0) {
            this.setIsValid(false);
            this.setIsIndexed(false);
            this.setIsSecure(false);
            this.setIsSummary(false);
        }
    }

    public MContainer(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = MWebProject.get(this.getCtx(), this.getCM_WebProject_ID());
        }
        return this.m_project;
    }

    public MTemplate getTemplate() {
        if (this.getCM_Template_ID() > 0 && this.m_template == null) {
            this.m_template = MTemplate.get(this.getCtx(), this.getCM_Template_ID(), null);
        }
        return this.m_template;
    }

    public int getAD_Tree_ID() {
        return this.getWebProject().getAD_TreeCMC_ID();
    }

    protected void setStage(MWebProject project, MCStage stage, String path) {
        this.m_stage = stage;
        PO.copyValues(stage, this);
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setIsActive(stage.isActive());
        this.setCM_ContainerLink_ID(stage.getCM_CStageLink_ID());
        this.setRelativeURL(path + stage.getRelativeURL());
        if (this.getMeta_Author() == null || this.getMeta_Author().length() == 0) {
            this.setMeta_Author(project.getMeta_Author());
        }
        if (this.getMeta_Content() == null || this.getMeta_Content().length() == 0) {
            this.setMeta_Content(project.getMeta_Content());
        }
        if (this.getMeta_Copyright() == null || this.getMeta_Copyright().length() == 0) {
            this.setMeta_Copyright(project.getMeta_Copyright());
        }
        if (this.getMeta_Publisher() == null || this.getMeta_Publisher().length() == 0) {
            this.setMeta_Publisher(project.getMeta_Publisher());
        }
        if (this.getMeta_RobotsTag() == null || this.getMeta_RobotsTag().length() == 0) {
            this.setMeta_RobotsTag(project.getMeta_RobotsTag());
        }
    }

    protected void updateElements(MWebProject project, MCStage stage, String trxName) {
        int i2;
        CacheHandler thisHandler = new CacheHandler(CacheHandler.convertJNPURLToCacheURL(this.getCtx().getProperty("java.naming.provider.url")), this.log, this.getCtx(), this.get_TrxName());
        int[] tableKeys = X_CM_CStage_Element.getAllIDs("CM_CStage_Element", "CM_CStage_ID=" + stage.get_ID(), trxName);
        if (tableKeys != null && tableKeys.length > 0) {
            for (i2 = 0; i2 < tableKeys.length; ++i2) {
                X_CM_CStage_Element thisStageElement = new X_CM_CStage_Element(project.getCtx(), tableKeys[i2], trxName);
                int[] thisContainerElementKeys = X_CM_Container_Element.getAllIDs("CM_Container_Element", "CM_Container_ID=" + stage.get_ID() + " AND Name LIKE '" + thisStageElement.getName() + "'", trxName);
                X_CM_Container_Element thisContainerElement = thisContainerElementKeys != null && thisContainerElementKeys.length > 0 ? new X_CM_Container_Element(project.getCtx(), thisContainerElementKeys[0], trxName) : new X_CM_Container_Element(project.getCtx(), 0, trxName);
                thisContainerElement.setCM_Container_ID(stage.get_ID());
                X_CM_CStage_Element stageElement = new X_CM_CStage_Element(project.getCtx(), tableKeys[i2], trxName);
                thisContainerElement.setName(stageElement.getName());
                thisContainerElement.setDescription(stageElement.getDescription());
                thisContainerElement.setHelp(stageElement.getHelp());
                thisContainerElement.setIsActive(stageElement.isActive());
                thisContainerElement.setIsValid(stageElement.isValid());
                String contentHTML = thisStageElement.getContentHTML();
                thisContainerElement.setContentHTML(contentHTML);
                thisContainerElement.save(trxName);
                thisHandler.cleanContainerElement(thisContainerElement.get_ID());
            }
        }
        if ((tableKeys = X_CM_Container_Element.getAllIDs("CM_Container_Element", "CM_Container_ID=" + stage.get_ID(), trxName)) != null && tableKeys.length > 0) {
            for (i2 = 0; i2 < tableKeys.length; ++i2) {
                X_CM_Container_Element thisContainerElement = new X_CM_Container_Element(project.getCtx(), tableKeys[i2], trxName);
                int[] thisCStageElementKeys = X_CM_CStage_Element.getAllIDs("CM_CStage_Element", "CM_CStage_ID=" + stage.get_ID() + " AND Name LIKE '" + thisContainerElement.getName() + "'", trxName);
                if (thisCStageElementKeys != null && thisCStageElementKeys.length >= 1) continue;
                thisHandler.cleanContainerElement(thisContainerElement.get_ID());
                thisContainerElement.delete(true);
            }
        }
    }

    protected void updateTTables(MWebProject project, MCStage stage, String trxName) {
        int[] tableKeys = X_CM_CStageTTable.getAllIDs("CM_CStageTTable", "CM_CStage_ID=" + stage.get_ID(), trxName);
        if (tableKeys != null && tableKeys.length > 0) {
            for (int i2 = 0; i2 < tableKeys.length; ++i2) {
                X_CM_CStageTTable thisStageTTable = new X_CM_CStageTTable(project.getCtx(), tableKeys[i2], trxName);
                int[] thisContainerTTableKeys = X_CM_ContainerTTable.getAllIDs("CM_ContainerTTable", "CM_Container_ID=" + stage.get_ID() + " AND CM_TemplateTable_ID=" + thisStageTTable.getCM_TemplateTable_ID(), trxName);
                X_CM_ContainerTTable thisContainerTTable = thisContainerTTableKeys != null && thisContainerTTableKeys.length > 0 ? new X_CM_ContainerTTable(project.getCtx(), thisContainerTTableKeys[0], trxName) : new X_CM_ContainerTTable(project.getCtx(), 0, trxName);
                thisContainerTTable.setCM_Container_ID(stage.get_ID());
                PO.copyValues(new X_CM_CStageTTable(project.getCtx(), tableKeys[i2], trxName), thisContainerTTable);
                thisContainerTTable.save(trxName);
            }
        }
    }

    protected int saveNew_getID() {
        if (this.m_stage != null) {
            return this.m_stage.getCM_CStage_ID();
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MContainer[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            StringBuffer sb = new StringBuffer("INSERT INTO AD_TreeNodeCMC (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (").append(this.getAD_Client_ID()).append(",0, 'Y', SysDate, 0, SysDate, 0,").append(this.getAD_Tree_ID()).append(",").append(this.get_ID()).append(", 0, 999)");
            int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
            if (no > 0) {
                this.log.fine("#" + no + " - TreeType=CMC");
            } else {
                this.log.warning("#" + no + " - TreeType=CMC");
            }
            return no > 0;
        }
        return success;
    }

    protected MContainerElement[] getAllElements() {
        int[] elements = MContainerElement.getAllIDs("CM_Container_Element", "CM_Container_ID=" + this.get_ID(), this.get_TrxName());
        if (elements.length > 0) {
            MContainerElement[] containerElements = new MContainerElement[elements.length];
            for (int i2 = 0; i2 < elements.length; ++i2) {
                containerElements[i2] = new MContainerElement(this.getCtx(), elements[i2], this.get_TrxName());
            }
            return containerElements;
        }
        return null;
    }

    protected boolean beforeDelete() {
        StringBuffer sb;
        int no;
        MIndex.cleanUp(this.get_TrxName(), this.getAD_Client_ID(), this.get_Table_ID(), this.get_ID());
        MContainerElement[] theseElements = this.getAllElements();
        if (theseElements != null) {
            for (int i2 = 0; i2 < theseElements.length; ++i2) {
                theseElements[i2].delete(false);
            }
        }
        if ((no = DB.executeUpdate((sb = new StringBuffer("DELETE FROM AD_TreeNodeCMC ").append(" WHERE Node_ID=").append(this.get_ID()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID())).toString(), this.get_TrxName())) > 0) {
            this.log.fine("#" + no + " - TreeType=CMC");
        } else {
            this.log.warning("#" + no + " - TreeType=CMC");
        }
        return no > 0;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM AD_TreeNodeCMC ").append(" WHERE Node_ID=").append(this.get_IDOld()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID());
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=CMC");
        } else {
            this.log.warning("#" + no + " - TreeType=CMC");
        }
        return true;
    }

    public void reIndex(boolean newRecord) {
        String[] toBeIndexed = new String[]{this.getName(), this.getDescription(), this.getRelativeURL(), this.getMeta_Author(), this.getMeta_Copyright(), this.getMeta_Description(), this.getMeta_Keywords(), this.getMeta_Publisher()};
        MIndex.reIndex(newRecord, toBeIndexed, this.getCtx(), this.getAD_Client_ID(), this.get_Table_ID(), this.get_ID(), this.getCM_WebProject_ID(), this.getUpdated());
        MContainerElement[] theseElements = this.getAllElements();
        if (theseElements != null) {
            for (int i2 = 0; i2 < theseElements.length; ++i2) {
                theseElements[i2].reIndex(false);
            }
        }
    }
}

