/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCommissionLine;
import org.compiere.model.PO;
import org.compiere.model.X_C_Commission;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MCommission
extends X_C_Commission {
    public MCommission(Properties ctx, int C_Commission_ID, String trxName) {
        super(ctx, C_Commission_ID, trxName);
        if (C_Commission_ID == 0) {
            this.setDocBasisType("I");
            this.setFrequencyType("M");
            this.setListDetails(false);
        }
    }

    public MCommission(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionLine[] getLines() {
        String sql = "SELECT * FROM C_CommissionLine WHERE C_Commission_ID=? ORDER BY Line";
        ArrayList<MCommissionLine> list = new ArrayList<MCommissionLine>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Commission_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCommissionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCommissionLine[] retValue = new MCommissionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void setDateLastRun(Timestamp DateLastRun) {
        if (DateLastRun != null) {
            super.setDateLastRun(DateLastRun);
        }
    }

    public int copyLinesFrom(MCommission otherCom) {
        if (otherCom == null) {
            return 0;
        }
        MCommissionLine[] fromLines = otherCom.getLines();
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MCommissionLine line = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Commission_ID(this.getC_Commission_ID());
            line.setC_CommissionLine_ID(0);
            if (!line.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "copyLinesFrom - Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }
}

