/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_Column;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MColumn
extends X_AD_Column {
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);

    public static MColumn get(Properties ctx, int AD_Column_ID) {
        Integer key = new Integer(AD_Column_ID);
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID) {
        MColumn col = MColumn.get(ctx, AD_Column_ID);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Properties ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
        }
    }

    public MColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.startsWith("Created") || columnName.startsWith("Updated");
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getFieldLength() == 0 && !DisplayType.isLOB(this.getAD_Reference_ID())) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "FieldLength"));
            return false;
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(this.getColumnName()) || "Value".equalsIgnoreCase(this.getColumnName()) || "Name".equalsIgnoreCase(this.getColumnName())) {
                this.log.warning("Encryption not sensible - " + this.getColumnName());
                this.setIsEncrypted(false);
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            StringBuffer sql = new StringBuffer("UPDATE AD_Field SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Column_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("afterSave - Fields updated #" + no);
        }
        return success;
    }

    public String getSQLAdd(MTable table2) {
        StringBuffer sql = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(this.getSQLDDL());
        return sql.toString();
    }

    public String getSQLDDL() {
        StringBuffer sql = new StringBuffer(this.getColumnName()).append(" ").append(this.getSQLDataType());
        if (this.getDefaultValue() != null && this.getDefaultValue().length() > 0) {
            sql.append(" DEFAULT ");
            if (DisplayType.isText(this.getAD_Reference_ID())) {
                sql.append(DB.TO_STRING(this.getDefaultValue()));
            } else {
                sql.append(this.getDefaultValue());
            }
        }
        if (this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table2, boolean setNullOption) {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlBase = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" MODIFY ").append(this.getColumnName());
        StringBuffer sqlDefault = new StringBuffer(sqlBase).append(" ").append(this.getSQLDataType()).append(" DEFAULT ");
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null && defaultValue.length() > 0 && defaultValue.indexOf("@") == -1) {
            if (!(!DisplayType.isText(this.getAD_Reference_ID()) && this.getAD_Reference_ID() != 17 && this.getAD_Reference_ID() != 20 || defaultValue.startsWith("'") || defaultValue.endsWith("'"))) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sqlDefault.append(defaultValue);
        } else {
            sqlDefault.append(" NULL ");
            defaultValue = null;
        }
        sql.append(sqlDefault);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table2.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append(sqlSet);
        }
        if (setNullOption) {
            StringBuffer sqlNull = new StringBuffer(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append(sqlNull);
        }
        return sql.toString();
    }

    private String getSQLDataType() {
        int dt = this.getAD_Reference_ID();
        if (DisplayType.isID(dt) || dt == 11) {
            return "NUMBER(10)";
        }
        if (DisplayType.isDate(dt)) {
            return "DATE";
        }
        if (DisplayType.isNumeric(dt)) {
            return "NUMBER";
        }
        if (dt == 23) {
            return "BLOB";
        }
        if (dt == 36) {
            return "CLOB";
        }
        if (dt == 20) {
            return "CHAR(1)";
        }
        if (dt == 17) {
            return "CHAR(" + this.getFieldLength() + ")";
        }
        if (!DisplayType.isText(dt)) {
            this.log.severe("Unhandled Data Type = " + dt);
        }
        return "NVARCHAR2(" + this.getFieldLength() + ")";
    }

    public String getConstraint(String tableName) {
        if (this.isKey()) {
            return "CONSTRAINT " + tableName + "_Key PRIMARY KEY (" + this.getColumnName() + ")";
        }
        return "";
    }
}

