/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.X_W_Click;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MClick
extends X_W_Click {
    private static CLogger s_log = CLogger.getCLogger(MClick.class);

    public static MClick[] getUnprocessed(Properties ctx) {
        ArrayList<MClick> list = new ArrayList<MClick>();
        String sql = "SELECT * FROM W_Click WHERE AD_Client_ID=? AND Processed = 'N'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MClick(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MClick[] retValue = new MClick[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MClick(Properties ctx, int W_Click_ID, String trxName) {
        super(ctx, W_Click_ID, trxName);
        if (W_Click_ID == 0) {
            this.setProcessed(false);
        }
    }

    public MClick(Properties ctx, String TargetURL, String trxName) {
        this(ctx, 0, trxName);
        this.setTargetURL(TargetURL);
    }

    public MClick(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setTargetURL(String TargetURL) {
        super.setTargetURL(TargetURL);
        super.setW_ClickCount_ID(0);
    }

    public void setW_ClickCount_ID() {
        String url = this.getTargetURL();
        if (url == null || url.length() == 0) {
            return;
        }
        String exactURL = url;
        if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        int dot = url.indexOf(46);
        int slash = url.indexOf(47);
        while (dot > slash && slash != -1) {
            url = url.substring(slash + 1);
            dot = url.indexOf(46);
            slash = url.indexOf(47);
        }
        if (slash != -1) {
            url = url.substring(0, slash);
        }
        this.log.fine(exactURL + " -> " + url);
        int W_ClickCount_ID = this.search(url, exactURL);
        if (W_ClickCount_ID == 0) {
            int lastDot = url.lastIndexOf(46);
            int firstDot = url.indexOf(46);
            while (lastDot != firstDot) {
                url = url.substring(firstDot + 1);
                lastDot = url.lastIndexOf(46);
                firstDot = url.indexOf(46);
            }
            this.log.fine(exactURL + " -> " + url);
            W_ClickCount_ID = this.search(url, exactURL);
        }
        if (W_ClickCount_ID == 0) {
            this.log.warning("Not found: " + url + " (" + exactURL + ") Referrer=" + this.getReferrer());
            return;
        }
        this.setProcessed(true);
        super.setW_ClickCount_ID(W_ClickCount_ID);
    }

    private int search(String url, String exactURL) {
        String sql = "SELECT W_ClickCount_ID, TargetURL FROM W_ClickCount WHERE TargetURL LIKE ?";
        int W_ClickCount_ID = 0;
        int exactW_ClickCount_ID = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, "%" + url + "%");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                W_ClickCount_ID = rs.getInt(1);
                if (!exactURL.equals(rs.getString(2))) continue;
                exactW_ClickCount_ID = W_ClickCount_ID;
                break;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (exactW_ClickCount_ID != 0) {
            W_ClickCount_ID = exactW_ClickCount_ID;
        }
        return W_ClickCount_ID;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getW_ClickCount_ID() == 0) {
            this.setW_ClickCount_ID();
        }
        return true;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 1000000);
        MClick[] clicks = MClick.getUnprocessed(Env.getCtx());
        int counter = 0;
        for (int i2 = 0; i2 < clicks.length; ++i2) {
            MClick click = clicks[i2];
            if (click.getW_ClickCount_ID() != 0) continue;
            click.setW_ClickCount_ID();
            if (click.getW_ClickCount_ID() == 0) continue;
            click.save();
            ++counter;
        }
        System.out.println("#" + counter);
    }
}

