/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.X_AD_ChangeLog;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MChangeLog
extends X_AD_ChangeLog {
    private static int[] s_changeLog = null;
    private static CLogger s_log = CLogger.getCLogger(MChangeLog.class);
    public static String NULL = "NULL";

    public static boolean isLogged(int AD_Table_ID) {
        int index;
        if (s_changeLog == null || s_changeLog.length == 0) {
            MChangeLog.fillChangeLog();
        }
        return (index = Arrays.binarySearch(s_changeLog, AD_Table_ID)) >= 0;
    }

    private static void fillChangeLog() {
        ArrayList<Integer> list = new ArrayList<Integer>(40);
        String sql = "SELECT t.AD_Table_ID FROM AD_Table t WHERE t.IsChangeLog='Y' OR EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='EntityType') ORDER BY t.AD_Table_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new Integer(rs.getInt(1)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_changeLog = new int[list.size()];
        for (int i2 = 0; i2 < s_changeLog.length; ++i2) {
            Integer id = (Integer)list.get(i2);
            MChangeLog.s_changeLog[i2] = id;
        }
        s_log.info("#" + s_changeLog.length);
    }

    public MChangeLog(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MChangeLog(Properties ctx, int AD_ChangeLog_ID, String trxName) {
        super(ctx, 0, trxName);
    }

    public MChangeLog(Properties ctx, int AD_ChangeLog_ID, String TrxName, int AD_Session_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue) {
        this(ctx, 0, null);
        if (AD_ChangeLog_ID == 0 && (AD_ChangeLog_ID = DB.getNextID(AD_Client_ID, "AD_ChangeLog", null)) <= 0) {
            this.log.severe("No NextID (" + AD_ChangeLog_ID + ")");
        }
        this.setAD_ChangeLog_ID(AD_ChangeLog_ID);
        this.setTrxName(TrxName);
        this.setAD_Session_ID(AD_Session_ID);
        this.setAD_Table_ID(AD_Table_ID);
        this.setAD_Column_ID(AD_Column_ID);
        this.setRecord_ID(Record_ID);
        this.setClientOrg(AD_Client_ID, AD_Org_ID);
        this.setOldValue(OldValue);
        this.setNewValue(NewValue);
        this.setDescription("Release 3.1.2_2006-11-02 " + Adempiere.getImplementationVersion());
    }

    public void setOldValue(Object OldValue) {
        if (OldValue == null) {
            super.setOldValue(NULL);
        } else {
            super.setOldValue(OldValue.toString());
        }
    }

    public boolean isOldNull() {
        String value = this.getOldValue();
        return value == null || value.equals(NULL);
    }

    public void setNewValue(Object NewValue) {
        if (NewValue == null) {
            super.setNewValue(NULL);
        } else {
            super.setNewValue(NewValue.toString());
        }
    }

    public boolean isNewNull() {
        String value = this.getNewValue();
        return value == null || value.equals(NULL);
    }
}

