/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_CashBook;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MCashBook
extends X_C_CashBook {
    private static CCache<Integer, MCashBook> s_cache = new CCache("", 20);
    private static CLogger s_log = CLogger.getCLogger(MCashBook.class);

    public static MCashBook get(Properties ctx, int C_CashBook_ID) {
        Integer key = new Integer(C_CashBook_ID);
        MCashBook retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCashBook(ctx, C_CashBook_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MCashBook get(Properties ctx, int AD_Org_ID, int C_Currency_ID) {
        for (MCashBook cb : s_cache.values()) {
            if (cb.getAD_Org_ID() != AD_Org_ID || cb.getC_Currency_ID() != C_Currency_ID) continue;
            return cb;
        }
        MCashBook retValue = null;
        String sql = "SELECT * FROM C_CashBook WHERE AD_Org_ID=? AND C_Currency_ID=? ORDER BY IsDefault DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Org_ID);
            pstmt.setInt(2, C_Currency_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCashBook(ctx, rs, null);
                Integer key = new Integer(retValue.getC_CashBook_ID());
                s_cache.put(key, retValue);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "get", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MCashBook(Properties ctx, int C_CashBook_ID, String trxName) {
        super(ctx, C_CashBook_ID, trxName);
    }

    public MCashBook(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            this.insert_Accounting("C_CashBook_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("C_Cashbook_Acct");
    }
}

