/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Locale;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MYear;
import org.compiere.model.X_C_Calendar;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCalendar
extends X_C_Calendar {
    private static CCache<Integer, MCalendar> s_cache = new CCache("C_Calendar", 20);

    public static MCalendar get(Properties ctx, int C_Calendar_ID) {
        Integer key = new Integer(C_Calendar_ID);
        MCalendar retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCalendar(ctx, C_Calendar_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MCalendar getDefault(Properties ctx, int AD_Client_ID) {
        MClientInfo info = MClientInfo.get(ctx, AD_Client_ID);
        return MCalendar.get(ctx, info.getC_Calendar_ID());
    }

    public static MCalendar getDefault(Properties ctx) {
        return MCalendar.getDefault(ctx, Env.getAD_Client_ID(ctx));
    }

    public MCalendar(Properties ctx, int C_Calendar_ID, String trxName) {
        super(ctx, C_Calendar_ID, trxName);
    }

    public MCalendar(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCalendar(MClient client) {
        super(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(client.getName() + " " + Msg.translate(client.getCtx(), "C_Calendar_ID"));
    }

    public MYear createYear(Locale locale) {
        if (this.get_ID() == 0) {
            return null;
        }
        MYear year = new MYear(this);
        if (year.save()) {
            year.createStdPeriods(locale);
        }
        return year;
    }
}

