/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_BankStatementLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankStatementLine
extends X_C_BankStatementLine {
    public MBankStatementLine(Properties ctx, int C_BankStatementLine_ID, String trxName) {
        super(ctx, C_BankStatementLine_ID, trxName);
        if (C_BankStatementLine_ID == 0) {
            this.setStmtAmt(Env.ZERO);
            this.setTrxAmt(Env.ZERO);
            this.setInterestAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setIsReversal(false);
        }
    }

    public MBankStatementLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatementLine(MBankStatement statement) {
        this(statement.getCtx(), 0, statement.get_TrxName());
        this.setClientOrg(statement);
        this.setC_BankStatement_ID(statement.getC_BankStatement_ID());
        this.setStatementLineDate(statement.getStatementDate());
    }

    public MBankStatementLine(MBankStatement statement, int lineNo) {
        this(statement);
        this.setLine(lineNo);
    }

    public void setStatementLineDate(Timestamp StatementLineDate) {
        super.setStatementLineDate(StatementLineDate);
        this.setValutaDate(StatementLineDate);
        this.setDateAcct(StatementLineDate);
    }

    public void setPayment(MPayment payment) {
        this.setC_Payment_ID(payment.getC_Payment_ID());
        this.setC_Currency_ID(payment.getC_Currency_ID());
        BigDecimal amt = payment.getPayAmt(true);
        this.setTrxAmt(amt);
        this.setStmtAmt(amt);
        this.setDescription(payment.getDescription());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getChargeAmt().signum() != 0 && this.getC_Charge_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Charge_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM C_BankStatementLine WHERE C_BankStatement_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_BankStatement_ID());
            this.setLine(ii);
        }
        if (this.getC_Payment_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            this.setC_BPartner_ID(payment.getC_BPartner_ID());
            if (payment.getC_Invoice_ID() != 0) {
                this.setC_Invoice_ID(payment.getC_Invoice_ID());
            }
        }
        if (this.getC_Invoice_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        }
        BigDecimal amt = this.getStmtAmt();
        amt = amt.subtract(this.getTrxAmt());
        if ((amt = amt.subtract(this.getInterestAmt())).compareTo(this.getChargeAmt()) != 0) {
            this.setChargeAmt(amt);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateHeader();
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.updateHeader();
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE C_BankStatement bs SET StatementDifference=(SELECT SUM(StmtAmt) FROM C_BankStatementLine bsl WHERE bsl.C_BankStatement_ID=bs.C_BankStatement_ID AND bsl.IsActive='Y') WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE C_BankStatement bs SET EndingBalance=BeginningBalance+StatementDifference WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        DB.executeUpdate(sql, this.get_TrxName());
    }
}

