/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MBank;
import org.compiere.model.X_C_BankAccount;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MBankAccount
extends X_C_BankAccount {
    private static CCache<Integer, MBankAccount> s_cache = new CCache("C_BankAccount", 5);

    public static MBankAccount get(Properties ctx, int C_BankAccount_ID) {
        Integer key = new Integer(C_BankAccount_ID);
        MBankAccount retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBankAccount(ctx, C_BankAccount_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MBankAccount(Properties ctx, int C_BankAccount_ID, String trxName) {
        super(ctx, C_BankAccount_ID, trxName);
        if (C_BankAccount_ID == 0) {
            this.setIsDefault(false);
            this.setBankAccountType("C");
            this.setCurrentBalance(Env.ZERO);
            this.setCreditLimit(Env.ZERO);
        }
    }

    public MBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBankAccount[").append(this.get_ID()).append("-").append(this.getAccountNo()).append("]");
        return sb.toString();
    }

    public MBank getBank() {
        return MBank.get(this.getCtx(), this.getC_Bank_ID());
    }

    public String getName() {
        return this.getBank().getName() + " " + this.getAccountNo();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            return this.insert_Accounting("C_BankAccount_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("C_BankAccount_Acct");
    }
}

