/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BP_BankAccount;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MBPBankAccount
extends X_C_BP_BankAccount {
    private static CLogger s_log = CLogger.getCLogger(MBPBankAccount.class);
    private MBank m_bank = null;

    public static MBPBankAccount[] getOfBPartner(Properties ctx, int C_BPartner_ID) {
        String sql = "SELECT * FROM C_BP_BankAccount WHERE C_BPartner_ID=? AND IsActive='Y'";
        ArrayList<MBPBankAccount> list = new ArrayList<MBPBankAccount>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBPBankAccount(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBPBankAccount[] retValue = new MBPBankAccount[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBPBankAccount(Properties ctx, int C_BP_BankAccount_ID, String trxName) {
        super(ctx, C_BP_BankAccount_ID, trxName);
        if (C_BP_BankAccount_ID == 0) {
            this.setIsACH(false);
            this.setBPBankAcctUse("B");
        }
    }

    public MBPBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPBankAccount(Properties ctx, MBPartner bp, MUser bpc, MLocation location) {
        this(ctx, 0, bp.get_TrxName());
        this.setIsACH(false);
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        this.setA_Name(bpc.getName());
        this.setA_EMail(bpc.getEMail());
        this.setA_Street(location.getAddress1());
        this.setA_City(location.getCity());
        this.setA_Zip(location.getPostal());
        this.setA_State(location.getRegionName(true));
        this.setA_Country(location.getCountryName());
    }

    public boolean isDirectDeposit() {
        if (!this.isACH()) {
            return false;
        }
        String s = this.getBPBankAcctUse();
        if (s == null) {
            return true;
        }
        return s.equals("B") || s.equals("T");
    }

    public boolean isDirectDebit() {
        if (!this.isACH()) {
            return false;
        }
        String s = this.getBPBankAcctUse();
        if (s == null) {
            return true;
        }
        return s.equals("B") || s.equals("D");
    }

    public MBank getBank() {
        int C_BP_BankAccount_ID = this.getC_BP_BankAccount_ID();
        if (C_BP_BankAccount_ID == 0) {
            return null;
        }
        if (this.m_bank == null) {
            this.m_bank = new MBank(this.getCtx(), C_BP_BankAccount_ID, this.get_TrxName());
        }
        return this.m_bank;
    }

    public String getRoutingNo() {
        MBank bank = this.getBank();
        String rt = super.getRoutingNo();
        if (bank != null) {
            rt = bank.getRoutingNo();
        }
        return rt;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isACH() && this.getBank() != null) {
            this.setRoutingNo(null);
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBP_BankAccount[").append(this.get_ID()).append(", Name=").append(this.getA_Name()).append("]");
        return sb.toString();
    }
}

