/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBOM;
import org.compiere.model.X_M_BOMProduct;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBOMProduct
extends X_M_BOMProduct {
    private static CLogger s_log = CLogger.getCLogger(MBOMProduct.class);
    private MBOM m_bom = null;

    public static MBOMProduct[] getOfBOM(MBOM bom) {
        ArrayList<MBOMProduct> list = new ArrayList<MBOMProduct>();
        String sql = "SELECT * FROM M_BOMProduct WHERE M_BOM_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, bom.get_TrxName());
            pstmt.setInt(1, bom.getM_BOM_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBOMProduct(bom.getCtx(), rs, bom.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBOMProduct[] retValue = new MBOMProduct[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBOMProduct(Properties ctx, int M_BOMProduct_ID, String trxName) {
        super(ctx, M_BOMProduct_ID, trxName);
        if (M_BOMProduct_ID == 0) {
            this.setBOMProductType("S");
            this.setBOMQty(Env.ONE);
            this.setIsPhantom(false);
            this.setLeadTimeOffset(0);
        }
    }

    public MBOMProduct(MBOM bom) {
        this(bom.getCtx(), 0, bom.get_TrxName());
        this.m_bom = bom;
    }

    public MBOMProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MBOM getBOM() {
        if (this.m_bom == null && this.getM_BOM_ID() != 0) {
            this.m_bom = MBOM.get(this.getCtx(), this.getM_BOM_ID());
        }
        return this.m_bom;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getBOMProductType().equals("X")) {
            if (this.getM_ProductBOM_ID() != 0) {
                this.setM_ProductBOM_ID(0);
            }
        } else if (this.getM_ProductBOM_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @M_ProductBOM_ID@"));
            return false;
        }
        if (this.getM_ProductOperation_ID() == 0) {
            if (this.getSeqNo() != 0) {
                this.setSeqNo(0);
            }
        } else if (this.getSeqNo() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @SeqNo@"));
            return false;
        }
        if (this.getM_AttributeSetInstance_ID() != 0) {
            this.getBOM();
            if (this.m_bom == null || !"O".equals(this.m_bom.getBOMType())) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "Reset @M_AttributeSetInstance_ID@: Not Make-to-Order"));
                this.setM_AttributeSetInstance_ID(0);
                return false;
            }
        }
        if ((this.getBOMProductType().equals("A") || this.getBOMProductType().equals("D")) && this.getM_BOMAlternative_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @M_BOMAlternative_ID@"));
            return false;
        }
        if (this.getM_ProductOperation_ID() != 0) {
            if (this.getSeqNo() == 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @SeqNo@"));
                return false;
            }
        } else {
            if (this.getSeqNo() != 0) {
                this.setSeqNo(0);
            }
            if (this.getLeadTimeOffset() != 0) {
                this.setLeadTimeOffset(0);
            }
        }
        if (this.getLine() == 0) {
            String sql = "SELECT NVL(MAX(Line),0)+10 FROM M_BOMProduct WHERE M_BOM_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_BOM_ID());
            this.setLine(ii);
        }
        return true;
    }
}

