/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.X_M_Attribute;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MAttribute
extends X_M_Attribute {
    private static CLogger s_log = CLogger.getCLogger(MAttribute.class);
    private MAttributeValue[] m_values = null;

    public static MAttribute[] getOfClient(Properties ctx, boolean onlyProductAttributes, boolean onlyListAttributes) {
        ArrayList<MAttribute> list = new ArrayList<MAttribute>();
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String sql = "SELECT * FROM M_Attribute WHERE AD_Client_ID=? AND IsActive='Y'";
        if (onlyProductAttributes) {
            sql = sql + " AND IsInstanceAttribute='N'";
        }
        if (onlyListAttributes) {
            sql = sql + " AND AttributeValueType='L'";
        }
        sql = sql + " ORDER BY Name";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAttribute(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAttribute[] retValue = new MAttribute[list.size()];
        list.toArray(retValue);
        s_log.fine("AD_Client_ID=" + AD_Client_ID + " - #" + retValue.length);
        return retValue;
    }

    public MAttribute(Properties ctx, int M_Attribute_ID, String trxName) {
        super(ctx, M_Attribute_ID, trxName);
        if (M_Attribute_ID == 0) {
            this.setAttributeValueType("S");
            this.setIsInstanceAttribute(false);
            this.setIsMandatory(false);
        }
    }

    public MAttribute(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttributeValue[] getMAttributeValues() {
        if (this.m_values == null && "L".equals(this.getAttributeValueType())) {
            ArrayList<MAttributeValue> list = new ArrayList<MAttributeValue>();
            if (!this.isMandatory()) {
                list.add(null);
            }
            String sql = "SELECT * FROM M_AttributeValue WHERE M_Attribute_ID=? ORDER BY Value";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getM_Attribute_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MAttributeValue(this.getCtx(), rs, null));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException ex) {
                this.log.log(Level.SEVERE, sql, ex);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException ex1) {
                // empty catch block
            }
            pstmt = null;
            this.m_values = new MAttributeValue[list.size()];
            list.toArray(this.m_values);
        }
        return this.m_values;
    }

    public MAttributeInstance getMAttributeInstance(int M_AttributeSetInstance_ID) {
        MAttributeInstance retValue = null;
        String sql = "SELECT * FROM M_AttributeInstance WHERE M_Attribute_ID=? AND M_AttributeSetInstance_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_Attribute_ID());
            pstmt.setInt(2, M_AttributeSetInstance_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MAttributeInstance(this.getCtx(), rs, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        return retValue;
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, MAttributeValue value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = value != null ? new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value.getM_AttributeValue_ID(), value.getName(), this.get_TrxName()) : new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, 0, null, this.get_TrxName());
        } else if (value != null) {
            instance.setM_AttributeValue_ID(value.getM_AttributeValue_ID());
            instance.setValue(value.getName());
        } else {
            instance.setM_AttributeValue_ID(0);
            instance.setValue(null);
        }
        instance.save();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, String value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValue(value);
        }
        instance.save();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, BigDecimal value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValueNumber(value);
        }
        instance.save();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAttribute[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getAttributeValueType()).append(",Instance=").append(this.isInstanceAttribute()).append("]");
        return sb.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && this.is_ValueChanged("IsInstanceAttribute") && this.isInstanceAttribute()) {
            String sql = "UPDATE M_AttributeSet mas SET IsInstanceAttribute='Y' WHERE IsInstanceAttribute='N' AND EXISTS (SELECT * FROM M_AttributeUse mau WHERE mas.M_AttributeSet_ID=mau.M_AttributeSet_ID AND mau.M_Attribute_ID=" + this.getM_Attribute_ID() + ")";
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("AttributeSet Instance set #" + no);
        }
        return success;
    }
}

