/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.GregorianCalendar;
import org.compiere.model.MResourceAssignment;
import org.compiere.util.Language;
import org.compiere.util.TimeUtil;

public class MAssignmentSlot
implements Comparator {
    public static final int STATUS_NotAvailable = 0;
    public static final int STATUS_UnAvailable = 11;
    public static final int STATUS_NonBusinessDay = 12;
    public static final int STATUS_NotInSlotDay = 21;
    public static final int STATUS_NotInSlotTime = 22;
    public static final int STATUS_NotConfirmed = 101;
    public static final int STATUS_Confirmed = 102;
    public static final int STATUS_TimeSlot = 100000;
    private Timestamp m_startTime;
    private Timestamp m_endTime;
    private String m_name;
    private String m_description;
    private int m_status = 0;
    private int m_yStart = 0;
    private int m_yEnd = 0;
    private int m_xPos = 0;
    private int m_xMax = 1;
    private MResourceAssignment m_mAssignment;
    private Language m_language = Language.getLoginLanguage();
    public static final int DISPLAY_ALL = 0;
    public static final int DISPLAY_TIME_FROM = 1;
    public static final int DISPLAY_TIME_FROM_TO = 1;
    public static final int DISPLAY_DATETIME_FROM_TO = 1;
    public static final int DISPLAY_NAME = 1;
    public static final int DISPLAY_NAME_DESCRIPTION = 1;
    public static final int DISPLAY_FULL = 1;
    private int m_displayMode = 1;

    public MAssignmentSlot() {
        this(null, null, null, null, 100000);
    }

    public MAssignmentSlot(Timestamp startTime, Timestamp endTime) {
        this(startTime, endTime, null, null, 100000);
        this.setDisplay(1);
    }

    public MAssignmentSlot(long startTime, long endTime) {
        this(new Timestamp(startTime), new Timestamp(endTime), null, null, 100000);
        this.setDisplay(1);
    }

    public MAssignmentSlot(Timestamp startTime, Timestamp endTime, String name, String description, int status) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setName(name);
        this.setDescription(description);
        this.setStatus(status);
    }

    public MAssignmentSlot(MResourceAssignment assignment) {
        this.setStatus(assignment.isConfirmed() ? 102 : 101);
        this.setMAssignment(assignment);
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    public int getStatus() {
        return this.m_status;
    }

    public boolean isAssignment() {
        return this.m_status == 101 || this.m_status == 102;
    }

    public Color getColor(boolean background) {
        if (this.m_status == 0) {
            return background ? Color.gray : Color.magenta;
        }
        if (this.m_status == 11) {
            return background ? Color.gray : Color.pink;
        }
        if (this.m_status == 12) {
            return background ? Color.lightGray : Color.red;
        }
        if (this.m_status == 21 || this.m_status == 22) {
            return background ? Color.lightGray : Color.black;
        }
        if (this.m_status == 101) {
            return background ? Color.blue : Color.white;
        }
        if (this.m_status == 102) {
            return background ? Color.blue : Color.black;
        }
        return background ? Color.black : Color.white;
    }

    public Timestamp getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.m_startTime = startTime == null ? new Timestamp(System.currentTimeMillis()) : startTime;
    }

    public Timestamp getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.m_endTime = endTime == null ? this.m_startTime : endTime;
    }

    public void setMAssignment(MResourceAssignment assignment) {
        if (assignment == null) {
            return;
        }
        if (!this.isAssignment()) {
            throw new IllegalArgumentException("Assignment Slot not an Assignment");
        }
        this.m_mAssignment = assignment;
        this.setStartTime(this.m_mAssignment.getAssignDateFrom());
        this.setEndTime(this.m_mAssignment.getAssignDateTo());
        this.setName(this.m_mAssignment.getName());
        this.setDescription(this.m_mAssignment.getDescription());
        this.setStatus(this.m_mAssignment.isConfirmed() ? 102 : 101);
    }

    public MResourceAssignment getMAssignment() {
        return this.m_mAssignment;
    }

    public void setName(String name) {
        this.m_name = name == null ? "" : name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDescription(String description) {
        this.m_description = description == null ? "" : description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setY(int yStart, int yEnd) {
        this.m_yStart = yStart;
        this.m_yEnd = yEnd;
    }

    public int getYStart() {
        return this.m_yStart;
    }

    public int getYEnd() {
        return this.m_yEnd;
    }

    public void setX(int xPos, int xMax) {
        this.m_xPos = xPos;
        if (xMax > this.m_xMax) {
            this.m_xMax = xMax;
        }
    }

    public int getXPos() {
        return this.m_xPos;
    }

    public int getXMax() {
        return this.m_xMax;
    }

    public void setLanguage(Language language) {
        this.m_language = language;
    }

    public void setDisplay(int displayMode) {
        this.m_displayMode = displayMode;
    }

    public String toString() {
        if (this.m_displayMode == 1) {
            return this.getInfoTimeFrom();
        }
        if (this.m_displayMode == 1) {
            return this.getInfoTimeFromTo();
        }
        if (this.m_displayMode == 1) {
            return this.getInfoDateTimeFromTo();
        }
        if (this.m_displayMode == 1) {
            return this.m_name;
        }
        if (this.m_displayMode == 1) {
            return this.getInfoNameDescription();
        }
        if (this.m_displayMode == 1) {
            return this.getInfo();
        }
        StringBuffer sb = new StringBuffer("MAssignmentSlot[");
        sb.append(this.m_startTime).append("-").append(this.m_endTime).append("-Status=").append(this.m_status).append(",Name=").append(this.m_name).append(",").append(this.m_description).append("]");
        return sb.toString();
    }

    public String getInfoTimeFrom() {
        return this.m_language.getTimeFormat().format(this.m_startTime);
    }

    public String getInfoTimeFromTo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_language.getTimeFormat().format(this.m_startTime)).append(" - ").append(this.m_language.getTimeFormat().format(this.m_endTime));
        return sb.toString();
    }

    public String getInfoDateTimeFromTo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_language.getDateTimeFormat().format(this.m_startTime)).append(" - ");
        if (TimeUtil.isSameDay(this.m_startTime, this.m_endTime)) {
            sb.append(this.m_language.getTimeFormat().format(this.m_endTime));
        } else {
            this.m_language.getDateTimeFormat().format(this.m_endTime);
        }
        return sb.toString();
    }

    public String getInfoNameDescription() {
        StringBuffer sb = new StringBuffer(this.m_name);
        if (this.m_description.length() > 0) {
            sb.append(" (").append(this.m_description).append(")");
        }
        return sb.toString();
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer(this.getInfoDateTimeFromTo());
        sb.append(": ").append(this.m_name);
        if (this.m_description.length() > 0) {
            sb.append(" (").append(this.m_description).append(")");
        }
        return sb.toString();
    }

    public boolean inSlot(Timestamp time, boolean endTime) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        cal.set(1, 1970);
        cal.set(6, 1);
        if (endTime && cal.get(11) == 0 && cal.get(12) == 0) {
            cal.set(11, 23);
            cal.set(12, 59);
        }
        Time compare = new Time(cal.getTimeInMillis());
        cal.setTime(this.m_startTime);
        cal.set(1, 1970);
        cal.set(6, 1);
        Time start = new Time(cal.getTimeInMillis());
        cal.setTime(this.m_endTime);
        cal.set(1, 1970);
        cal.set(6, 1);
        if (cal.get(11) == 0 && cal.get(12) == 0) {
            cal.set(11, 23);
            cal.set(12, 59);
        }
        Time end = new Time(cal.getTimeInMillis());
        if (compare.before(start)) {
            return false;
        }
        if (compare.after(end)) {
            return false;
        }
        if (!endTime && compare.equals(start)) {
            return true;
        }
        if (endTime && compare.equals(end)) {
            return true;
        }
        return compare.before(end);
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof MAssignmentSlot) || !(o2 instanceof MAssignmentSlot)) {
            throw new ClassCastException("MAssignmentSlot.compare arguments not MAssignmentSlot");
        }
        MAssignmentSlot s1 = (MAssignmentSlot)o1;
        MAssignmentSlot s2 = (MAssignmentSlot)o2;
        int result = s1.getStartTime().compareTo(s2.getStartTime());
        if (result != 0) {
            return result;
        }
        result = s2.getStatus() - s1.getStatus();
        if (result != 0) {
            return result;
        }
        result = s1.getEndTime().compareTo(s2.getEndTime());
        if (result != 0) {
            return result;
        }
        result = s1.getName().compareTo(s2.getName());
        if (result != 0) {
            return result;
        }
        return s1.getDescription().compareTo(s2.getDescription());
    }

    public boolean equals(Object obj) {
        MAssignmentSlot cmp;
        return obj instanceof MAssignmentSlot && this.m_startTime.equals((cmp = (MAssignmentSlot)obj).getStartTime()) && this.m_endTime.equals(cmp.getEndTime()) && this.m_status == cmp.getStatus() && this.m_name.equals(cmp.getName()) && this.m_description.equals(cmp.getDescription());
    }

    public int hashCode() {
        return this.m_startTime.hashCode() + this.m_endTime.hashCode() + this.m_status + this.m_name.hashCode() + this.m_description.hashCode();
    }
}

