/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductDownload;
import org.compiere.model.X_A_Asset;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAsset
extends X_A_Asset {
    private static CLogger s_log = CLogger.getCLogger(MAsset.class);
    private MProduct m_product = null;

    public static MAsset getFromShipment(Properties ctx, int M_InOutLine_ID, String trxName) {
        MAsset retValue = null;
        String sql = "SELECT * FROM A_Asset WHERE M_InOutLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_InOutLine_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MAsset(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MAsset(Properties ctx, int A_Asset_ID, String trxName) {
        super(ctx, A_Asset_ID, trxName);
        if (A_Asset_ID == 0) {
            this.setIsDepreciated(false);
            this.setIsFullyDepreciated(false);
            this.setIsInPosession(false);
            this.setIsOwned(false);
            this.setIsDisposed(false);
            this.setM_AttributeSetInstance_ID(0);
            this.setQty(Env.ONE);
        }
    }

    public MAsset(Properties ctx, int A_Asset_ID) {
        this(ctx, A_Asset_ID, null);
    }

    public MAsset(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAsset(MInOut shipment, MInOutLine shipLine, int deliveryCount) {
        this(shipment.getCtx(), 0, shipment.get_TrxName());
        this.setClientOrg(shipment);
        this.setValueNameDescription(shipment, shipLine, deliveryCount);
        this.setAssetServiceDate(shipment.getMovementDate());
        this.setIsOwned(false);
        this.setC_BPartner_ID(shipment.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(shipment.getC_BPartner_Location_ID());
        this.setAD_User_ID(shipment.getAD_User_ID());
        MProduct product = shipLine.getProduct();
        this.setM_Product_ID(product.getM_Product_ID());
        this.setA_Asset_Group_ID(product.getA_Asset_Group_ID());
        this.setGuaranteeDate(TimeUtil.addDays(shipment.getMovementDate(), product.getGuaranteeDays()));
        this.setVersionNo(product.getVersionNo());
        if (shipLine.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), shipLine.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            this.setLot(asi.getLot());
            this.setSerNo(asi.getSerNo());
        }
        this.setHelp(shipLine.getDescription());
        if (deliveryCount != 0) {
            this.setQty(shipLine.getMovementQty());
        }
        this.setM_InOutLine_ID(shipLine.getM_InOutLine_ID());
        MAssetGroup ag = MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
        if (!ag.isCreateAsActive()) {
            this.setIsActive(false);
        }
    }

    public void setValueNameDescription(MInOut shipment, MInOutLine line, int deliveryCount) {
        MProduct product = line.getProduct();
        MBPartner partner = shipment.getBPartner();
        this.setValueNameDescription(shipment, deliveryCount, product, partner);
    }

    public void setValueNameDescription(MInOut shipment, int deliveryCount, MProduct product, MBPartner partner) {
        String value;
        String documentNo = "_" + shipment.getDocumentNo();
        if (deliveryCount > 1) {
            documentNo = documentNo + "_" + deliveryCount;
        }
        if ((value = partner.getValue() + "_" + product.getValue()).length() > 40 - documentNo.length()) {
            value = value.substring(0, 40 - documentNo.length()) + documentNo;
        }
        this.setValue(value);
        String name = partner.getName() + " - " + product.getName();
        if (name.length() > 60) {
            name = name.substring(0, 60);
        }
        this.setName(name);
        String description = product.getDescription();
        this.setDescription(description);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public BigDecimal getQty() {
        BigDecimal qty = super.getQty();
        if (qty == null || qty.equals(Env.ZERO)) {
            this.setQty(Env.ONE);
        }
        return super.getQty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAsset[").append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAssetDelivery[] getDeliveries() {
        ArrayList<MAssetDelivery> list = new ArrayList<MAssetDelivery>();
        String sql = "SELECT * FROM A_Asset_Delivery WHERE A_Asset_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getA_Asset_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAssetDelivery(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MAssetDelivery[] retValue = new MAssetDelivery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int getDeliveryCount() {
        String sql = "SELECT COUNT(*) FROM A_Asset_Delivery WHERE A_Asset_ID=?";
        return DB.getSQLValue(this.get_TrxName(), sql, this.getA_Asset_ID());
    }

    public boolean isDownloadable() {
        if (!this.isActive()) {
            return false;
        }
        Timestamp guarantee = this.getGuaranteeDate();
        if (guarantee == null) {
            return false;
        }
        guarantee = TimeUtil.getDay(guarantee);
        Timestamp now = TimeUtil.getDay(System.currentTimeMillis());
        if (!now.after(guarantee)) {
            this.getProduct();
            return this.m_product != null && this.m_product.hasDownloads();
        }
        return false;
    }

    public String getProductVersionNo() {
        return this.getProduct().getVersionNo();
    }

    public int getProductR_MailText_ID() {
        return this.getProduct().getR_MailText_ID();
    }

    private MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public MProductDownload[] getProductDownloads() {
        if (this.m_product == null) {
            this.getProduct();
        }
        if (this.m_product != null) {
            return this.m_product.getProductDownloads(false);
        }
        return null;
    }

    public String[] getDownloadNames() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            for (int i2 = 0; i2 < retValue.length; ++i2) {
                retValue[i2] = dls[i2].getName();
            }
            this.log.fine("#" + dls.length);
            return retValue;
        }
        return new String[0];
    }

    public String[] getDownloadURLs() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            for (int i2 = 0; i2 < retValue.length; ++i2) {
                String url = dls[i2].getDownloadURL();
                int pos = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
                if (pos != -1) {
                    url = url.substring(pos + 1);
                }
                retValue[i2] = url;
            }
            return retValue;
        }
        return new String[0];
    }

    protected boolean beforeSave(boolean newRecord) {
        this.getQty();
        return true;
    }

    public MAssetDelivery confirmDelivery(EMail email, int AD_User_ID) {
        this.setVersionNo(this.getProductVersionNo());
        MAssetDelivery ad = new MAssetDelivery(this, email, AD_User_ID);
        return ad;
    }

    public MAssetDelivery confirmDelivery(HttpServletRequest request, int AD_User_ID) {
        this.setVersionNo(this.getProductVersionNo());
        this.setLifeUseUnits(this.getLifeUseUnits() + 1);
        MAssetDelivery ad = new MAssetDelivery(this, request, AD_User_ID);
        return ad;
    }
}

