/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_AD_Archive;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MArchive
extends X_AD_Archive {
    private static CLogger s_log = CLogger.getCLogger(MArchive.class);
    private Integer m_inflated = null;
    private Integer m_deflated = null;

    public static MArchive[] get(Properties ctx, String whereClause) {
        ArrayList<MArchive> list = new ArrayList<MArchive>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_Archive WHERE AD_Client_ID=?";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + whereClause;
        }
        sql = sql + " ORDER BY Created";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MArchive(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (list.size() == 0) {
            s_log.fine(sql);
        } else {
            s_log.finer(sql);
        }
        MArchive[] retValue = new MArchive[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MArchive(Properties ctx, int AD_Archive_ID, String trxName) {
        super(ctx, AD_Archive_ID, trxName);
    }

    public MArchive(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MArchive(Properties ctx, PrintInfo info, String trxName) {
        this(ctx, 0, trxName);
        this.setName(info.getName());
        this.setIsReport(info.isReport());
        this.setAD_Process_ID(info.getAD_Process_ID());
        this.setAD_Table_ID(info.getAD_Table_ID());
        this.setRecord_ID(info.getRecord_ID());
        this.setC_BPartner_ID(info.getC_BPartner_ID());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MArchive[");
        sb.append(this.get_ID()).append(",Name=").append(this.getName());
        if (this.m_inflated != null) {
            sb.append(",Inflated=" + this.m_inflated);
        }
        if (this.m_deflated != null) {
            sb.append(",Deflated=" + this.m_deflated);
        }
        sb.append("]");
        return sb.toString();
    }

    public byte[] getBinaryData() {
        byte[] deflatedData = super.getBinaryData();
        this.m_deflated = null;
        this.m_inflated = null;
        if (deflatedData == null) {
            return null;
        }
        this.log.fine("ZipSize=" + deflatedData.length);
        this.m_deflated = new Integer(deflatedData.length);
        if (deflatedData.length == 0) {
            return null;
        }
        byte[] inflatedData = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(deflatedData);
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            if (entry != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                inflatedData = out.toByteArray();
                this.log.fine("Size=" + inflatedData.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                this.m_inflated = new Integer(inflatedData.length);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            inflatedData = null;
        }
        return inflatedData;
    }

    public InputStream getInputStream() {
        byte[] inflatedData = this.getBinaryData();
        if (inflatedData == null) {
            return null;
        }
        return new ByteArrayInputStream(inflatedData);
    }

    public void setBinaryData(byte[] inflatedData) {
        if (inflatedData == null || inflatedData.length == 0) {
            throw new IllegalArgumentException("InflatedData is NULL");
        }
        this.m_inflated = new Integer(inflatedData.length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        zip.setComment("adempiere");
        byte[] deflatedData = null;
        try {
            ZipEntry entry = new ZipEntry("AdempiereArchive");
            entry.setTime(System.currentTimeMillis());
            entry.setMethod(8);
            zip.putNextEntry(entry);
            zip.write(inflatedData, 0, inflatedData.length);
            zip.closeEntry();
            this.log.fine(entry.getCompressedSize() + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
            zip.close();
            deflatedData = out.toByteArray();
            this.log.fine("Length=" + inflatedData.length);
            this.m_deflated = new Integer(deflatedData.length);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            deflatedData = null;
            this.m_deflated = null;
        }
        super.setBinaryData(deflatedData);
    }

    public String getCreatedByName() {
        String name = "?";
        String sql = "SELECT Name FROM AD_User WHERE AD_User_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getCreatedBy());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return name;
    }

    protected boolean beforeSave(boolean newRecord) {
        byte[] data = super.getBinaryData();
        if (data == null || data.length == 0) {
            return false;
        }
        this.log.fine(this.toString());
        return true;
    }
}

